/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.net.Uri;
import com.squareup.picasso.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Request {
    public final boolean centerCrop;
    public final boolean centerInside;
    public final Bitmap.Config config;
    public final boolean hasRotationPivot;
    public final int resourceId;
    public final float rotationDegrees;
    public final float rotationPivotX;
    public final float rotationPivotY;
    public final int targetHeight;
    public final int targetWidth;
    public final List<Transformation> transformations;
    public final Uri uri;

    /*
     * Enabled aggressive block sorting
     */
    private Request(Uri uri, int n2, List<Transformation> list, int n3, int n4, boolean bl, boolean bl2, float f2, float f3, float f4, boolean bl3, Bitmap.Config config) {
        this.uri = uri;
        this.resourceId = n2;
        this.transformations = list == null ? null : Collections.unmodifiableList(list);
        this.targetWidth = n3;
        this.targetHeight = n4;
        this.centerCrop = bl;
        this.centerInside = bl2;
        this.rotationDegrees = f2;
        this.rotationPivotX = f3;
        this.rotationPivotY = f4;
        this.hasRotationPivot = bl3;
        this.config = config;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getName() {
        if (this.uri == null) return Integer.toHexString(this.resourceId);
        return this.uri.getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hasCustomTransformations() {
        if (this.transformations == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSize() {
        if (this.targetWidth == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean needsMatrixTransform() {
        if (this.targetWidth != 0) return true;
        if (this.rotationDegrees == 0.0f) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean needsTransformation() {
        if (this.needsMatrixTransform()) return true;
        if (!this.hasCustomTransformations()) return false;
        return true;
    }

    public static final class Builder {
        private boolean centerCrop;
        private boolean centerInside;
        private Bitmap.Config config;
        private boolean hasRotationPivot;
        private int resourceId;
        private float rotationDegrees;
        private float rotationPivotX;
        private float rotationPivotY;
        private int targetHeight;
        private int targetWidth;
        private List<Transformation> transformations;
        private Uri uri;

        public Builder(int n2) {
            this.setResourceId(n2);
        }

        public Builder(Uri uri) {
            this.setUri(uri);
        }

        Builder(Uri uri, int n2) {
            this.uri = uri;
            this.resourceId = n2;
        }

        private Builder(Request request) {
            this.uri = request.uri;
            this.resourceId = request.resourceId;
            this.targetWidth = request.targetWidth;
            this.targetHeight = request.targetHeight;
            this.centerCrop = request.centerCrop;
            this.centerInside = request.centerInside;
            this.rotationDegrees = request.rotationDegrees;
            this.rotationPivotX = request.rotationPivotX;
            this.rotationPivotY = request.rotationPivotY;
            this.hasRotationPivot = request.hasRotationPivot;
            if (request.transformations != null) {
                this.transformations = new ArrayList<Transformation>(request.transformations);
            }
            this.config = request.config;
        }

        public Request build() {
            if (this.centerInside && this.centerCrop) {
                throw new IllegalStateException("Center crop and center inside can not be used together.");
            }
            if (this.centerCrop && this.targetWidth == 0) {
                throw new IllegalStateException("Center crop requires calling resize.");
            }
            if (this.centerInside && this.targetWidth == 0) {
                throw new IllegalStateException("Center inside requires calling resize.");
            }
            return new Request(this.uri, this.resourceId, this.transformations, this.targetWidth, this.targetHeight, this.centerCrop, this.centerInside, this.rotationDegrees, this.rotationPivotX, this.rotationPivotY, this.hasRotationPivot, this.config);
        }

        public Builder centerCrop() {
            if (this.centerInside) {
                throw new IllegalStateException("Center crop can not be used after calling centerInside");
            }
            this.centerCrop = true;
            return this;
        }

        public Builder centerInside() {
            if (this.centerCrop) {
                throw new IllegalStateException("Center inside can not be used after calling centerCrop");
            }
            this.centerInside = true;
            return this;
        }

        public Builder clearCenterCrop() {
            this.centerCrop = false;
            return this;
        }

        public Builder clearCenterInside() {
            this.centerInside = false;
            return this;
        }

        public Builder clearResize() {
            this.targetWidth = 0;
            this.targetHeight = 0;
            this.centerCrop = false;
            this.centerInside = false;
            return this;
        }

        public Builder clearRotation() {
            this.rotationDegrees = 0.0f;
            this.rotationPivotX = 0.0f;
            this.rotationPivotY = 0.0f;
            this.hasRotationPivot = false;
            return this;
        }

        public Builder config(Bitmap.Config config) {
            this.config = config;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean hasImage() {
            if (this.uri != null) return true;
            if (this.resourceId == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean hasSize() {
            if (this.targetWidth == 0) return false;
            return true;
        }

        public Builder resize(int n2, int n3) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("Width must be positive number.");
            }
            if (n3 <= 0) {
                throw new IllegalArgumentException("Height must be positive number.");
            }
            this.targetWidth = n2;
            this.targetHeight = n3;
            return this;
        }

        public Builder rotate(float f2) {
            this.rotationDegrees = f2;
            return this;
        }

        public Builder rotate(float f2, float f3, float f4) {
            this.rotationDegrees = f2;
            this.rotationPivotX = f3;
            this.rotationPivotY = f4;
            this.hasRotationPivot = true;
            return this;
        }

        public Builder setResourceId(int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Image resource ID may not be 0.");
            }
            this.resourceId = n2;
            this.uri = null;
            return this;
        }

        public Builder setUri(Uri uri) {
            if (uri == null) {
                throw new IllegalArgumentException("Image URI may not be null.");
            }
            this.uri = uri;
            this.resourceId = 0;
            return this;
        }

        public Builder transform(Transformation transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("Transformation must not be null.");
            }
            if (this.transformations == null) {
                this.transformations = new ArrayList<Transformation>(2);
            }
            this.transformations.add(transformation);
            return this;
        }
    }
}

