/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.widget.ImageView;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.DeferredRequestCreator;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.LruCache;
import com.squareup.picasso.PicassoExecutorService;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Stats;
import com.squareup.picasso.StatsSnapshot;
import com.squareup.picasso.Target;
import com.squareup.picasso.Utils;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;

public class Picasso {
    static final Handler HANDLER = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message object2) {
            switch (((Message)object2).what) {
                default: {
                    throw new AssertionError((Object)("Unknown handler message received: " + ((Message)object2).what));
                }
                case 8: {
                    for (Object object2 : (List)((Message)object2).obj) {
                        ((BitmapHunter)object2).picasso.complete((BitmapHunter)object2);
                    }
                    break;
                }
                case 3: {
                    object2 = (Action)((Message)object2).obj;
                    ((Action)object2).picasso.cancelExistingRequest(((Action)object2).getTarget());
                }
            }
        }
    };
    static Picasso singleton = null;
    final Cache cache;
    private final CleanupThread cleanupThread;
    final Context context;
    boolean debugging;
    final Dispatcher dispatcher;
    private final Listener listener;
    final ReferenceQueue<Object> referenceQueue;
    private final RequestTransformer requestTransformer;
    boolean shutdown;
    final Stats stats;
    final Map<Object, Action> targetToAction;
    final Map<ImageView, DeferredRequestCreator> targetToDeferredRequestCreator;

    Picasso(Context context, Dispatcher dispatcher, Cache cache, Listener listener, RequestTransformer requestTransformer, Stats stats, boolean bl) {
        this.context = context;
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.listener = listener;
        this.requestTransformer = requestTransformer;
        this.stats = stats;
        this.targetToAction = new WeakHashMap<Object, Action>();
        this.targetToDeferredRequestCreator = new WeakHashMap<ImageView, DeferredRequestCreator>();
        this.debugging = bl;
        this.referenceQueue = new ReferenceQueue();
        this.cleanupThread = new CleanupThread(this.referenceQueue, HANDLER);
        this.cleanupThread.start();
    }

    private void cancelExistingRequest(Object object) {
        Action action = this.targetToAction.remove(object);
        if (action != null) {
            action.cancel();
            this.dispatcher.dispatchCancel(action);
        }
        if (object instanceof ImageView) {
            object = (ImageView)object;
            if ((object = this.targetToDeferredRequestCreator.remove(object)) != null) {
                ((DeferredRequestCreator)object).cancel();
            }
        }
    }

    public static Picasso with(Context context) {
        if (singleton == null) {
            singleton = new Builder(context).build();
        }
        return singleton;
    }

    public void cancelRequest(ImageView imageView) {
        this.cancelExistingRequest(imageView);
    }

    public void cancelRequest(Target target) {
        this.cancelExistingRequest(target);
    }

    /*
     * Enabled aggressive block sorting
     */
    void complete(BitmapHunter object) {
        Object object2 = ((BitmapHunter)object).getActions();
        if (object2.isEmpty()) {
            return;
        }
        Uri uri = ((BitmapHunter)object).getData().uri;
        Exception exception = ((BitmapHunter)object).getException();
        Bitmap bitmap = ((BitmapHunter)object).getResult();
        LoadedFrom loadedFrom = ((BitmapHunter)object).getLoadedFrom();
        Iterator<Action> iterator = object2.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (this.listener == null) return;
                if (exception == null) return;
                this.listener.onImageLoadFailed(this, uri, exception);
                return;
            }
            object2 = iterator.next();
            if (((Action)object2).isCancelled()) continue;
            this.targetToAction.remove(((Action)object2).getTarget());
            if (bitmap != null) {
                if (loadedFrom == null) {
                    throw new AssertionError((Object)"LoadedFrom cannot be null.");
                }
                ((Action)object2).complete(bitmap, loadedFrom);
                continue;
            }
            ((Action)object2).error();
        }
    }

    void defer(ImageView imageView, DeferredRequestCreator deferredRequestCreator) {
        this.targetToDeferredRequestCreator.put(imageView, deferredRequestCreator);
    }

    void enqueueAndSubmit(Action action) {
        Object t2 = action.getTarget();
        if (t2 != null) {
            this.cancelExistingRequest(t2);
            this.targetToAction.put(t2, action);
        }
        this.submit(action);
    }

    public StatsSnapshot getSnapshot() {
        return this.stats.createSnapshot();
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public RequestCreator load(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Resource ID must not be zero.");
        }
        return new RequestCreator(this, null, n2);
    }

    public RequestCreator load(Uri uri) {
        return new RequestCreator(this, uri, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestCreator load(File object) {
        if (object != null) return this.load(Uri.fromFile((File)object));
        return new RequestCreator(this, null, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestCreator load(String object) {
        if (object == null) {
            return new RequestCreator(this, null, 0);
        }
        if (((String)object).trim().length() != 0) return this.load(Uri.parse((String)object));
        throw new IllegalArgumentException("Path must not be empty.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Bitmap quickMemoryCacheCheck(String string2) {
        if ((string2 = this.cache.get(string2)) != null) {
            this.stats.dispatchCacheHit();
            return string2;
        }
        this.stats.dispatchCacheMiss();
        return string2;
    }

    public void setDebugging(boolean bl) {
        this.debugging = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutdown() {
        if (this == singleton) {
            throw new UnsupportedOperationException("Default singleton instance cannot be shutdown.");
        }
        if (this.shutdown) {
            return;
        }
        this.cache.clear();
        this.cleanupThread.shutdown();
        this.stats.shutdown();
        this.dispatcher.shutdown();
        Iterator<DeferredRequestCreator> iterator = this.targetToDeferredRequestCreator.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().cancel();
        }
        this.targetToDeferredRequestCreator.clear();
        this.shutdown = true;
    }

    void submit(Action action) {
        this.dispatcher.dispatchSubmit(action);
    }

    Request transformRequest(Request request) {
        Request request2 = this.requestTransformer.transformRequest(request);
        if (request2 == null) {
            throw new IllegalStateException("Request transformer " + this.requestTransformer.getClass().getCanonicalName() + " returned null for " + request);
        }
        return request2;
    }

    public static class Builder {
        private Cache cache;
        private final Context context;
        private boolean debugging;
        private Downloader downloader;
        private Listener listener;
        private ExecutorService service;
        private RequestTransformer transformer;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public Picasso build() {
            Context context = this.context;
            if (this.downloader == null) {
                this.downloader = Utils.createDefaultDownloader(context);
            }
            if (this.cache == null) {
                this.cache = new LruCache(context);
            }
            if (this.service == null) {
                this.service = new PicassoExecutorService();
            }
            if (this.transformer == null) {
                this.transformer = RequestTransformer.IDENTITY;
            }
            Stats stats = new Stats(this.cache);
            return new Picasso(context, new Dispatcher(context, this.service, HANDLER, this.downloader, this.cache, stats), this.cache, this.listener, this.transformer, stats, this.debugging);
        }

        public Builder debugging(boolean bl) {
            this.debugging = bl;
            return this;
        }

        public Builder downloader(Downloader downloader) {
            if (downloader == null) {
                throw new IllegalArgumentException("Downloader must not be null.");
            }
            if (this.downloader != null) {
                throw new IllegalStateException("Downloader already set.");
            }
            this.downloader = downloader;
            return this;
        }

        public Builder executor(ExecutorService executorService) {
            if (executorService == null) {
                throw new IllegalArgumentException("Executor service must not be null.");
            }
            if (this.service != null) {
                throw new IllegalStateException("Executor service already set.");
            }
            this.service = executorService;
            return this;
        }

        public Builder listener(Listener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null.");
            }
            if (this.listener != null) {
                throw new IllegalStateException("Listener already set.");
            }
            this.listener = listener;
            return this;
        }

        public Builder memoryCache(Cache cache) {
            if (cache == null) {
                throw new IllegalArgumentException("Memory cache must not be null.");
            }
            if (this.cache != null) {
                throw new IllegalStateException("Memory cache already set.");
            }
            this.cache = cache;
            return this;
        }

        public Builder requestTransformer(RequestTransformer requestTransformer) {
            if (requestTransformer == null) {
                throw new IllegalArgumentException("Transformer must not be null.");
            }
            if (this.transformer != null) {
                throw new IllegalStateException("Transformer already set.");
            }
            this.transformer = requestTransformer;
            return this;
        }
    }

    private static class CleanupThread
    extends Thread {
        private final Handler handler;
        private final ReferenceQueue<?> referenceQueue;

        CleanupThread(ReferenceQueue<?> referenceQueue, Handler handler) {
            this.referenceQueue = referenceQueue;
            this.handler = handler;
            this.setDaemon(true);
            this.setName("Picasso-refQueue");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            try {
                while (true) {
                    Action.RequestWeakReference requestWeakReference = (Action.RequestWeakReference)this.referenceQueue.remove();
                    this.handler.sendMessage(this.handler.obtainMessage(3, (Object)requestWeakReference.action));
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Exception exception) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException(exception);
                    }
                });
                return;
            }
        }

        void shutdown() {
            this.interrupt();
        }
    }

    public static interface Listener {
        public void onImageLoadFailed(Picasso var1, Uri var2, Exception var3);
    }

    public static enum LoadedFrom {
        a(-16711936),
        b(-256),
        c(-65536);

        final int d;

        private LoadedFrom(int n3) {
            this.d = n3;
        }
    }

    public static interface RequestTransformer {
        public static final RequestTransformer IDENTITY = new RequestTransformer(){

            @Override
            public Request transformRequest(Request request) {
                return request;
            }
        };

        public Request transformRequest(Request var1);
    }
}

