/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import s.m;
import s.s;
import s.t;

public interface FileSystem {
    public static final FileSystem SYSTEM = new FileSystem(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public s appendingSink(File file) throws FileNotFoundException {
            try {
                s s2 = m.c((File)file);
                return s2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                file.getParentFile().mkdirs();
                return m.c((File)file);
            }
        }

        @Override
        public void delete(File file) throws IOException {
            if (!file.delete() && file.exists()) {
                throw new IOException("failed to delete " + file);
            }
        }

        @Override
        public void deleteContents(File file2) throws IOException {
            File[] fileArray = file2.listFiles();
            if (fileArray == null) {
                throw new IOException("not a readable directory: " + file2);
            }
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.deleteContents(file2);
                }
                if (file2.delete()) continue;
                throw new IOException("failed to delete " + file2);
            }
        }

        @Override
        public boolean exists(File file) throws IOException {
            return file.exists();
        }

        @Override
        public void rename(File file, File file2) throws IOException {
            this.delete(file2);
            if (!file.renameTo(file2)) {
                throw new IOException("failed to rename " + file + " to " + file2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public s sink(File file) throws FileNotFoundException {
            try {
                s s2 = m.b((File)file);
                return s2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                file.getParentFile().mkdirs();
                return m.b((File)file);
            }
        }

        @Override
        public long size(File file) {
            return file.length();
        }

        @Override
        public t source(File file) throws FileNotFoundException {
            return m.a((File)file);
        }
    };

    public s appendingSink(File var1) throws FileNotFoundException;

    public void delete(File var1) throws IOException;

    public void deleteContents(File var1) throws IOException;

    public boolean exists(File var1) throws IOException;

    public void rename(File var1, File var2) throws IOException;

    public s sink(File var1) throws FileNotFoundException;

    public long size(File var1);

    public t source(File var1) throws FileNotFoundException;
}

