/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.Http1xStream;
import com.squareup.okhttp.internal.http.Http2xStream;
import com.squareup.okhttp.internal.http.HttpStream;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.RouteException;
import com.squareup.okhttp.internal.http.RouteSelector;
import com.squareup.okhttp.internal.io.RealConnection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import s.s;

public final class StreamAllocation {
    public final Address address;
    private boolean canceled;
    private RealConnection connection;
    private final ConnectionPool connectionPool;
    private boolean released;
    private RouteSelector routeSelector;
    private HttpStream stream;

    public StreamAllocation(ConnectionPool connectionPool, Address address) {
        this.connectionPool = connectionPool;
        this.address = address;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectionFailed(IOException iOException) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.routeSelector != null) {
                if (this.connection.streamCount == 0) {
                    Route route = this.connection.getRoute();
                    this.routeSelector.connectFailed(route, iOException);
                } else {
                    this.routeSelector = null;
                }
            }
        }
        this.connectionFailed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void deallocate(boolean bl, boolean bl2, boolean bl3) {
        RealConnection realConnection;
        block12: {
            Object var5_5;
            block13: {
                RealConnection realConnection2 = null;
                var5_5 = null;
                ConnectionPool connectionPool = this.connectionPool;
                // MONITORENTER : connectionPool
                if (bl3) {
                    this.stream = null;
                }
                if (bl2) {
                    this.released = true;
                }
                realConnection = realConnection2;
                if (this.connection == null) break block12;
                if (bl) {
                    this.connection.noNewStreams = true;
                }
                realConnection = realConnection2;
                if (this.stream != null) break block12;
                if (this.released) break block13;
                realConnection = realConnection2;
                if (!this.connection.noNewStreams) break block12;
            }
            this.release(this.connection);
            if (this.connection.streamCount > 0) {
                this.routeSelector = null;
            }
            realConnection = var5_5;
            if (this.connection.allocations.isEmpty()) {
                this.connection.idleAtNanos = System.nanoTime();
                realConnection = var5_5;
                if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                    realConnection = this.connection;
                }
            }
            this.connection = null;
        }
        // MONITOREXIT : connectionPool
        if (realConnection == null) return;
        Util.closeQuietly(realConnection.getSocket());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RealConnection findConnection(int n2, int n3, int n4, boolean bl) throws IOException, RouteException {
        Object object;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.released) {
                IllegalStateException illegalStateException = new IllegalStateException("released");
                throw illegalStateException;
            }
            if (this.stream != null) {
                IllegalStateException illegalStateException = new IllegalStateException("stream != null");
                throw illegalStateException;
            }
            if (this.canceled) {
                IOException iOException = new IOException("Canceled");
                throw iOException;
            }
            object = this.connection;
            if (object != null && !((RealConnection)object).noNewStreams) {
                return object;
            }
            object = Internal.instance.get(this.connectionPool, this.address, this);
            if (object != null) {
                this.connection = object;
                return object;
            }
            if (this.routeSelector == null) {
                this.routeSelector = object = new RouteSelector(this.address, this.routeDatabase());
            }
        }
        object = new RealConnection(this.routeSelector.next());
        this.acquire((RealConnection)object);
        connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            Internal.instance.put(this.connectionPool, (RealConnection)object);
            this.connection = object;
            if (this.canceled) {
                object = new IOException("Canceled");
                throw object;
            }
        }
        ((RealConnection)object).connect(n2, n3, n4, this.address.getConnectionSpecs(), bl);
        this.routeDatabase().connected(((RealConnection)object).getRoute());
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RealConnection findHealthyConnection(int n2, int n3, int n4, boolean bl, boolean bl2) throws IOException, RouteException {
        while (true) {
            RealConnection realConnection = this.findConnection(n2, n3, n4, bl);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (realConnection.streamCount == 0) {
                    return realConnection;
                }
            }
            if (realConnection.isHealthy(bl2)) return realConnection;
            this.connectionFailed();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRecoverable(RouteException exception) {
        boolean bl;
        boolean bl2 = false;
        if ((exception = ((RouteException)exception).getLastConnectException()) instanceof ProtocolException) {
            return bl2;
        }
        if (exception instanceof InterruptedIOException) {
            return exception instanceof SocketTimeoutException;
        }
        if (exception instanceof SSLHandshakeException) {
            bl = bl2;
            if (exception.getCause() instanceof CertificateException) return bl;
        }
        bl = bl2;
        if (exception instanceof SSLPeerUnverifiedException) return bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRecoverable(IOException iOException) {
        boolean bl = false;
        if (iOException instanceof ProtocolException) {
            return bl;
        }
        if (iOException instanceof InterruptedIOException) return bl;
        return true;
    }

    private void release(RealConnection realConnection) {
        int n2 = realConnection.allocations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (realConnection.allocations.get(i2).get() != this) continue;
            realConnection.allocations.remove(i2);
            return;
        }
        throw new IllegalStateException();
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public void acquire(RealConnection realConnection) {
        realConnection.allocations.add(new WeakReference<StreamAllocation>(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void cancel() {
        ConnectionPool connectionPool = this.connectionPool;
        // MONITORENTER : connectionPool
        this.canceled = true;
        HttpStream httpStream = this.stream;
        RealConnection realConnection = this.connection;
        // MONITOREXIT : connectionPool
        if (httpStream != null) {
            httpStream.cancel();
            return;
        }
        if (realConnection == null) return;
        realConnection.cancel();
    }

    public RealConnection connection() {
        synchronized (this) {
            RealConnection realConnection = this.connection;
            return realConnection;
        }
    }

    public void connectionFailed() {
        this.deallocate(true, false, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpStream newStream(int n2, int n3, int n4, boolean bl, boolean bl2) throws RouteException, IOException {
        HttpStream httpStream;
        try {
            RealConnection realConnection = this.findHealthyConnection(n2, n3, n4, bl, bl2);
            if (realConnection.framedConnection != null) {
                httpStream = new Http2xStream(this, realConnection.framedConnection);
            } else {
                realConnection.getSocket().setSoTimeout(n3);
                realConnection.source.timeout().timeout((long)n3, TimeUnit.MILLISECONDS);
                realConnection.sink.timeout().timeout((long)n4, TimeUnit.MILLISECONDS);
                httpStream = new Http1xStream(this, realConnection.source, realConnection.sink);
            }
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                ++realConnection.streamCount;
                this.stream = httpStream;
            }
        }
        catch (IOException iOException) {
            throw new RouteException(iOException);
        }
        return httpStream;
    }

    public void noNewStreams() {
        this.deallocate(true, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean recover(RouteException routeException) {
        if (this.connection != null) {
            this.connectionFailed(routeException.getLastConnectException());
        }
        if (this.routeSelector != null) {
            if (!this.routeSelector.hasNext()) return false;
        }
        if (this.isRecoverable(routeException)) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean recover(IOException iOException, s s2) {
        boolean bl;
        int n2;
        boolean bl2 = false;
        if (this.connection != null) {
            n2 = this.connection.streamCount;
            this.connectionFailed(iOException);
            if (n2 == 1) {
                return bl2;
            }
        }
        n2 = s2 == null || s2 instanceof RetryableSink ? 1 : 0;
        if (this.routeSelector != null) {
            bl = bl2;
            if (!this.routeSelector.hasNext()) return bl;
        }
        bl = bl2;
        if (!this.isRecoverable(iOException)) return bl;
        bl = bl2;
        if (n2 == 0) return bl;
        return true;
    }

    public void release() {
        this.deallocate(false, true, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpStream stream() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.stream;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void streamFinished(HttpStream httpStream) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (httpStream != null && httpStream == this.stream) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl4 : MonitorExitStatement: MONITOREXIT : var2_2
                this.deallocate(false, false, true);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.append("expected ").append(this.stream).append(" but was ").append(httpStream).toString());
            throw illegalStateException;
        }
    }

    public String toString() {
        return this.address.toString();
    }
}

