/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.RouteDatabase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public final class RouteSelector {
    private final Address address;
    private List<InetSocketAddress> inetSocketAddresses;
    private InetSocketAddress lastInetSocketAddress;
    private Proxy lastProxy;
    private int nextInetSocketAddressIndex;
    private int nextProxyIndex;
    private final List<Route> postponedRoutes;
    private List<Proxy> proxies = Collections.emptyList();
    private final RouteDatabase routeDatabase;

    public RouteSelector(Address address, RouteDatabase routeDatabase) {
        this.inetSocketAddresses = Collections.emptyList();
        this.postponedRoutes = new ArrayList<Route>();
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.resetNextProxy(address.url(), address.getProxy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getHostString(InetSocketAddress object) {
        InetAddress inetAddress = ((InetSocketAddress)object).getAddress();
        if (inetAddress != null) return inetAddress.getHostAddress();
        return ((InetSocketAddress)object).getHostName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasNextInetSocketAddress() {
        if (this.nextInetSocketAddressIndex >= this.inetSocketAddresses.size()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasNextPostponed() {
        if (this.postponedRoutes.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasNextProxy() {
        if (this.nextProxyIndex >= this.proxies.size()) return false;
        return true;
    }

    private InetSocketAddress nextInetSocketAddress() throws IOException {
        if (!this.hasNextInetSocketAddress()) {
            throw new SocketException("No route to " + this.address.getUriHost() + "; exhausted inet socket addresses: " + this.inetSocketAddresses);
        }
        List<InetSocketAddress> list = this.inetSocketAddresses;
        int n2 = this.nextInetSocketAddressIndex;
        this.nextInetSocketAddressIndex = n2 + 1;
        return list.get(n2);
    }

    private Route nextPostponed() {
        return this.postponedRoutes.remove(0);
    }

    private Proxy nextProxy() throws IOException {
        if (!this.hasNextProxy()) {
            throw new SocketException("No route to " + this.address.getUriHost() + "; exhausted proxy configurations: " + this.proxies);
        }
        Object object = this.proxies;
        int n2 = this.nextProxyIndex;
        this.nextProxyIndex = n2 + 1;
        object = object.get(n2);
        this.resetNextInetSocketAddress((Proxy)object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resetNextInetSocketAddress(Proxy list) throws IOException {
        int n2;
        Object object;
        this.inetSocketAddresses = new ArrayList<InetSocketAddress>();
        if (((Proxy)((Object)list)).type() == Proxy.Type.DIRECT || ((Proxy)((Object)list)).type() == Proxy.Type.SOCKS) {
            object = this.address.getUriHost();
            n2 = this.address.getUriPort();
        } else {
            object = ((Proxy)((Object)list)).address();
            if (!(object instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Proxy.address() is not an InetSocketAddress: " + object.getClass());
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            object = RouteSelector.getHostString(inetSocketAddress);
            n2 = inetSocketAddress.getPort();
        }
        if (n2 < 1 || n2 > 65535) {
            throw new SocketException("No route to " + (String)object + ":" + n2 + "; port is out of range");
        }
        if (((Proxy)((Object)list)).type() == Proxy.Type.SOCKS) {
            this.inetSocketAddresses.add(InetSocketAddress.createUnresolved((String)object, n2));
        } else {
            list = this.address.getDns().lookup((String)object);
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                object = list.get(i2);
                this.inetSocketAddresses.add(new InetSocketAddress((InetAddress)object, n2));
            }
        }
        this.nextInetSocketAddressIndex = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resetNextProxy(HttpUrl list, Proxy proxy) {
        if (proxy != null) {
            this.proxies = Collections.singletonList(proxy);
        } else {
            this.proxies = new ArrayList<Proxy>();
            list = this.address.getProxySelector().select(((HttpUrl)((Object)list)).uri());
            if (list != null) {
                this.proxies.addAll(list);
            }
            this.proxies.removeAll(Collections.singleton(Proxy.NO_PROXY));
            this.proxies.add(Proxy.NO_PROXY);
        }
        this.nextProxyIndex = 0;
    }

    public void connectFailed(Route route, IOException iOException) {
        if (route.getProxy().type() != Proxy.Type.DIRECT && this.address.getProxySelector() != null) {
            this.address.getProxySelector().connectFailed(this.address.url().uri(), route.getProxy().address(), iOException);
        }
        this.routeDatabase.failed(route);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasNext() {
        if (this.hasNextInetSocketAddress()) return true;
        if (this.hasNextProxy()) return true;
        if (!this.hasNextPostponed()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Route next() throws IOException {
        Route route;
        if (!this.hasNextInetSocketAddress()) {
            if (!this.hasNextProxy()) {
                if (this.hasNextPostponed()) return this.nextPostponed();
                throw new NoSuchElementException();
            }
            this.lastProxy = this.nextProxy();
        }
        this.lastInetSocketAddress = this.nextInetSocketAddress();
        Route route2 = route = new Route(this.address, this.lastProxy, this.lastInetSocketAddress);
        if (!this.routeDatabase.shouldPostpone(route)) return route2;
        this.postponedRoutes.add(route);
        return this.next();
    }
}

