/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.HttpStream;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.RealResponseBody;
import com.squareup.okhttp.internal.http.RequestLine;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.StatusLine;
import com.squareup.okhttp.internal.http.StreamAllocation;
import com.squareup.okhttp.internal.io.RealConnection;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import s.c;
import s.d;
import s.e;
import s.j;
import s.m;
import s.s;
import s.t;
import s.u;

public final class Http1xStream
implements HttpStream {
    private static final int STATE_CLOSED = 6;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private HttpEngine httpEngine;
    private final d sink;
    private final e source;
    private int state = 0;
    private final StreamAllocation streamAllocation;

    public Http1xStream(StreamAllocation streamAllocation, e e2, d d2) {
        this.streamAllocation = streamAllocation;
        this.source = e2;
        this.sink = d2;
    }

    static /* synthetic */ int access$502(Http1xStream http1xStream, int n2) {
        http1xStream.state = n2;
        return n2;
    }

    private void detachTimeout(j j2) {
        u u2 = j2.a();
        j2.a(u.NONE);
        u2.clearDeadline();
        u2.clearTimeout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private t getTransferStream(Response response) throws IOException {
        if (!HttpEngine.hasBody(response)) {
            return this.newFixedLengthSource(0L);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return this.newChunkedSource(this.httpEngine);
        }
        long l2 = OkHeaders.contentLength(response);
        if (l2 == -1L) return this.newUnknownLengthSource();
        return this.newFixedLengthSource(l2);
    }

    @Override
    public void cancel() {
        RealConnection realConnection = this.streamAllocation.connection();
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public s createRequestBody(Request request, long l2) throws IOException {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l2 == -1L) throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
        return this.newFixedLengthSink(l2);
    }

    @Override
    public void finishRequest() throws IOException {
        this.sink.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClosed() {
        if (this.state != 6) return false;
        return true;
    }

    public s newChunkedSink() {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new ChunkedSink();
    }

    public t newChunkedSource(HttpEngine httpEngine) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new ChunkedSource(httpEngine);
    }

    public s newFixedLengthSink(long l2) {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new FixedLengthSink(l2);
    }

    public t newFixedLengthSource(long l2) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new FixedLengthSource(l2);
    }

    public t newUnknownLengthSource() throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        if (this.streamAllocation == null) {
            throw new IllegalStateException("streamAllocation == null");
        }
        this.state = 5;
        this.streamAllocation.noNewStreams();
        return new UnknownLengthSource();
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        t t2 = this.getTransferStream(response);
        return new RealResponseBody(response.headers(), m.a((t)t2));
    }

    public Headers readHeaders() throws IOException {
        String string2;
        Headers.Builder builder = new Headers.Builder();
        while ((string2 = this.source.q()).length() != 0) {
            Internal.instance.addLenient(builder, string2);
        }
        return builder.build();
    }

    public Response.Builder readResponse() throws IOException {
        if (this.state != 1 && this.state != 3) {
            throw new IllegalStateException("state: " + this.state);
        }
        try {
            Response.Builder builder;
            StatusLine statusLine;
            do {
                statusLine = StatusLine.parse(this.source.q());
                builder = new Response.Builder();
                builder = builder.protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
            } while (statusLine.code == 100);
            this.state = 4;
            return builder;
        }
        catch (EOFException eOFException) {
            IOException iOException = new IOException("unexpected end of stream on " + this.streamAllocation);
            iOException.initCause(eOFException);
            throw iOException;
        }
    }

    @Override
    public Response.Builder readResponseHeaders() throws IOException {
        return this.readResponse();
    }

    @Override
    public void setHttpEngine(HttpEngine httpEngine) {
        this.httpEngine = httpEngine;
    }

    public void writeRequest(Headers headers, String string2) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.sink.b(string2).b("\r\n");
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sink.b(headers.name(i2)).b(": ").b(headers.value(i2)).b("\r\n");
        }
        this.sink.b("\r\n");
        this.state = 1;
    }

    @Override
    public void writeRequestBody(RetryableSink retryableSink) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 3;
        retryableSink.writeToSocket((s)this.sink);
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        this.httpEngine.writingRequestHeaders();
        String string2 = RequestLine.get(request, this.httpEngine.getConnection().getRoute().getProxy().type());
        this.writeRequest(request.headers(), string2);
    }

    private abstract class AbstractSource
    implements t {
        protected boolean closed;
        protected final j timeout;

        private AbstractSource() {
            this.timeout = new j(Http1xStream.this.source.timeout());
        }

        protected final void endOfInput() throws IOException {
            if (Http1xStream.this.state != 5) {
                throw new IllegalStateException("state: " + Http1xStream.this.state);
            }
            Http1xStream.this.detachTimeout(this.timeout);
            Http1xStream.access$502(Http1xStream.this, 6);
            if (Http1xStream.this.streamAllocation != null) {
                Http1xStream.this.streamAllocation.streamFinished(Http1xStream.this);
            }
        }

        public u timeout() {
            return this.timeout;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected final void unexpectedEndOfInput() {
            if (Http1xStream.this.state == 6) {
                return;
            }
            Http1xStream.access$502(Http1xStream.this, 6);
            if (Http1xStream.this.streamAllocation == null) return;
            Http1xStream.this.streamAllocation.noNewStreams();
            Http1xStream.this.streamAllocation.streamFinished(Http1xStream.this);
        }
    }

    private final class ChunkedSink
    implements s {
        private boolean closed;
        private final j timeout;

        private ChunkedSink() {
            this.timeout = new j(Http1xStream.this.sink.timeout());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            synchronized (this) {
                block6: {
                    boolean bl = this.closed;
                    if (!bl) break block6;
                    return;
                }
                this.closed = true;
                Http1xStream.this.sink.b("0\r\n\r\n");
                Http1xStream.this.detachTimeout(this.timeout);
                Http1xStream.access$502(Http1xStream.this, 3);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void flush() throws IOException {
            synchronized (this) {
                block6: {
                    boolean bl = this.closed;
                    if (!bl) break block6;
                    return;
                }
                Http1xStream.this.sink.flush();
                return;
            }
        }

        public u timeout() {
            return this.timeout;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(c c2, long l2) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (l2 == 0L) {
                return;
            }
            Http1xStream.this.sink.j(l2);
            Http1xStream.this.sink.b("\r\n");
            Http1xStream.this.sink.write(c2, l2);
            Http1xStream.this.sink.b("\r\n");
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private long bytesRemainingInChunk = -1L;
        private boolean hasMoreChunks = true;
        private final HttpEngine httpEngine;

        ChunkedSource(HttpEngine httpEngine) throws IOException {
            this.httpEngine = httpEngine;
        }

        private void readChunkSize() throws IOException {
            if (this.bytesRemainingInChunk != -1L) {
                Http1xStream.this.source.q();
            }
            try {
                this.bytesRemainingInChunk = Http1xStream.this.source.n();
                String string2 = Http1xStream.this.source.q().trim();
                if (this.bytesRemainingInChunk < 0L || !string2.isEmpty() && !string2.startsWith(";")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    ProtocolException protocolException = new ProtocolException(stringBuilder.append("expected chunk size and optional extensions but was \"").append(this.bytesRemainingInChunk).append(string2).append("\"").toString());
                    throw protocolException;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException(numberFormatException.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                this.httpEngine.receiveHeaders(Http1xStream.this.readHeaders());
                this.endOfInput();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long read(c c2, long l2) throws IOException {
            long l3 = -1L;
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (!this.hasMoreChunks) {
                return l3;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) return l3;
            }
            if ((l3 = Http1xStream.this.source.read(c2, Math.min(l2, this.bytesRemainingInChunk))) == -1L) {
                this.unexpectedEndOfInput();
                throw new ProtocolException("unexpected end of stream");
            }
            this.bytesRemainingInChunk -= l3;
            return l3;
        }
    }

    private final class FixedLengthSink
    implements s {
        private long bytesRemaining;
        private boolean closed;
        private final j timeout;

        private FixedLengthSink(long l2) {
            this.timeout = new j(Http1xStream.this.sink.timeout());
            this.bytesRemaining = l2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.bytesRemaining > 0L) {
                throw new ProtocolException("unexpected end of stream");
            }
            Http1xStream.this.detachTimeout(this.timeout);
            Http1xStream.access$502(Http1xStream.this, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1xStream.this.sink.flush();
        }

        public u timeout() {
            return this.timeout;
        }

        public void write(c c2, long l2) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            Util.checkOffsetAndCount(c2.a(), 0L, l2);
            if (l2 > this.bytesRemaining) {
                throw new ProtocolException("expected " + this.bytesRemaining + " bytes but received " + l2);
            }
            Http1xStream.this.sink.write(c2, l2);
            this.bytesRemaining -= l2;
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        public FixedLengthSource(long l2) throws IOException {
            this.bytesRemaining = l2;
            if (this.bytesRemaining == 0L) {
                this.endOfInput();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long read(c c2, long l2) throws IOException {
            long l3 = -1L;
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.bytesRemaining == 0L) {
                return l3;
            }
            l2 = Http1xStream.this.source.read(c2, Math.min(this.bytesRemaining, l2));
            if (l2 == -1L) {
                this.unexpectedEndOfInput();
                throw new ProtocolException("unexpected end of stream");
            }
            this.bytesRemaining -= l2;
            if (this.bytesRemaining != 0L) return l2;
            this.endOfInput();
            return l2;
        }
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        private UnknownLengthSource() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long read(c c2, long l2) throws IOException {
            long l3 = -1L;
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.inputExhausted) {
                return l3;
            }
            l2 = Http1xStream.this.source.read(c2, l2);
            if (l2 != -1L) return l2;
            this.inputExhausted = true;
            this.endOfInput();
            return l3;
        }
    }
}

