/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Challenge;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;

public final class AuthenticatorAdapter
implements Authenticator {
    public static final Authenticator INSTANCE = new AuthenticatorAdapter();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InetAddress getConnectToInetAddress(Proxy object, HttpUrl httpUrl) throws IOException {
        if (object == null) return InetAddress.getByName(httpUrl.host());
        if (((Proxy)object).type() == Proxy.Type.DIRECT) return InetAddress.getByName(httpUrl.host());
        return ((InetSocketAddress)((Proxy)object).address()).getAddress();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Request authenticate(Proxy object, Response object2) throws IOException {
        List<Challenge> list = ((Response)object2).challenges();
        object2 = ((Response)object2).request();
        HttpUrl httpUrl = ((Request)object2).httpUrl();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Object object3 = list.get(n3);
            if ("Basic".equalsIgnoreCase(((Challenge)object3).getScheme()) && (object3 = java.net.Authenticator.requestPasswordAuthentication(httpUrl.host(), this.getConnectToInetAddress((Proxy)object, httpUrl), httpUrl.port(), httpUrl.scheme(), ((Challenge)object3).getRealm(), ((Challenge)object3).getScheme(), httpUrl.url(), Authenticator.RequestorType.SERVER)) != null) {
                object = Credentials.basic(((PasswordAuthentication)object3).getUserName(), new String(((PasswordAuthentication)object3).getPassword()));
                return ((Request)object2).newBuilder().header("Authorization", (String)object).build();
            }
            ++n3;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Request authenticateProxy(Proxy object, Response object2) throws IOException {
        List<Challenge> list = ((Response)object2).challenges();
        object2 = ((Response)object2).request();
        HttpUrl httpUrl = ((Request)object2).httpUrl();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            InetSocketAddress inetSocketAddress;
            Object object3 = list.get(n3);
            if ("Basic".equalsIgnoreCase(((Challenge)object3).getScheme()) && (object3 = java.net.Authenticator.requestPasswordAuthentication((inetSocketAddress = (InetSocketAddress)((Proxy)object).address()).getHostName(), this.getConnectToInetAddress((Proxy)object, httpUrl), inetSocketAddress.getPort(), httpUrl.scheme(), ((Challenge)object3).getRealm(), ((Challenge)object3).getScheme(), httpUrl.url(), Authenticator.RequestorType.PROXY)) != null) {
                object = Credentials.basic(((PasswordAuthentication)object3).getUserName(), new String(((PasswordAuthentication)object3).getPassword()));
                return ((Request)object2).newBuilder().header("Proxy-Authorization", (String)object).build();
            }
            ++n3;
        }
        return null;
    }
}

