/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FrameReader;
import com.squareup.okhttp.internal.framed.FrameWriter;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import com.squareup.okhttp.internal.framed.NameValueBlockReader;
import com.squareup.okhttp.internal.framed.Settings;
import com.squareup.okhttp.internal.framed.Variant;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.List;
import java.util.zip.Deflater;
import s.c;
import s.d;
import s.e;
import s.f;
import s.g;
import s.m;
import s.s;
import s.t;

public final class Spdy3
implements Variant {
    static final byte[] DICTIONARY;
    static final int FLAG_FIN = 1;
    static final int FLAG_UNIDIRECTIONAL = 2;
    static final int TYPE_DATA = 0;
    static final int TYPE_GOAWAY = 7;
    static final int TYPE_HEADERS = 8;
    static final int TYPE_PING = 6;
    static final int TYPE_RST_STREAM = 3;
    static final int TYPE_SETTINGS = 4;
    static final int TYPE_SYN_REPLY = 2;
    static final int TYPE_SYN_STREAM = 1;
    static final int TYPE_WINDOW_UPDATE = 9;
    static final int VERSION = 3;

    static {
        try {
            DICTIONARY = "\u0000\u0000\u0000\u0007options\u0000\u0000\u0000\u0004head\u0000\u0000\u0000\u0004post\u0000\u0000\u0000\u0003put\u0000\u0000\u0000\u0006delete\u0000\u0000\u0000\u0005trace\u0000\u0000\u0000\u0006accept\u0000\u0000\u0000\u000eaccept-charset\u0000\u0000\u0000\u000faccept-encoding\u0000\u0000\u0000\u000faccept-language\u0000\u0000\u0000\raccept-ranges\u0000\u0000\u0000\u0003age\u0000\u0000\u0000\u0005allow\u0000\u0000\u0000\rauthorization\u0000\u0000\u0000\rcache-control\u0000\u0000\u0000\nconnection\u0000\u0000\u0000\fcontent-base\u0000\u0000\u0000\u0010content-encoding\u0000\u0000\u0000\u0010content-language\u0000\u0000\u0000\u000econtent-length\u0000\u0000\u0000\u0010content-location\u0000\u0000\u0000\u000bcontent-md5\u0000\u0000\u0000\rcontent-range\u0000\u0000\u0000\fcontent-type\u0000\u0000\u0000\u0004date\u0000\u0000\u0000\u0004etag\u0000\u0000\u0000\u0006expect\u0000\u0000\u0000\u0007expires\u0000\u0000\u0000\u0004from\u0000\u0000\u0000\u0004host\u0000\u0000\u0000\bif-match\u0000\u0000\u0000\u0011if-modified-since\u0000\u0000\u0000\rif-none-match\u0000\u0000\u0000\bif-range\u0000\u0000\u0000\u0013if-unmodified-since\u0000\u0000\u0000\rlast-modified\u0000\u0000\u0000\blocation\u0000\u0000\u0000\fmax-forwards\u0000\u0000\u0000\u0006pragma\u0000\u0000\u0000\u0012proxy-authenticate\u0000\u0000\u0000\u0013proxy-authorization\u0000\u0000\u0000\u0005range\u0000\u0000\u0000\u0007referer\u0000\u0000\u0000\u000bretry-after\u0000\u0000\u0000\u0006server\u0000\u0000\u0000\u0002te\u0000\u0000\u0000\u0007trailer\u0000\u0000\u0000\u0011transfer-encoding\u0000\u0000\u0000\u0007upgrade\u0000\u0000\u0000\nuser-agent\u0000\u0000\u0000\u0004vary\u0000\u0000\u0000\u0003via\u0000\u0000\u0000\u0007warning\u0000\u0000\u0000\u0010www-authenticate\u0000\u0000\u0000\u0006method\u0000\u0000\u0000\u0003get\u0000\u0000\u0000\u0006status\u0000\u0000\u0000\u0006200 OK\u0000\u0000\u0000\u0007version\u0000\u0000\u0000\bHTTP/1.1\u0000\u0000\u0000\u0003url\u0000\u0000\u0000\u0006public\u0000\u0000\u0000\nset-cookie\u0000\u0000\u0000\nkeep-alive\u0000\u0000\u0000\u0006origin100101201202205206300302303304305306307402405406407408409410411412413414415416417502504505203 Non-Authoritative Information204 No Content301 Moved Permanently400 Bad Request401 Unauthorized403 Forbidden404 Not Found500 Internal Server Error501 Not Implemented503 Service UnavailableJan Feb Mar Apr May Jun Jul Aug Sept Oct Nov Dec 00:00:00 Mon, Tue, Wed, Thu, Fri, Sat, Sun, GMTchunked,text/html,image/png,image/jpg,image/gif,application/xml,application/xhtml+xml,text/plain,text/javascript,publicprivatemax-age=gzip,deflate,sdchcharset=utf-8charset=iso-8859-1,utf-,*,enq=0.".getBytes(Util.UTF_8.name());
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.SPDY_3;
    }

    @Override
    public FrameReader newReader(e e2, boolean bl) {
        return new Reader(e2, bl);
    }

    @Override
    public FrameWriter newWriter(d d2, boolean bl) {
        return new Writer(d2, bl);
    }

    static final class Reader
    implements FrameReader {
        private final boolean client;
        private final NameValueBlockReader headerBlockReader;
        private final e source;

        Reader(e e2, boolean bl) {
            this.source = e2;
            this.headerBlockReader = new NameValueBlockReader(this.source);
            this.client = bl;
        }

        private static IOException ioException(String string2, Object ... objectArray) throws IOException {
            throw new IOException(String.format(string2, objectArray));
        }

        private void readGoAway(FrameReader.Handler handler, int n2, int n3) throws IOException {
            if (n3 != 8) {
                throw Reader.ioException("TYPE_GOAWAY length: %d != 8", n3);
            }
            n3 = this.source.j();
            n2 = this.source.j();
            ErrorCode errorCode = ErrorCode.fromSpdyGoAway(n2);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_GOAWAY unexpected error code: %d", n2);
            }
            handler.goAway(n3 & Integer.MAX_VALUE, errorCode, f.b);
        }

        private void readHeaders(FrameReader.Handler handler, int n2, int n3) throws IOException {
            handler.headers(false, false, this.source.j() & Integer.MAX_VALUE, -1, this.headerBlockReader.readNameValueBlock(n3 - 4), HeadersMode.SPDY_HEADERS);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readPing(FrameReader.Handler handler, int n2, int n3) throws IOException {
            boolean bl = true;
            if (n3 != 4) {
                throw Reader.ioException("TYPE_PING length: %d != 4", n3);
            }
            n2 = this.source.j();
            boolean bl2 = this.client;
            boolean bl3 = (n2 & 1) == 1;
            bl3 = bl2 == bl3 ? bl : false;
            handler.ping(bl3, n2, 0);
        }

        private void readRstStream(FrameReader.Handler handler, int n2, int n3) throws IOException {
            if (n3 != 8) {
                throw Reader.ioException("TYPE_RST_STREAM length: %d != 8", n3);
            }
            n2 = this.source.j();
            n3 = this.source.j();
            ErrorCode errorCode = ErrorCode.fromSpdy3Rst(n3);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_RST_STREAM unexpected error code: %d", n3);
            }
            handler.rstStream(n2 & Integer.MAX_VALUE, errorCode);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readSettings(FrameReader.Handler handler, int n2, int n3) throws IOException {
            boolean bl = true;
            int n4 = this.source.j();
            if (n3 != n4 * 8 + 4) {
                throw Reader.ioException("TYPE_SETTINGS length: %d != 4 + 8 * %d", n3, n4);
            }
            Settings settings = new Settings();
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = this.source.j();
                settings.set(n5 & 0xFFFFFF, (0xFF000000 & n5) >>> 24, this.source.j());
            }
            if ((n2 & 1) == 0) {
                bl = false;
            }
            handler.settings(bl, settings);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readSynReply(FrameReader.Handler handler, int n2, int n3) throws IOException {
            int n4 = this.source.j();
            List<Header> list = this.headerBlockReader.readNameValueBlock(n3 - 4);
            boolean bl = (n2 & 1) != 0;
            handler.headers(false, bl, n4 & Integer.MAX_VALUE, -1, list, HeadersMode.SPDY_REPLY);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readSynStream(FrameReader.Handler handler, int n2, int n3) throws IOException {
            boolean bl = true;
            int n4 = this.source.j();
            int n5 = this.source.j();
            this.source.i();
            List<Header> list = this.headerBlockReader.readNameValueBlock(n3 - 10);
            boolean bl2 = (n2 & 1) != 0;
            if ((n2 & 2) == 0) {
                bl = false;
            }
            handler.headers(bl, bl2, n4 & Integer.MAX_VALUE, n5 & Integer.MAX_VALUE, list, HeadersMode.SPDY_SYN_STREAM);
        }

        private void readWindowUpdate(FrameReader.Handler handler, int n2, int n3) throws IOException {
            if (n3 != 8) {
                throw Reader.ioException("TYPE_WINDOW_UPDATE length: %d != 8", n3);
            }
            n2 = this.source.j();
            long l2 = this.source.j() & Integer.MAX_VALUE;
            if (l2 == 0L) {
                throw Reader.ioException("windowSizeIncrement was 0", l2);
            }
            handler.windowUpdate(n2 & Integer.MAX_VALUE, l2);
        }

        @Override
        public void close() throws IOException {
            this.headerBlockReader.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean nextFrame(FrameReader.Handler handler) throws IOException {
            int n2;
            int n3;
            int n4;
            boolean bl = false;
            boolean bl2 = true;
            try {
                n4 = this.source.j();
                n3 = this.source.j();
                n2 = (Integer.MIN_VALUE & n4) != 0 ? 1 : 0;
            }
            catch (IOException iOException) {
                return false;
            }
            int n5 = (0xFF000000 & n3) >>> 24;
            n3 &= 0xFFFFFF;
            if (n2 != 0) {
                n2 = (0x7FFF0000 & n4) >>> 16;
                if (n2 != 3) {
                    throw new ProtocolException("version != 3: " + n2);
                }
                switch (0xFFFF & n4) {
                    default: {
                        this.source.g((long)n3);
                        return bl2;
                    }
                    case 1: {
                        this.readSynStream(handler, n5, n3);
                        return bl2;
                    }
                    case 2: {
                        this.readSynReply(handler, n5, n3);
                        return bl2;
                    }
                    case 3: {
                        this.readRstStream(handler, n5, n3);
                        return bl2;
                    }
                    case 4: {
                        this.readSettings(handler, n5, n3);
                        return bl2;
                    }
                    case 6: {
                        this.readPing(handler, n5, n3);
                        return bl2;
                    }
                    case 7: {
                        this.readGoAway(handler, n5, n3);
                        return bl2;
                    }
                    case 8: {
                        this.readHeaders(handler, n5, n3);
                        return bl2;
                    }
                    case 9: 
                }
                this.readWindowUpdate(handler, n5, n3);
                return bl2;
            }
            if ((n5 & 1) != 0) {
                bl = true;
            }
            handler.data(bl, Integer.MAX_VALUE & n4, this.source, n3);
            return bl2;
        }

        @Override
        public void readConnectionPreface() {
        }
    }

    static final class Writer
    implements FrameWriter {
        private final boolean client;
        private boolean closed;
        private final c headerBlockBuffer;
        private final d headerBlockOut;
        private final d sink;

        Writer(d object, boolean bl) {
            this.sink = object;
            this.client = bl;
            object = new Deflater();
            ((Deflater)object).setDictionary(DICTIONARY);
            this.headerBlockBuffer = new c();
            this.headerBlockOut = m.a((s)new g((s)this.headerBlockBuffer, (Deflater)object));
        }

        private void writeNameValueBlockToBuffer(List<Header> list) throws IOException {
            this.headerBlockOut.g(list.size());
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                f f2 = list.get((int)i2).name;
                this.headerBlockOut.g(f2.h());
                this.headerBlockOut.b(f2);
                f2 = list.get((int)i2).value;
                this.headerBlockOut.g(f2.h());
                this.headerBlockOut.b(f2);
            }
            this.headerBlockOut.flush();
        }

        @Override
        public void ackSettings(Settings settings) {
        }

        @Override
        public void close() throws IOException {
            synchronized (this) {
                this.closed = true;
                Util.closeAll((Closeable)this.sink, (Closeable)this.headerBlockOut);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void connectionPreface() {
            // MONITORENTER : this
            // MONITOREXIT : this
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void data(boolean bl, int n2, c c2, int n3) throws IOException {
            synchronized (this) {
                void var4_4;
                int n4 = bl ? 1 : 0;
                this.sendDataFrame(n2, n4, c2, (int)var4_4);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void flush() throws IOException {
            synchronized (this) {
                if (this.closed) {
                    IOException iOException = new IOException("closed");
                    throw iOException;
                }
                this.sink.flush();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void goAway(int n2, ErrorCode object, byte[] byArray) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                if (object.spdyGoAwayCode == -1) {
                    object = new IllegalArgumentException("errorCode.spdyGoAwayCode == -1");
                    throw object;
                }
                this.sink.g(-2147287033);
                this.sink.g(8);
                this.sink.g(n2);
                this.sink.g(object.spdyGoAwayCode);
                this.sink.flush();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void headers(int n2, List<Header> object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.writeNameValueBlockToBuffer((List<Header>)object);
                int n3 = (int)(this.headerBlockBuffer.a() + 4L);
                this.sink.g(-2147287032);
                this.sink.g(n3 & 0xFFFFFF | 0);
                this.sink.g(Integer.MAX_VALUE & n2);
                this.sink.a((t)this.headerBlockBuffer);
                return;
            }
        }

        @Override
        public int maxDataLength() {
            return 16383;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void ping(boolean bl, int n2, int n3) throws IOException {
            boolean bl2 = true;
            synchronized (this) {
                if (this.closed) {
                    IOException iOException = new IOException("closed");
                    throw iOException;
                }
                boolean bl3 = this.client;
                boolean bl4 = (n2 & 1) == 1;
                if (bl != (bl4 = bl3 != bl4 ? bl2 : false)) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("payload != reply");
                    throw illegalArgumentException;
                }
                this.sink.g(-2147287034);
                this.sink.g(4);
                this.sink.g(n2);
                this.sink.flush();
                return;
            }
        }

        @Override
        public void pushPromise(int n2, int n3, List<Header> list) throws IOException {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void rstStream(int n2, ErrorCode object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                if (object.spdyRstCode == -1) {
                    object = new IllegalArgumentException();
                    throw object;
                }
                this.sink.g(-2147287037);
                this.sink.g(8);
                this.sink.g(Integer.MAX_VALUE & n2);
                this.sink.g(object.spdyRstCode);
                this.sink.flush();
                return;
            }
        }

        void sendDataFrame(int n2, int n3, c c2, int n4) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if ((long)n4 > 0xFFFFFFL) {
                throw new IllegalArgumentException("FRAME_TOO_LARGE max size is 16Mib: " + n4);
            }
            this.sink.g(Integer.MAX_VALUE & n2);
            this.sink.g((n3 & 0xFF) << 24 | 0xFFFFFF & n4);
            if (n4 > 0) {
                this.sink.write(c2, (long)n4);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void settings(Settings object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                int n2 = ((Settings)object).size();
                this.sink.g(-2147287036);
                this.sink.g(n2 * 8 + 4 & 0xFFFFFF | 0);
                this.sink.g(n2);
                n2 = 0;
                while (true) {
                    if (n2 > 10) {
                        this.sink.flush();
                        return;
                    }
                    if (((Settings)object).isSet(n2)) {
                        int n3 = ((Settings)object).flags(n2);
                        this.sink.g((n3 & 0xFF) << 24 | n2 & 0xFFFFFF);
                        this.sink.g(((Settings)object).get(n2));
                    }
                    ++n2;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void synReply(boolean bl, int n2, List<Header> object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.writeNameValueBlockToBuffer((List<Header>)object);
                int n3 = bl ? 1 : 0;
                int n4 = (int)(this.headerBlockBuffer.a() + 4L);
                this.sink.g(-2147287038);
                this.sink.g((n3 & 0xFF) << 24 | n4 & 0xFFFFFF);
                this.sink.g(Integer.MAX_VALUE & n2);
                this.sink.a((t)this.headerBlockBuffer);
                this.sink.flush();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void synStream(boolean bl, boolean bl2, int n2, int n3, List<Header> object) throws IOException {
            int n4 = 0;
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.writeNameValueBlockToBuffer((List<Header>)object);
                int n5 = (int)(10L + this.headerBlockBuffer.a());
                int n6 = bl ? 1 : 0;
                if (bl2) {
                    n4 = 2;
                }
                this.sink.g(-2147287039);
                this.sink.g(((n4 | n6) & 0xFF) << 24 | n5 & 0xFFFFFF);
                this.sink.g(n2 & Integer.MAX_VALUE);
                this.sink.g(n3 & Integer.MAX_VALUE);
                this.sink.h(0);
                this.sink.a((t)this.headerBlockBuffer);
                this.sink.flush();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void windowUpdate(int n2, long l2) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    IOException iOException = new IOException("closed");
                    throw iOException;
                }
                if (l2 != 0L && l2 <= Integer.MAX_VALUE) {
                    this.sink.g(-2147287031);
                    this.sink.g(8);
                    this.sink.g(n2);
                    this.sink.g((int)l2);
                    this.sink.flush();
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("windowSizeIncrement must be between 1 and 0x7fffffff: ").append(l2).toString());
                throw illegalArgumentException;
            }
        }
    }
}

