/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FrameReader;
import com.squareup.okhttp.internal.framed.FrameWriter;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import com.squareup.okhttp.internal.framed.Hpack;
import com.squareup.okhttp.internal.framed.Settings;
import com.squareup.okhttp.internal.framed.Variant;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import s.c;
import s.d;
import s.e;
import s.f;
import s.t;
import s.u;

public final class Http2
implements Variant {
    private static final f CONNECTION_PREFACE;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_COMPRESSED = 32;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    static final int INITIAL_MAX_FRAME_SIZE = 16384;
    static final byte TYPE_CONTINUATION = 9;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PING = 6;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_WINDOW_UPDATE = 8;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(FrameLogger.class.getName());
        CONNECTION_PREFACE = f.a((String)"PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    }

    private static IllegalArgumentException illegalArgument(String string2, Object ... objectArray) {
        throw new IllegalArgumentException(String.format(string2, objectArray));
    }

    private static IOException ioException(String string2, Object ... objectArray) throws IOException {
        throw new IOException(String.format(string2, objectArray));
    }

    private static int lengthWithoutPadding(int n2, byte by, short s2) throws IOException {
        int n3 = n2;
        if ((by & 8) != 0) {
            n3 = n2 - 1;
        }
        if (s2 > n3) {
            throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", s2, n3);
        }
        return (short)(n3 - s2);
    }

    private static int readMedium(e e2) throws IOException {
        return (e2.h() & 0xFF) << 16 | (e2.h() & 0xFF) << 8 | e2.h() & 0xFF;
    }

    private static void writeMedium(d d2, int n2) throws IOException {
        d2.i(n2 >>> 16 & 0xFF);
        d2.i(n2 >>> 8 & 0xFF);
        d2.i(n2 & 0xFF);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    @Override
    public FrameReader newReader(e e2, boolean bl) {
        return new Reader(e2, 4096, bl);
    }

    @Override
    public FrameWriter newWriter(d d2, boolean bl) {
        return new Writer(d2, bl);
    }

    static final class ContinuationSource
    implements t {
        byte flags;
        int left;
        int length;
        short padding;
        private final e source;
        int streamId;

        public ContinuationSource(e e2) {
            this.source = e2;
        }

        private void readContinuationHeader() throws IOException {
            int n2;
            int n3 = this.streamId;
            this.left = n2 = Http2.readMedium(this.source);
            this.length = n2;
            byte by = (byte)(this.source.h() & 0xFF);
            this.flags = (byte)(this.source.h() & 0xFF);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(FrameLogger.formatHeader(true, this.streamId, this.length, by, this.flags));
            }
            this.streamId = this.source.j() & Integer.MAX_VALUE;
            if (by != 9) {
                throw Http2.ioException("%s != TYPE_CONTINUATION", new Object[]{by});
            }
            if (this.streamId != n3) {
                throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
        }

        public void close() throws IOException {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long read(c c2, long l2) throws IOException {
            long l3 = -1L;
            while (this.left == 0) {
                this.source.g((long)this.padding);
                this.padding = (short)0;
                if ((this.flags & 4) != 0) {
                    return l3;
                }
                this.readContinuationHeader();
            }
            long l4 = this.source.read(c2, Math.min(l2, (long)this.left));
            l2 = l3;
            if (l4 == -1L) return l2;
            this.left = (int)((long)this.left - l4);
            return l4;
        }

        public u timeout() {
            return this.source.timeout();
        }
    }

    static final class FrameLogger {
        private static final String[] BINARY;
        private static final String[] FLAGS;
        private static final String[] TYPES;

        static {
            int n2;
            int[] nArray;
            int n32;
            int n4;
            int n5 = 0;
            TYPES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
            FLAGS = new String[64];
            BINARY = new String[256];
            for (n4 = 0; n4 < BINARY.length; ++n4) {
                FrameLogger.BINARY[n4] = String.format("%8s", Integer.toBinaryString(n4)).replace(' ', '0');
            }
            FrameLogger.FLAGS[0] = "";
            FrameLogger.FLAGS[1] = "END_STREAM";
            int[] nArray2 = new int[]{1};
            FrameLogger.FLAGS[8] = "PADDED";
            for (int n32 : nArray2) {
                FrameLogger.FLAGS[n32 | 8] = FLAGS[n32] + "|PADDED";
            }
            FrameLogger.FLAGS[4] = "END_HEADERS";
            FrameLogger.FLAGS[32] = "PRIORITY";
            FrameLogger.FLAGS[36] = "END_HEADERS|PRIORITY";
            int[] nArray3 = nArray = new int[3];
            nArray[0] = 4;
            nArray3[1] = 32;
            nArray3[2] = 36;
            n32 = nArray.length;
            n4 = 0;
            while (true) {
                if (n4 >= n32) break;
                int n6 = nArray[n4];
                int n7 = nArray2.length;
                for (n2 = 0; n2 < n7; ++n2) {
                    int n8 = nArray2[n2];
                    FrameLogger.FLAGS[n8 | n6] = FLAGS[n8] + '|' + FLAGS[n6];
                    FrameLogger.FLAGS[n8 | n6 | 8] = FLAGS[n8] + '|' + FLAGS[n6] + "|PADDED";
                }
                ++n4;
            }
            for (n2 = n5; n2 < FLAGS.length; ++n2) {
                if (FLAGS[n2] != null) continue;
                FrameLogger.FLAGS[n2] = BINARY[n2];
            }
        }

        FrameLogger() {
        }

        /*
         * Enabled aggressive block sorting
         */
        static String formatFlags(byte by, byte by2) {
            String string2;
            if (by2 == 0) {
                return "";
            }
            switch (by) {
                default: {
                    string2 = by2 < FLAGS.length ? FLAGS[by2] : BINARY[by2];
                }
                case 4: 
                case 6: {
                    if (by2 != 1) return BINARY[by2];
                    return "ACK";
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    return BINARY[by2];
                }
            }
            if (by == 5 && (by2 & 4) != 0) {
                return string2.replace("HEADERS", "PUSH_PROMISE");
            }
            String string3 = string2;
            if (by != 0) return string3;
            string3 = string2;
            if ((by2 & 0x20) == 0) return string3;
            return string2.replace("PRIORITY", "COMPRESSED");
        }

        /*
         * Enabled aggressive block sorting
         */
        static String formatHeader(boolean bl, int n2, int n3, byte by, byte by2) {
            String string2 = by < TYPES.length ? TYPES[by] : String.format("0x%02x", by);
            String string3 = FrameLogger.formatFlags(by, by2);
            String string4 = bl ? "<<" : ">>";
            return String.format("%s 0x%08x %5d %-13s %s", string4, n2, n3, string2, string3);
        }
    }

    static final class Reader
    implements FrameReader {
        private final boolean client;
        private final ContinuationSource continuation;
        final Hpack.Reader hpackReader;
        private final e source;

        Reader(e e2, int n2, boolean bl) {
            this.source = e2;
            this.client = bl;
            this.continuation = new ContinuationSource(this.source);
            this.hpackReader = new Hpack.Reader(n2, this.continuation);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readData(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            short s2 = 1;
            short s3 = 0;
            boolean bl = (by & 1) != 0;
            if ((by & 0x20) == 0) {
                s2 = 0;
            }
            if (s2 != 0) {
                throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
            }
            short s4 = s3;
            if ((by & 8) != 0) {
                s4 = s2 = (short)(this.source.h() & 0xFF);
            }
            n2 = Http2.lengthWithoutPadding(n2, by, s4);
            handler.data(bl, n3, this.source, n2);
            this.source.g((long)s4);
        }

        private void readGoAway(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            if (n2 < 8) {
                throw Http2.ioException("TYPE_GOAWAY length < 8: %s", new Object[]{n2});
            }
            if (n3 != 0) {
                throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
            }
            n3 = this.source.j();
            by = (byte)this.source.j();
            n2 -= 8;
            ErrorCode errorCode = ErrorCode.fromHttp2(by);
            if (errorCode == null) {
                throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", new Object[]{(int)by});
            }
            f f2 = f.b;
            if (n2 > 0) {
                f2 = this.source.c((long)n2);
            }
            handler.goAway(n3, errorCode, f2);
        }

        private List<Header> readHeaderBlock(int n2, short s2, byte by, int n3) throws IOException {
            ContinuationSource continuationSource = this.continuation;
            this.continuation.left = n2;
            continuationSource.length = n2;
            this.continuation.padding = s2;
            this.continuation.flags = by;
            this.continuation.streamId = n3;
            this.hpackReader.readHeaders();
            return this.hpackReader.getAndResetHeaderList();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readHeaders(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            short s2;
            if (n3 == 0) {
                throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
            }
            boolean bl = (by & 1) != 0;
            short s3 = (by & 8) != 0 ? (s2 = (short)(this.source.h() & 0xFF)) : (s2 = 0);
            s2 = (short)n2;
            if ((by & 0x20) != 0) {
                this.readPriority(handler, n3);
                s2 = (short)(n2 - 5);
            }
            handler.headers(false, bl, n3, -1, this.readHeaderBlock(Http2.lengthWithoutPadding(s2, by, s3), s3, by, n3), HeadersMode.HTTP_20_HEADERS);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readPing(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            boolean bl = true;
            if (n2 != 8) {
                throw Http2.ioException("TYPE_PING length != 8: %s", new Object[]{n2});
            }
            if (n3 != 0) {
                throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
            }
            n3 = this.source.j();
            n2 = this.source.j();
            if ((by & 1) == 0) {
                bl = false;
            }
            handler.ping(bl, n3, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readPriority(FrameReader.Handler handler, int n2) throws IOException {
            int n3 = this.source.j();
            boolean bl = (Integer.MIN_VALUE & n3) != 0;
            handler.priority(n2, n3 & Integer.MAX_VALUE, (this.source.h() & 0xFF) + 1, bl);
        }

        private void readPriority(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            if (n2 != 5) {
                throw Http2.ioException("TYPE_PRIORITY length: %d != 5", new Object[]{n2});
            }
            if (n3 == 0) {
                throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
            }
            this.readPriority(handler, n3);
        }

        private void readPushPromise(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            short s2 = 0;
            if (n3 == 0) {
                throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
            }
            short s3 = s2;
            if ((by & 8) != 0) {
                s3 = s2 = (short)(this.source.h() & 0xFF);
            }
            handler.pushPromise(n3, this.source.j() & Integer.MAX_VALUE, this.readHeaderBlock(Http2.lengthWithoutPadding(n2 - 4, by, s3), s3, by, n3));
        }

        private void readRstStream(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            if (n2 != 4) {
                throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", new Object[]{n2});
            }
            if (n3 == 0) {
                throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
            }
            n2 = this.source.j();
            ErrorCode errorCode = ErrorCode.fromHttp2(n2);
            if (errorCode == null) {
                throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", new Object[]{n2});
            }
            handler.rstStream(n3, errorCode);
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        private void readSettings(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            if (n3 != 0) {
                throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
            }
            if ((by & 1) != 0) {
                if (n2 != 0) {
                    throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
                }
                handler.ackSettings();
                return;
            }
            if (n2 % 6 != 0) {
                throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", new Object[]{n2});
            }
            Settings settings = new Settings();
            by = 0;
            while (true) {
                if (by >= n2) {
                    handler.settings(false, settings);
                    if (settings.getHeaderTableSize() < 0) return;
                    this.hpackReader.headerTableSizeSetting(settings.getHeaderTableSize());
                    return;
                }
                int n4 = this.source.i();
                int n5 = this.source.j();
                n3 = n4;
                int n6 = 0;
                block8: do {
                    switch (n6 == 0 ? n4 : n6) {
                        default: {
                            throw Http2.ioException("PROTOCOL_ERROR invalid settings id: %s", new Object[]{(short)n4});
                        }
                        case 2: {
                            n3 = n4;
                            n6 = 1;
                            if (n5 == 0) continue block8;
                            n3 = n4;
                            n6 = 1;
                            if (n5 == 1) continue block8;
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                        }
                        case 3: {
                            n3 = 4;
                            break;
                        }
                        case 4: {
                            n3 = 7;
                            if (n5 < 0) {
                                throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                            }
                        }
                        case 1: 
                        case 6: {
                            break;
                        }
                        case 5: {
                            if (n5 >= 16384) {
                                n3 = n4;
                                if (n5 <= 0xFFFFFF) break;
                            }
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", new Object[]{n5});
                        }
                    }
                    break;
                } while (true);
                settings.set(n3, 0, n5);
                by = (byte)(by + 6);
            }
        }

        private void readWindowUpdate(FrameReader.Handler handler, int n2, byte by, int n3) throws IOException {
            if (n2 != 4) {
                throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", new Object[]{n2});
            }
            long l2 = (long)this.source.j() & Integer.MAX_VALUE;
            if (l2 == 0L) {
                throw Http2.ioException("windowSizeIncrement was 0", new Object[]{l2});
            }
            handler.windowUpdate(n3, l2);
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean nextFrame(FrameReader.Handler handler) throws IOException {
            boolean bl = true;
            try {
                this.source.a(9L);
            }
            catch (IOException iOException) {
                return false;
            }
            int n2 = Http2.readMedium(this.source);
            if (n2 < 0 || n2 > 16384) {
                throw Http2.ioException("FRAME_SIZE_ERROR: %s", new Object[]{n2});
            }
            byte by = (byte)(this.source.h() & 0xFF);
            byte by2 = (byte)(this.source.h() & 0xFF);
            int n3 = this.source.j() & Integer.MAX_VALUE;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(FrameLogger.formatHeader(true, n3, n2, by, by2));
            }
            switch (by) {
                default: {
                    this.source.g((long)n2);
                    return bl;
                }
                case 0: {
                    this.readData(handler, n2, by2, n3);
                    return bl;
                }
                case 1: {
                    this.readHeaders(handler, n2, by2, n3);
                    return bl;
                }
                case 2: {
                    this.readPriority(handler, n2, by2, n3);
                    return bl;
                }
                case 3: {
                    this.readRstStream(handler, n2, by2, n3);
                    return bl;
                }
                case 4: {
                    this.readSettings(handler, n2, by2, n3);
                    return bl;
                }
                case 5: {
                    this.readPushPromise(handler, n2, by2, n3);
                    return bl;
                }
                case 6: {
                    this.readPing(handler, n2, by2, n3);
                    return bl;
                }
                case 7: {
                    this.readGoAway(handler, n2, by2, n3);
                    return bl;
                }
                case 8: 
            }
            this.readWindowUpdate(handler, n2, by2, n3);
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void readConnectionPreface() throws IOException {
            f f2;
            block5: {
                block4: {
                    if (this.client) break block4;
                    f2 = this.source.c((long)CONNECTION_PREFACE.h());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("<< CONNECTION %s", f2.f()));
                    }
                    if (!CONNECTION_PREFACE.equals((Object)f2)) break block5;
                }
                return;
            }
            throw Http2.ioException("Expected a connection header but was %s", new Object[]{f2.a()});
        }
    }

    static final class Writer
    implements FrameWriter {
        private final boolean client;
        private boolean closed;
        private final c hpackBuffer;
        private final Hpack.Writer hpackWriter;
        private int maxFrameSize;
        private final d sink;

        Writer(d d2, boolean bl) {
            this.sink = d2;
            this.client = bl;
            this.hpackBuffer = new c();
            this.hpackWriter = new Hpack.Writer(this.hpackBuffer);
            this.maxFrameSize = 16384;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void writeContinuationFrames(int n2, long l2) throws IOException {
            while (l2 > 0L) {
                byte by;
                int n3;
                byte by2 = (l2 -= (long)(n3 = (int)Math.min((long)this.maxFrameSize, l2))) == 0L ? (by = 4) : (by = 0);
                this.frameHeader(n2, n3, (byte)9, by2);
                this.sink.write(this.hpackBuffer, (long)n3);
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void ackSettings(Settings object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.maxFrameSize = ((Settings)object).getMaxFrameSize(this.maxFrameSize);
                this.frameHeader(0, 0, (byte)4, (byte)1);
                this.sink.flush();
                return;
            }
        }

        @Override
        public void close() throws IOException {
            synchronized (this) {
                this.closed = true;
                this.sink.close();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void connectionPreface() throws IOException {
            synchronized (this) {
                if (this.closed) {
                    IOException iOException = new IOException("closed");
                    throw iOException;
                }
                boolean bl = this.client;
                if (bl) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format(">> CONNECTION %s", CONNECTION_PREFACE.f()));
                    }
                    this.sink.c(CONNECTION_PREFACE.i());
                    this.sink.flush();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void data(boolean bl, int n2, c object, int n3) throws IOException {
            synchronized (this) {
                byte by;
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                byte by2 = by = 0;
                if (bl) {
                    by2 = by = (byte)1;
                }
                this.dataFrame(n2, by2, (c)object, n3);
                return;
            }
        }

        void dataFrame(int n2, byte by, c c2, int n3) throws IOException {
            this.frameHeader(n2, n3, (byte)0, by);
            if (n3 > 0) {
                this.sink.write(c2, (long)n3);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void flush() throws IOException {
            synchronized (this) {
                if (this.closed) {
                    IOException iOException = new IOException("closed");
                    throw iOException;
                }
                this.sink.flush();
                return;
            }
        }

        void frameHeader(int n2, int n3, byte by, byte by2) throws IOException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(FrameLogger.formatHeader(false, n2, n3, by, by2));
            }
            if (n3 > this.maxFrameSize) {
                throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", new Object[]{this.maxFrameSize, n3});
            }
            if ((Integer.MIN_VALUE & n2) != 0) {
                throw Http2.illegalArgument("reserved bit set: %s", new Object[]{n2});
            }
            Http2.writeMedium(this.sink, n3);
            this.sink.i(by & 0xFF);
            this.sink.i(by2 & 0xFF);
            this.sink.g(Integer.MAX_VALUE & n2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void goAway(int n2, ErrorCode object, byte[] byArray) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                if (object.httpCode == -1) {
                    throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
                }
                this.frameHeader(0, byArray.length + 8, (byte)7, (byte)0);
                this.sink.g(n2);
                this.sink.g(object.httpCode);
                if (byArray.length > 0) {
                    this.sink.c(byArray);
                }
                this.sink.flush();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void headers(int n2, List<Header> object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.headers(false, n2, (List<Header>)object);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void headers(boolean bl, int n2, List<Header> list) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.hpackWriter.writeHeaders(list);
            long l2 = this.hpackBuffer.a();
            int n3 = (int)Math.min((long)this.maxFrameSize, l2);
            byte by = l2 == (long)n3 ? (byte)4 : 0;
            byte by2 = by;
            if (bl) {
                by2 = by = (byte)((byte)(by | 1));
            }
            this.frameHeader(n2, n3, (byte)1, by2);
            this.sink.write(this.hpackBuffer, (long)n3);
            if (l2 > (long)n3) {
                this.writeContinuationFrames(n2, l2 - (long)n3);
            }
        }

        @Override
        public int maxDataLength() {
            return this.maxFrameSize;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void ping(boolean bl, int n2, int n3) throws IOException {
            byte by = 0;
            synchronized (this) {
                if (this.closed) {
                    IOException iOException = new IOException("closed");
                    throw iOException;
                }
                byte by2 = by;
                if (bl) {
                    by2 = by = 1;
                }
                this.frameHeader(0, 8, (byte)6, by2);
                this.sink.g(n2);
                this.sink.g(n3);
                this.sink.flush();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void pushPromise(int n2, int n3, List<Header> object) throws IOException {
            synchronized (this) {
                byte by;
                byte by2;
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.hpackWriter.writeHeaders((List<Header>)object);
                long l2 = this.hpackBuffer.a();
                int n4 = (int)Math.min((long)(this.maxFrameSize - 4), l2);
                byte by3 = l2 == (long)n4 ? (by2 = 4) : (by = 0);
                this.frameHeader(n2, n4 + 4, (byte)5, by3);
                this.sink.g(Integer.MAX_VALUE & n3);
                this.sink.write(this.hpackBuffer, (long)n4);
                if (l2 > (long)n4) {
                    this.writeContinuationFrames(n2, l2 - (long)n4);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void rstStream(int n2, ErrorCode object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                if (object.httpCode == -1) {
                    object = new IllegalArgumentException();
                    throw object;
                }
                this.frameHeader(n2, 4, (byte)3, (byte)0);
                this.sink.g(object.httpCode);
                this.sink.flush();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void settings(Settings object) throws IOException {
            int n2 = 0;
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.frameHeader(0, ((Settings)object).size() * 6, (byte)4, (byte)0);
                while (true) {
                    if (n2 >= 10) {
                        this.sink.flush();
                        return;
                    }
                    if (((Settings)object).isSet(n2)) {
                        int n3 = n2 == 4 ? 3 : (n2 == 7 ? 4 : n2);
                        this.sink.h(n3);
                        this.sink.g(((Settings)object).get(n2));
                    }
                    ++n2;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void synReply(boolean bl, int n2, List<Header> object) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.headers(bl, n2, (List<Header>)object);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void synStream(boolean bl, boolean bl2, int n2, int n3, List<Header> object) throws IOException {
            synchronized (this) {
                if (bl2) {
                    object = new UnsupportedOperationException();
                    throw object;
                }
                if (this.closed) {
                    object = new IOException("closed");
                    throw object;
                }
                this.headers(bl, n2, (List<Header>)object);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void windowUpdate(int n2, long l2) throws IOException {
            synchronized (this) {
                if (this.closed) {
                    IOException iOException = new IOException("closed");
                    throw iOException;
                }
                if (l2 != 0L && l2 <= Integer.MAX_VALUE) {
                    this.frameHeader(n2, 4, (byte)8, (byte)0);
                    this.sink.g((int)l2);
                    this.sink.flush();
                    return;
                }
                throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", new Object[]{l2});
            }
        }
    }
}

