/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.Huffman;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import s.c;
import s.e;
import s.f;
import s.m;
import s.t;

final class Hpack {
    private static final Map<f, Integer> NAME_TO_FIRST_INDEX;
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    private static final Header[] STATIC_HEADER_TABLE;

    static {
        STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
        NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();
    }

    private Hpack() {
    }

    private static f checkLowercase(f f2) throws IOException {
        int n2 = f2.h();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = f2.a(i2);
            if (by < 65 || by > 90) continue;
            throw new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + f2.a());
        }
        return f2;
    }

    private static Map<f, Integer> nameToFirstIndex() {
        LinkedHashMap<f, Integer> linkedHashMap = new LinkedHashMap<f, Integer>(STATIC_HEADER_TABLE.length);
        for (int i2 = 0; i2 < STATIC_HEADER_TABLE.length; ++i2) {
            if (linkedHashMap.containsKey(Hpack.STATIC_HEADER_TABLE[i2].name)) continue;
            linkedHashMap.put(Hpack.STATIC_HEADER_TABLE[i2].name, i2);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static final class Reader {
        Header[] dynamicTable;
        int dynamicTableByteCount = 0;
        int headerCount = 0;
        private final List<Header> headerList = new ArrayList<Header>();
        private int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        int nextHeaderIndex;
        private final e source;

        Reader(int n2, t t2) {
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n2;
            this.source = m.a((t)t2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void adjustDynamicTableByteCount() {
            block4: {
                block3: {
                    if (this.maxDynamicTableByteCount >= this.dynamicTableByteCount) break block3;
                    if (this.maxDynamicTableByteCount != 0) break block4;
                    this.clearDynamicTable();
                }
                return;
            }
            this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
        }

        private void clearDynamicTable() {
            this.headerList.clear();
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int dynamicTableIndex(int n2) {
            return this.nextHeaderIndex + 1 + n2;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            int n4 = 0;
            if (n2 > 0) {
                int n5 = n2;
                n2 = n4;
                for (n3 = this.dynamicTable.length - 1; n3 >= this.nextHeaderIndex && n5 > 0; --n3) {
                    n5 -= this.dynamicTable[n3].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[n3].hpackSize;
                    --this.headerCount;
                    ++n2;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n2, this.headerCount);
                this.nextHeaderIndex += n2;
                n3 = n2;
            }
            return n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private f getName(int n2) {
            if (!this.isStaticHeader(n2)) return this.dynamicTable[this.dynamicTableIndex((int)(n2 - STATIC_HEADER_TABLE.length))].name;
            return STATIC_HEADER_TABLE[n2].name;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void insertIntoDynamicTable(int n2, Header header) {
            int n3;
            this.headerList.add(header);
            int n4 = n3 = header.hpackSize;
            if (n2 != -1) {
                n4 = n3 - this.dynamicTable[this.dynamicTableIndex((int)n2)].hpackSize;
            }
            if (n4 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            n3 = this.evictToRecoverBytes(this.dynamicTableByteCount + n4 - this.maxDynamicTableByteCount);
            if (n2 == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray = new Header[this.dynamicTable.length * 2];
                    System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                n2 = this.nextHeaderIndex;
                this.nextHeaderIndex = n2 - 1;
                this.dynamicTable[n2] = header;
                ++this.headerCount;
            } else {
                int n5 = this.dynamicTableIndex(n2);
                this.dynamicTable[n3 + n5 + n2] = header;
            }
            this.dynamicTableByteCount = n4 + this.dynamicTableByteCount;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isStaticHeader(int n2) {
            if (n2 < 0) return false;
            if (n2 > STATIC_HEADER_TABLE.length - 1) return false;
            return true;
        }

        private int readByte() throws IOException {
            return this.source.h() & 0xFF;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readIndexedHeader(int n2) throws IOException {
            if (this.isStaticHeader(n2)) {
                Header header = STATIC_HEADER_TABLE[n2];
                this.headerList.add(header);
                return;
            }
            int n3 = this.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
            if (n3 < 0 || n3 > this.dynamicTable.length - 1) {
                throw new IOException("Header index too large " + (n2 + 1));
            }
            this.headerList.add(this.dynamicTable[n3]);
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n2) throws IOException {
            this.insertIntoDynamicTable(-1, new Header(this.getName(n2), this.readByteString()));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            this.insertIntoDynamicTable(-1, new Header(Hpack.checkLowercase(this.readByteString()), this.readByteString()));
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n2) throws IOException {
            f f2 = this.getName(n2);
            f f3 = this.readByteString();
            this.headerList.add(new Header(f2, f3));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            f f2 = Hpack.checkLowercase(this.readByteString());
            f f3 = this.readByteString();
            this.headerList.add(new Header(f2, f3));
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        void headerTableSizeSetting(int n2) {
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n2;
            this.adjustDynamicTableByteCount();
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        f readByteString() throws IOException {
            int n2 = this.readByte();
            boolean bl = (n2 & 0x80) == 128;
            n2 = this.readInt(n2, 127);
            if (!bl) return this.source.c((long)n2);
            return f.a((byte[])Huffman.get().decode(this.source.f((long)n2)));
        }

        void readHeaders() throws IOException {
            while (!this.source.e()) {
                int n2 = this.source.h() & 0xFF;
                if (n2 == 128) {
                    throw new IOException("index == 0");
                }
                if ((n2 & 0x80) == 128) {
                    this.readIndexedHeader(this.readInt(n2, 127) - 1);
                    continue;
                }
                if (n2 == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((n2 & 0x40) == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(this.readInt(n2, 63) - 1);
                    continue;
                }
                if ((n2 & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(n2, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (n2 == 16 || n2 == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                this.readLiteralHeaderWithoutIndexingIndexedName(this.readInt(n2, 15) - 1);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int readInt(int n2, int n3) throws IOException {
            int n4;
            if ((n2 &= n3) < n3) {
                return n2;
            }
            n2 = 0;
            while (((n4 = this.readByte()) & 0x80) != 0) {
                n3 += (n4 & 0x7F) << n2;
                n2 += 7;
            }
            return (n4 << n2) + n3;
        }
    }

    static final class Writer {
        private final c out;

        Writer(c c2) {
            this.out = c2;
        }

        void writeByteString(f f2) throws IOException {
            this.writeInt(f2.h(), 127, 0);
            this.out.a(f2);
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeHeaders(List<Header> list) throws IOException {
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                f f2 = list.get((int)n3).name.g();
                Integer n4 = (Integer)NAME_TO_FIRST_INDEX.get(f2);
                if (n4 != null) {
                    this.writeInt(n4 + 1, 15, 0);
                    this.writeByteString(list.get((int)n3).value);
                } else {
                    this.out.b(0);
                    this.writeByteString(f2);
                    this.writeByteString(list.get((int)n3).value);
                }
                ++n3;
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void writeInt(int n2, int n3, int n4) throws IOException {
            if (n2 < n3) {
                this.out.b(n4 | n2);
                return;
            }
            this.out.b(n4 | n3);
            n2 -= n3;
            while (n2 >= 128) {
                this.out.b(n2 & 0x7F | 0x80);
                n2 >>>= 7;
            }
            this.out.b(n2);
        }
    }
}

