/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FramedConnection;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import s.a;
import s.c;
import s.e;
import s.s;
import s.t;
import s.u;

public final class FramedStream {
    static final /* synthetic */ boolean $assertionsDisabled;
    long bytesLeftInWriteWindow;
    private final FramedConnection connection;
    private ErrorCode errorCode = null;
    private final int id;
    private final StreamTimeout readTimeout = new StreamTimeout();
    private final List<Header> requestHeaders;
    private List<Header> responseHeaders;
    final FramedDataSink sink;
    private final FramedDataSource source;
    long unacknowledgedBytesRead = 0L;
    private final StreamTimeout writeTimeout = new StreamTimeout();

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !FramedStream.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    FramedStream(int n2, FramedConnection framedConnection, boolean bl, boolean bl2, List<Header> list) {
        if (framedConnection == null) {
            throw new NullPointerException("connection == null");
        }
        if (list == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = n2;
        this.connection = framedConnection;
        this.bytesLeftInWriteWindow = framedConnection.peerSettings.getInitialWindowSize(65536);
        this.source = new FramedDataSource(framedConnection.okHttpSettings.getInitialWindowSize(65536));
        this.sink = new FramedDataSink();
        FramedDataSource.access$102(this.source, bl2);
        FramedDataSink.access$202(this.sink, bl);
        this.requestHeaders = list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void cancelStreamIfNecessary() throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        // MONITORENTER : this
        boolean bl = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
        boolean bl2 = this.isOpen();
        // MONITOREXIT : this
        if (bl) {
            this.close(ErrorCode.CANCEL);
            return;
        }
        if (bl2) return;
        this.connection.removeStream(this.id);
    }

    private void checkOutNotClosed() throws IOException {
        if (this.sink.closed) {
            throw new IOException("stream closed");
        }
        if (this.sink.finished) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            throw new IOException("stream was reset: " + (Object)((Object)this.errorCode));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean closeInternal(ErrorCode errorCode) {
        boolean bl = false;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        synchronized (this) {
            if (this.errorCode != null) {
                return bl;
            }
            if (this.source.finished && this.sink.finished) {
                return bl;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    private void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    public FramedConnection getConnection() {
        return this.connection;
    }

    public ErrorCode getErrorCode() {
        synchronized (this) {
            ErrorCode errorCode = this.errorCode;
            return errorCode;
        }
    }

    public int getId() {
        return this.id;
    }

    public List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Header> getResponseHeaders() throws IOException {
        synchronized (this) {
            this.readTimeout.enter();
            try {
                while (this.responseHeaders == null && this.errorCode == null) {
                    this.waitForIo();
                }
            }
            finally {
                this.readTimeout.exitAndThrowIfTimedOut();
            }
            if (this.responseHeaders != null) {
                return this.responseHeaders;
            }
            StringBuilder stringBuilder = new StringBuilder();
            IOException iOException = new IOException(stringBuilder.append("stream was reset: ").append((Object)this.errorCode).toString());
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public s getSink() {
        synchronized (this) {
            if (this.responseHeaders == null && !this.isLocallyInitiated()) {
                IllegalStateException illegalStateException = new IllegalStateException("reply before requesting the sink");
                throw illegalStateException;
            }
            return this.sink;
        }
    }

    public t getSource() {
        return this.source;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLocallyInitiated() {
        boolean bl = true;
        boolean bl2 = (this.id & 1) == 1;
        if (this.connection.client != bl2) return false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        boolean bl = false;
        synchronized (this) {
            List<Header> list;
            block6: {
                ErrorCode errorCode = this.errorCode;
                if (errorCode == null) break block6;
                return bl;
            }
            if (!this.source.finished) {
                if (!this.source.closed) return true;
            }
            if (!this.sink.finished) {
                if (!this.sink.closed) return true;
            }
            if ((list = this.responseHeaders) != null) return bl;
            return true;
        }
    }

    public u readTimeout() {
        return this.readTimeout;
    }

    void receiveData(e e2, int n2) throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.source.receive(e2, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void receiveFin() {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        // MONITORENTER : this
        FramedDataSource.access$102(this.source, true);
        boolean bl = this.isOpen();
        this.notifyAll();
        // MONITOREXIT : this
        if (bl) return;
        this.connection.removeStream(this.id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void receiveHeaders(List<Header> object, HeadersMode object2) {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Object var3_3 = null;
        boolean bl = true;
        // MONITORENTER : this
        if (this.responseHeaders == null) {
            if (((HeadersMode)((Object)object2)).failIfHeadersAbsent()) {
                object = ErrorCode.PROTOCOL_ERROR;
            } else {
                this.responseHeaders = object;
                bl = this.isOpen();
                this.notifyAll();
                object = var3_3;
            }
        } else if (((HeadersMode)((Object)object2)).failIfHeadersPresent()) {
            object = ErrorCode.STREAM_IN_USE;
        } else {
            object2 = new ArrayList();
            object2.addAll(this.responseHeaders);
            object2.addAll(object);
            this.responseHeaders = object2;
            object = var3_3;
        }
        // MONITOREXIT : this
        if (object != null) {
            this.closeLater((ErrorCode)((Object)object));
            return;
        }
        if (bl) return;
        this.connection.removeStream(this.id);
    }

    void receiveRstStream(ErrorCode errorCode) {
        synchronized (this) {
            if (this.errorCode == null) {
                this.errorCode = errorCode;
                this.notifyAll();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reply(List<Header> object, boolean bl) throws IOException {
        boolean bl2 = true;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        synchronized (this) {
            if (object == null) {
                object = new NullPointerException("responseHeaders == null");
                throw object;
            }
            if (this.responseHeaders != null) {
                object = new IllegalStateException("reply already sent");
                throw object;
            }
            this.responseHeaders = object;
            if (!bl) {
                FramedDataSink.access$202(this.sink, true);
                bl = bl2;
            } else {
                bl = false;
            }
        }
        this.connection.writeSynReply(this.id, bl, (List<Header>)object);
        if (bl) {
            this.connection.flush();
        }
    }

    public u writeTimeout() {
        return this.writeTimeout;
    }

    final class FramedDataSink
    implements s {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final long EMIT_BUFFER_SIZE = 16384L;
        private boolean closed;
        private boolean finished;
        private final c sendBuffer = new c();

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !FramedStream.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        FramedDataSink() {
        }

        static /* synthetic */ boolean access$202(FramedDataSink framedDataSink, boolean bl) {
            framedDataSink.finished = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void emitDataFrame(boolean bl) throws IOException {
            long l2;
            Object object = FramedStream.this;
            synchronized (object) {
                FramedStream.this.writeTimeout.enter();
                try {
                    while (FramedStream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && FramedStream.this.errorCode == null) {
                        FramedStream.this.waitForIo();
                    }
                }
                finally {
                    FramedStream.this.writeTimeout.exitAndThrowIfTimedOut();
                }
                FramedStream.this.checkOutNotClosed();
                l2 = Math.min(FramedStream.this.bytesLeftInWriteWindow, this.sendBuffer.a());
                FramedStream framedStream = FramedStream.this;
                framedStream.bytesLeftInWriteWindow -= l2;
            }
            FramedStream.this.writeTimeout.enter();
            try {
                object = FramedStream.this.connection;
                int n2 = FramedStream.this.id;
                bl = bl && l2 == this.sendBuffer.a();
                ((FramedConnection)object).writeData(n2, bl, this.sendBuffer, l2);
                return;
            }
            finally {
                FramedStream.this.writeTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(FramedStream.this)) {
                throw new AssertionError();
            }
            FramedStream framedStream = FramedStream.this;
            // MONITORENTER : framedStream
            if (this.closed) {
                // MONITOREXIT : framedStream
                return;
            }
            // MONITOREXIT : framedStream
            if (!FramedStream.this.sink.finished) {
                if (this.sendBuffer.a() > 0L) {
                    while (this.sendBuffer.a() > 0L) {
                        this.emitDataFrame(true);
                    }
                } else {
                    FramedStream.this.connection.writeData(FramedStream.this.id, true, null, 0L);
                }
            }
            framedStream = FramedStream.this;
            // MONITORENTER : framedStream
            this.closed = true;
            // MONITOREXIT : framedStream
            FramedStream.this.connection.flush();
            FramedStream.this.cancelStreamIfNecessary();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void flush() throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(FramedStream.this)) {
                throw new AssertionError();
            }
            FramedStream framedStream = FramedStream.this;
            synchronized (framedStream) {
                FramedStream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.a() > 0L) {
                this.emitDataFrame(false);
                FramedStream.this.connection.flush();
            }
            return;
        }

        public u timeout() {
            return FramedStream.this.writeTimeout;
        }

        public void write(c c2, long l2) throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(FramedStream.this)) {
                throw new AssertionError();
            }
            this.sendBuffer.write(c2, l2);
            while (this.sendBuffer.a() >= 16384L) {
                this.emitDataFrame(false);
            }
        }
    }

    private final class FramedDataSource
    implements t {
        static final /* synthetic */ boolean $assertionsDisabled;
        private boolean closed;
        private boolean finished;
        private final long maxByteCount;
        private final c readBuffer;
        private final c receiveBuffer = new c();

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !FramedStream.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        private FramedDataSource(long l2) {
            this.readBuffer = new c();
            this.maxByteCount = l2;
        }

        static /* synthetic */ boolean access$102(FramedDataSource framedDataSource, boolean bl) {
            framedDataSource.finished = bl;
            return bl;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("stream closed");
            }
            if (FramedStream.this.errorCode != null) {
                throw new IOException("stream was reset: " + (Object)((Object)FramedStream.this.errorCode));
            }
        }

        private void waitUntilReadable() throws IOException {
            FramedStream.this.readTimeout.enter();
            try {
                while (this.readBuffer.a() == 0L && !this.finished && !this.closed && FramedStream.this.errorCode == null) {
                    FramedStream.this.waitForIo();
                }
            }
            finally {
                FramedStream.this.readTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            FramedStream framedStream = FramedStream.this;
            synchronized (framedStream) {
                this.closed = true;
                this.readBuffer.s();
                FramedStream.this.notifyAll();
            }
            FramedStream.this.cancelStreamIfNecessary();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long read(c object, long l2) throws IOException {
            if (l2 < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + l2);
            }
            Object object2 = FramedStream.this;
            synchronized (object2) {
                this.waitUntilReadable();
                this.checkNotClosed();
                if (this.readBuffer.a() == 0L) {
                    return -1L;
                }
                l2 = this.readBuffer.read(object, Math.min(l2, this.readBuffer.a()));
                object = FramedStream.this;
                object.unacknowledgedBytesRead += l2;
                if (FramedStream.this.unacknowledgedBytesRead >= (long)(((FramedStream)FramedStream.this).connection.okHttpSettings.getInitialWindowSize(65536) / 2)) {
                    FramedStream.this.connection.writeWindowUpdateLater(FramedStream.this.id, FramedStream.this.unacknowledgedBytesRead);
                    FramedStream.this.unacknowledgedBytesRead = 0L;
                }
            }
            object = FramedStream.this.connection;
            synchronized (object) {
                object2 = FramedStream.this.connection;
                ((FramedConnection)object2).unacknowledgedBytesRead += l2;
                if (((FramedStream)FramedStream.this).connection.unacknowledgedBytesRead < (long)(((FramedStream)FramedStream.this).connection.okHttpSettings.getInitialWindowSize(65536) / 2)) return l2;
                FramedStream.this.connection.writeWindowUpdateLater(0, ((FramedStream)FramedStream.this).connection.unacknowledgedBytesRead);
                ((FramedStream)FramedStream.this).connection.unacknowledgedBytesRead = 0L;
                return l2;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void receive(e var1_1, long var2_2) throws IOException {
            var4_3 = var2_2;
            if (FramedDataSource.$assertionsDisabled) ** GOTO lbl14
            var4_3 = var2_2;
            if (!Thread.holdsLock(FramedStream.this)) ** GOTO lbl14
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                var4_3 -= var2_2;
                var6_4 = FramedStream.this;
                synchronized (var6_4) {
                    var7_5 = this.readBuffer.a() == 0L;
                    this.readBuffer.a((t)this.receiveBuffer);
                    if (var7_5) {
                        FramedStream.this.notifyAll();
                    }
                }
lbl14:
                // 5 sources

                if (var4_3 <= 0L) return;
                var6_4 = FramedStream.this;
                synchronized (var6_4) {
                    var8_6 = this.finished;
                    var7_5 = this.readBuffer.a() + var4_3 > this.maxByteCount;
                    ** if (!var7_5) goto lbl23
                }
lbl-1000:
                // 1 sources

                {
                    var1_1.g(var4_3);
                    FramedStream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
lbl23:
                // 1 sources

                if (!var8_6) continue;
                var1_1.g(var4_3);
                return;
                ** while ((var2_2 = var1_1.read((c)this.receiveBuffer, (long)var4_3)) != -1L)
            }
lbl27:
            // 1 sources

            throw new EOFException();
        }

        public u timeout() {
            return FramedStream.this.readTimeout;
        }
    }

    class StreamTimeout
    extends a {
        StreamTimeout() {
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }

        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                socketTimeoutException.initCause(iOException);
            }
            return socketTimeoutException;
        }

        protected void timedOut() {
            FramedStream.this.closeLater(ErrorCode.CANCEL);
        }
    }
}

