/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.HttpUrl;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import s.c;
import s.f;
import s.t;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private Util() {
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) < 0L || l3 > l2 || l2 - l3 < l4) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeAll(Closeable closeable, Closeable object) throws IOException {
        block8: {
            Object var2_3 = null;
            try {
                closeable.close();
                closeable = var2_3;
            }
            catch (Throwable throwable) {}
            try {
                object.close();
                object = closeable;
            }
            catch (Throwable throwable) {
                object = closeable;
                if (closeable != null) break block8;
                object = throwable;
            }
        }
        if (object == null) {
            return;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new AssertionError(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket == null) return;
        try {
            serverSocket.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Socket socket) {
        if (socket == null) return;
        try {
            socket.close();
            return;
        }
        catch (AssertionError assertionError) {
            if (Util.isAndroidGetsocknameError(assertionError)) return;
            throw assertionError;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static String[] concat(String[] stringArray, String string2) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string2;
        return stringArray2;
    }

    public static boolean contains(String[] stringArray, String string2) {
        return Arrays.asList(stringArray).contains(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean discard(t t2, int n2, TimeUnit timeUnit) {
        try {
            return Util.skipAll(t2, n2, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equal(Object object, Object object2) {
        if (object == object2) return true;
        if (object == null) return false;
        if (!object.equals(object2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String hostHeader(HttpUrl object) {
        if (((HttpUrl)object).port() == HttpUrl.defaultPort(((HttpUrl)object).scheme())) return ((HttpUrl)object).host();
        return ((HttpUrl)object).host() + ":" + ((HttpUrl)object).port();
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    private static <T> List<T> intersect(T[] TArray, T[] TArray2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        block0: for (T t2 : TArray) {
            int n2 = TArray2.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) continue block0;
                T t3 = TArray2[n3];
                if (t2.equals(t3)) {
                    arrayList.add(t3);
                    continue block0;
                }
                ++n3;
            }
        }
        return arrayList;
    }

    public static <T> T[] intersect(Class<T> clazz, T[] object, T[] TArray) {
        object = Util.intersect(object, TArray);
        return object.toArray((Object[])Array.newInstance(clazz, object.size()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        if (((Throwable)((Object)assertionError)).getCause() == null) return false;
        if (((Throwable)((Object)assertionError)).getMessage() == null) return false;
        if (!((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String md5Hex(String string2) {
        void var0_2;
        try {
            return f.a((byte[])MessageDigest.getInstance("MD5").digest(string2.getBytes("UTF-8"))).f();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError(var0_2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError(var0_2);
        }
    }

    public static f sha1(f f2) {
        try {
            f2 = f.a((byte[])MessageDigest.getInstance("SHA-1").digest(f2.i()));
            return f2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String shaBase64(String string2) {
        void var0_2;
        try {
            return f.a((byte[])MessageDigest.getInstance("SHA-1").digest(string2.getBytes("UTF-8"))).b();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError(var0_2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError(var0_2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean skipAll(t t2, int n2, TimeUnit timeUnit) throws IOException {
        long l2;
        long l3;
        block9: {
            l3 = System.nanoTime();
            l2 = t2.timeout().hasDeadline() ? t2.timeout().deadlineNanoTime() - l3 : Long.MAX_VALUE;
            t2.timeout().deadlineNanoTime(Math.min(l2, timeUnit.toNanos(n2)) + l3);
            try {
                timeUnit = new c();
                while (t2.read((c)timeUnit, 2048L) != -1L) {
                    timeUnit.s();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (l2 == Long.MAX_VALUE) {
                    t2.timeout().clearDeadline();
                    return false;
                }
                break block9;
            }
            catch (Throwable throwable) {
                if (l2 == Long.MAX_VALUE) {
                    t2.timeout().clearDeadline();
                    throw throwable;
                }
                t2.timeout().deadlineNanoTime(l2 + l3);
                throw throwable;
            }
            if (l2 == Long.MAX_VALUE) {
                t2.timeout().clearDeadline();
                return true;
            } else {
                t2.timeout().deadlineNanoTime(l2 + l3);
            }
            return true;
        }
        t2.timeout().deadlineNanoTime(l2 + l3);
        return false;
    }

    public static ThreadFactory threadFactory(final String string2, final boolean bl) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, string2);
                ((Thread)runnable).setDaemon(bl);
                return runnable;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String toHumanReadableAscii(String string2) {
        int n2;
        String string3;
        int n3 = string2.length();
        int n4 = 0;
        while (true) {
            string3 = string2;
            if (n4 >= n3) return string3;
            n2 = string2.codePointAt(n4);
            if (n2 <= 31 || n2 >= 127) break;
            n4 += Character.charCount(n2);
        }
        string3 = new c();
        string3.a(string2, 0, n4);
        while (n4 < n3) {
            int n5 = string2.codePointAt(n4);
            n2 = n5 > 31 && n5 < 127 ? n5 : 63;
            string3.a(n2);
            n4 = Character.charCount(n5) + n4;
        }
        return string3.p();
    }
}

