/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.internal.Internal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private boolean isFallback;
    private boolean isFallbackPossible;
    private int nextModeIndex = 0;

    public ConnectionSpecSelector(List<ConnectionSpec> list) {
        this.connectionSpecs = list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFallbackPossible(SSLSocket sSLSocket) {
        int n2 = this.nextModeIndex;
        while (n2 < this.connectionSpecs.size()) {
            if (this.connectionSpecs.get(n2).isCompatible(sSLSocket)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) throws IOException {
        ConnectionSpec connectionSpec;
        block2: {
            int n2 = this.connectionSpecs.size();
            for (int i2 = this.nextModeIndex; i2 < n2; ++i2) {
                connectionSpec = this.connectionSpecs.get(i2);
                if (!connectionSpec.isCompatible(sSLSocket)) continue;
                this.nextModeIndex = i2 + 1;
                break block2;
            }
            connectionSpec = null;
        }
        if (connectionSpec == null) {
            throw new UnknownServiceException("Unable to find acceptable protocols. isFallback=" + this.isFallback + ", modes=" + this.connectionSpecs + ", supported protocols=" + Arrays.toString(sSLSocket.getEnabledProtocols()));
        }
        this.isFallbackPossible = this.isFallbackPossible(sSLSocket);
        Internal.instance.apply(connectionSpec, sSLSocket, this.isFallback);
        return connectionSpec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectionFailed(IOException iOException) {
        boolean bl = false;
        this.isFallback = true;
        if (!this.isFallbackPossible) {
            return bl;
        }
        boolean bl2 = bl;
        if (iOException instanceof ProtocolException) return bl2;
        bl2 = bl;
        if (iOException instanceof InterruptedIOException) return bl2;
        if (iOException instanceof SSLHandshakeException) {
            bl2 = bl;
            if (iOException.getCause() instanceof CertificateException) return bl2;
        }
        bl2 = bl;
        if (iOException instanceof SSLPeerUnverifiedException) return bl2;
        if (iOException instanceof SSLHandshakeException) return true;
        bl2 = bl;
        if (!(iOException instanceof SSLProtocolException)) return bl2;
        return true;
    }
}

