/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

public enum TlsVersion {
    TLS_1_2("TLSv1.2"),
    TLS_1_1("TLSv1.1"),
    TLS_1_0("TLSv1"),
    SSL_3_0("SSLv3");

    final String javaName;

    private TlsVersion(String string3) {
        this.javaName = string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static TlsVersion forJavaName(String object) {
        int n2 = -1;
        switch (object.hashCode()) {
            case -503070502: {
                if (!object.equals("TLSv1.2")) break;
                n2 = 0;
                break;
            }
            case -503070503: {
                if (!object.equals("TLSv1.1")) break;
                n2 = 1;
                break;
            }
            case 79923350: {
                if (!object.equals("TLSv1")) break;
                n2 = 2;
                break;
            }
            case 79201641: {
                if (!object.equals("SSLv3")) break;
                n2 = 3;
                break;
            }
        }
        switch (n2) {
            default: {
                throw new IllegalArgumentException("Unexpected TLS version: " + object);
            }
            case 0: {
                return TLS_1_2;
            }
            case 1: {
                return TLS_1_1;
            }
            case 2: {
                return TLS_1_0;
            }
            case 3: 
        }
        return SSL_3_0;
    }

    public String javaName() {
        return this.javaName;
    }
}

