/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import s.c;
import s.d;
import s.f;

public final class MultipartBuilder {
    public static final MediaType ALTERNATIVE;
    private static final byte[] COLONSPACE;
    private static final byte[] CRLF;
    private static final byte[] DASHDASH;
    public static final MediaType DIGEST;
    public static final MediaType FORM;
    public static final MediaType MIXED;
    public static final MediaType PARALLEL;
    private final f boundary;
    private final List<RequestBody> partBodies;
    private final List<Headers> partHeaders;
    private MediaType type = MIXED;

    static {
        MIXED = MediaType.parse("multipart/mixed");
        ALTERNATIVE = MediaType.parse("multipart/alternative");
        DIGEST = MediaType.parse("multipart/digest");
        PARALLEL = MediaType.parse("multipart/parallel");
        FORM = MediaType.parse("multipart/form-data");
        COLONSPACE = new byte[]{58, 32};
        CRLF = new byte[]{13, 10};
        DASHDASH = new byte[]{45, 45};
    }

    public MultipartBuilder() {
        this(UUID.randomUUID().toString());
    }

    public MultipartBuilder(String string2) {
        this.partHeaders = new ArrayList<Headers>();
        this.partBodies = new ArrayList<RequestBody>();
        this.boundary = f.a((String)string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static StringBuilder appendQuotedString(StringBuilder stringBuilder, String string2) {
        stringBuilder.append('\"');
        int n2 = 0;
        int n3 = string2.length();
        while (true) {
            if (n2 >= n3) {
                stringBuilder.append('\"');
                return stringBuilder;
            }
            char c2 = string2.charAt(n2);
            switch (c2) {
                default: {
                    stringBuilder.append(c2);
                    break;
                }
                case '\n': {
                    stringBuilder.append("%0A");
                    break;
                }
                case '\r': {
                    stringBuilder.append("%0D");
                    break;
                }
                case '\"': {
                    stringBuilder.append("%22");
                }
            }
            ++n2;
        }
    }

    public MultipartBuilder addFormDataPart(String string2, String string3) {
        return this.addFormDataPart(string2, null, RequestBody.create(null, string3));
    }

    public MultipartBuilder addFormDataPart(String string2, String string3, RequestBody requestBody) {
        if (string2 == null) {
            throw new NullPointerException("name == null");
        }
        StringBuilder stringBuilder = new StringBuilder("form-data; name=");
        MultipartBuilder.appendQuotedString(stringBuilder, string2);
        if (string3 != null) {
            stringBuilder.append("; filename=");
            MultipartBuilder.appendQuotedString(stringBuilder, string3);
        }
        return this.addPart(Headers.of("Content-Disposition", stringBuilder.toString()), requestBody);
    }

    public MultipartBuilder addPart(Headers headers, RequestBody requestBody) {
        if (requestBody == null) {
            throw new NullPointerException("body == null");
        }
        if (headers != null && headers.get("Content-Type") != null) {
            throw new IllegalArgumentException("Unexpected header: Content-Type");
        }
        if (headers != null && headers.get("Content-Length") != null) {
            throw new IllegalArgumentException("Unexpected header: Content-Length");
        }
        this.partHeaders.add(headers);
        this.partBodies.add(requestBody);
        return this;
    }

    public MultipartBuilder addPart(RequestBody requestBody) {
        return this.addPart(null, requestBody);
    }

    public RequestBody build() {
        if (this.partHeaders.isEmpty()) {
            throw new IllegalStateException("Multipart body must have at least one part.");
        }
        return new MultipartRequestBody(this.type, this.boundary, this.partHeaders, this.partBodies);
    }

    public MultipartBuilder type(MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("type == null");
        }
        if (!mediaType.type().equals("multipart")) {
            throw new IllegalArgumentException("multipart != " + mediaType);
        }
        this.type = mediaType;
        return this;
    }

    private static final class MultipartRequestBody
    extends RequestBody {
        private final f boundary;
        private long contentLength = -1L;
        private final MediaType contentType;
        private final List<RequestBody> partBodies;
        private final List<Headers> partHeaders;

        public MultipartRequestBody(MediaType mediaType, f f2, List<Headers> list, List<RequestBody> list2) {
            if (mediaType == null) {
                throw new NullPointerException("type == null");
            }
            this.boundary = f2;
            this.contentType = MediaType.parse(mediaType + "; boundary=" + f2.a());
            this.partHeaders = Util.immutableList(list);
            this.partBodies = Util.immutableList(list2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private long writeOrCountBytes(d d2, boolean bl) throws IOException {
            long l2 = 0L;
            d d3 = bl ? (d2 = new c()) : null;
            int n2 = this.partHeaders.size();
            int n3 = 0;
            while (true) {
                long l3;
                if (n3 >= n2) {
                    d2.c(DASHDASH);
                    d2.b(this.boundary);
                    d2.c(DASHDASH);
                    d2.c(CRLF);
                    l3 = l2;
                    if (!bl) return l3;
                    l3 = l2 + d3.a();
                    d3.s();
                    return l3;
                }
                Object object = this.partHeaders.get(n3);
                RequestBody requestBody = this.partBodies.get(n3);
                d2.c(DASHDASH);
                d2.b(this.boundary);
                d2.c(CRLF);
                if (object != null) {
                    int n4 = ((Headers)object).size();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        d2.b(((Headers)object).name(i2)).c(COLONSPACE).b(((Headers)object).value(i2)).c(CRLF);
                    }
                }
                if ((object = requestBody.contentType()) != null) {
                    d2.b("Content-Type: ").b(((MediaType)object).toString()).c(CRLF);
                }
                if ((l3 = requestBody.contentLength()) != -1L) {
                    d2.b("Content-Length: ").k(l3).c(CRLF);
                } else if (bl) {
                    d3.s();
                    return -1L;
                }
                d2.c(CRLF);
                if (bl) {
                    l2 = l3 + l2;
                } else {
                    this.partBodies.get(n3).writeTo(d2);
                }
                d2.c(CRLF);
                ++n3;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long contentLength() throws IOException {
            long l2 = this.contentLength;
            if (l2 != -1L) {
                return l2;
            }
            this.contentLength = l2 = this.writeOrCountBytes(null, true);
            return l2;
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public void writeTo(d d2) throws IOException {
            this.writeOrCountBytes(d2, false);
        }
    }
}

