/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.Util;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import s.f;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Map<String, Set<f>> hostnameToPins;

    private CertificatePinner(Builder builder) {
        this.hostnameToPins = Util.immutableMap(builder.hostnameToPins);
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha1/" + CertificatePinner.sha1((X509Certificate)certificate).b();
    }

    private static f sha1(X509Certificate x509Certificate) {
        return Util.sha1(f.a((byte[])x509Certificate.getPublicKey().getEncoded()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void check(String string2, List<Certificate> object) throws SSLPeerUnverifiedException {
        int n2;
        Iterator<f> iterator;
        int n3 = 0;
        Set<f> set = this.findMatchingPins(string2);
        if (set == null) return;
        int n4 = iterator.size();
        for (n2 = 0; n2 < n4; ++n2) {
            if (set.contains(CertificatePinner.sha1((X509Certificate)iterator.get(n2)))) return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        n4 = iterator.size();
        for (n2 = n3; n2 < n4; ++n2) {
            X509Certificate x509Certificate = (X509Certificate)iterator.get(n2);
            stringBuilder.append("\n    ").append(CertificatePinner.pin(x509Certificate)).append(": ").append(x509Certificate.getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(string2).append(":");
        iterator = set.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                throw new SSLPeerUnverifiedException(stringBuilder.toString());
            }
            f f2 = iterator.next();
            stringBuilder.append("\n    sha1/").append(f2.b());
        }
    }

    public void check(String string2, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string2, Arrays.asList(certificateArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    Set<f> findMatchingPins(String set) {
        Set<f> set2 = this.hostnameToPins.get(set);
        int n2 = ((String)((Object)set)).indexOf(46);
        Set<f> set3 = n2 != ((String)((Object)set)).lastIndexOf(46) ? this.hostnameToPins.get("*." + ((String)((Object)set)).substring(n2 + 1)) : null;
        if (set2 == null && set3 == null) {
            return null;
        }
        if (set2 != null && set3 != null) {
            set = new LinkedHashSet();
            set.addAll(set2);
            set.addAll(set3);
            return set;
        }
        set = set2;
        if (set2 != null) return set;
        return set3;
    }

    public static final class Builder {
        private final Map<String, Set<f>> hostnameToPins = new LinkedHashMap<String, Set<f>>();

        /*
         * WARNING - void declaration
         */
        public Builder add(String object2, String ... stringArray) {
            void var2_5;
            if (object2 == null) {
                throw new IllegalArgumentException("hostname == null");
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Set set = this.hostnameToPins.put((String)object2, Collections.unmodifiableSet(linkedHashSet));
            if (set != null) {
                linkedHashSet.addAll(set);
            }
            for (void var1_4 : var2_5) {
                if (!var1_4.startsWith("sha1/")) {
                    throw new IllegalArgumentException("pins must start with 'sha1/': " + (String)var1_4);
                }
                f f2 = f.b((String)var1_4.substring("sha1/".length()));
                if (f2 == null) {
                    throw new IllegalArgumentException("pins must be base64: " + (String)var1_4);
                }
                linkedHashSet.add(f2);
            }
            return this;
        }

        public CertificatePinner build() {
            return new CertificatePinner(this);
        }
    }
}

