/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.internal.http.HeaderParser;
import java.util.concurrent.TimeUnit;

public final class CacheControl {
    public static final CacheControl FORCE_CACHE;
    public static final CacheControl FORCE_NETWORK;
    String headerValue;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final int maxAgeSeconds;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean mustRevalidate;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean noTransform;
    private final boolean onlyIfCached;
    private final int sMaxAgeSeconds;

    static {
        FORCE_NETWORK = new Builder().noCache().build();
        FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    }

    private CacheControl(Builder builder) {
        this.noCache = builder.noCache;
        this.noStore = builder.noStore;
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.sMaxAgeSeconds = -1;
        this.isPrivate = false;
        this.isPublic = false;
        this.mustRevalidate = false;
        this.maxStaleSeconds = builder.maxStaleSeconds;
        this.minFreshSeconds = builder.minFreshSeconds;
        this.onlyIfCached = builder.onlyIfCached;
        this.noTransform = builder.noTransform;
    }

    private CacheControl(boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, boolean bl5, int n4, int n5, boolean bl6, boolean bl7, String string2) {
        this.noCache = bl;
        this.noStore = bl2;
        this.maxAgeSeconds = n2;
        this.sMaxAgeSeconds = n3;
        this.isPrivate = bl3;
        this.isPublic = bl4;
        this.mustRevalidate = bl5;
        this.maxStaleSeconds = n4;
        this.minFreshSeconds = n5;
        this.onlyIfCached = bl6;
        this.noTransform = bl7;
        this.headerValue = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String headerValue() {
        CharSequence charSequence = new StringBuilder();
        if (this.noCache) {
            ((StringBuilder)charSequence).append("no-cache, ");
        }
        if (this.noStore) {
            ((StringBuilder)charSequence).append("no-store, ");
        }
        if (this.maxAgeSeconds != -1) {
            ((StringBuilder)charSequence).append("max-age=").append(this.maxAgeSeconds).append(", ");
        }
        if (this.sMaxAgeSeconds != -1) {
            ((StringBuilder)charSequence).append("s-maxage=").append(this.sMaxAgeSeconds).append(", ");
        }
        if (this.isPrivate) {
            ((StringBuilder)charSequence).append("private, ");
        }
        if (this.isPublic) {
            ((StringBuilder)charSequence).append("public, ");
        }
        if (this.mustRevalidate) {
            ((StringBuilder)charSequence).append("must-revalidate, ");
        }
        if (this.maxStaleSeconds != -1) {
            ((StringBuilder)charSequence).append("max-stale=").append(this.maxStaleSeconds).append(", ");
        }
        if (this.minFreshSeconds != -1) {
            ((StringBuilder)charSequence).append("min-fresh=").append(this.minFreshSeconds).append(", ");
        }
        if (this.onlyIfCached) {
            ((StringBuilder)charSequence).append("only-if-cached, ");
        }
        if (this.noTransform) {
            ((StringBuilder)charSequence).append("no-transform, ");
        }
        if (((StringBuilder)charSequence).length() == 0) {
            return "";
        }
        ((StringBuilder)charSequence).delete(((StringBuilder)charSequence).length() - 2, ((StringBuilder)charSequence).length());
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CacheControl parse(Headers headers) {
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = -1;
        int n5 = -1;
        boolean bl5 = false;
        boolean bl6 = false;
        int n6 = 1;
        int n7 = headers.size();
        int n8 = 0;
        String string2 = null;
        boolean bl7 = false;
        while (true) {
            boolean bl8;
            int n9;
            int n10;
            boolean bl9;
            boolean bl10;
            boolean bl11;
            int n11;
            int n12;
            boolean bl12;
            boolean bl13;
            int n13;
            boolean bl14;
            String string3;
            block23: {
                String string4;
                block19: {
                    block20: {
                        block22: {
                            block21: {
                                if (n8 >= n7) break block20;
                                string3 = headers.name(n8);
                                string4 = headers.value(n8);
                                if (!string3.equalsIgnoreCase("Cache-Control")) break block21;
                                if (string2 != null) {
                                    n6 = 0;
                                    break block19;
                                } else {
                                    string2 = string4;
                                }
                                break block19;
                            }
                            if (!string3.equalsIgnoreCase("Pragma")) break block22;
                            n6 = 0;
                            break block19;
                        }
                        bl14 = bl7;
                        n13 = n6;
                        bl13 = bl6;
                        bl12 = bl5;
                        n12 = n5;
                        n11 = n4;
                        bl11 = bl4;
                        bl10 = bl3;
                        bl9 = bl2;
                        n10 = n3;
                        n9 = n2;
                        bl8 = bl;
                        string3 = string2;
                        break block23;
                    }
                    if (n6 == 0) {
                        string2 = null;
                    }
                    return new CacheControl(bl7, bl, n2, n3, bl2, bl3, bl4, n4, n5, bl5, bl6, string2);
                }
                int n14 = 0;
                while (true) {
                    string3 = string2;
                    bl8 = bl;
                    n9 = n2;
                    n10 = n3;
                    bl9 = bl2;
                    bl10 = bl3;
                    bl11 = bl4;
                    n11 = n4;
                    n12 = n5;
                    bl12 = bl5;
                    bl13 = bl6;
                    n13 = n6;
                    bl14 = bl7;
                    if (n14 >= string4.length()) break;
                    n13 = HeaderParser.skipUntil(string4, n14, "=,;");
                    String string5 = string4.substring(n14, n13).trim();
                    if (n13 == string4.length() || string4.charAt(n13) == ',' || string4.charAt(n13) == ';') {
                        ++n13;
                        string3 = null;
                    } else {
                        n14 = HeaderParser.skipWhitespace(string4, n13 + 1);
                        if (n14 < string4.length() && string4.charAt(n14) == '\"') {
                            n13 = HeaderParser.skipUntil(string4, ++n14, "\"");
                            string3 = string4.substring(n14, n13);
                            ++n13;
                        } else {
                            n13 = HeaderParser.skipUntil(string4, n14, ",;");
                            string3 = string4.substring(n14, n13).trim();
                        }
                    }
                    if ("no-cache".equalsIgnoreCase(string5)) {
                        bl7 = true;
                        n14 = n13;
                        continue;
                    }
                    if ("no-store".equalsIgnoreCase(string5)) {
                        bl = true;
                        n14 = n13;
                        continue;
                    }
                    if ("max-age".equalsIgnoreCase(string5)) {
                        n2 = HeaderParser.parseSeconds(string3, -1);
                        n14 = n13;
                        continue;
                    }
                    if ("s-maxage".equalsIgnoreCase(string5)) {
                        n3 = HeaderParser.parseSeconds(string3, -1);
                        n14 = n13;
                        continue;
                    }
                    if ("private".equalsIgnoreCase(string5)) {
                        bl2 = true;
                        n14 = n13;
                        continue;
                    }
                    if ("public".equalsIgnoreCase(string5)) {
                        bl3 = true;
                        n14 = n13;
                        continue;
                    }
                    if ("must-revalidate".equalsIgnoreCase(string5)) {
                        bl4 = true;
                        n14 = n13;
                        continue;
                    }
                    if ("max-stale".equalsIgnoreCase(string5)) {
                        n4 = HeaderParser.parseSeconds(string3, Integer.MAX_VALUE);
                        n14 = n13;
                        continue;
                    }
                    if ("min-fresh".equalsIgnoreCase(string5)) {
                        n5 = HeaderParser.parseSeconds(string3, -1);
                        n14 = n13;
                        continue;
                    }
                    if ("only-if-cached".equalsIgnoreCase(string5)) {
                        bl5 = true;
                        n14 = n13;
                        continue;
                    }
                    n14 = n13;
                    if (!"no-transform".equalsIgnoreCase(string5)) continue;
                    bl6 = true;
                    n14 = n13;
                }
            }
            ++n8;
            bl7 = bl14;
            string2 = string3;
            bl = bl8;
            n2 = n9;
            n3 = n10;
            bl2 = bl9;
            bl3 = bl10;
            bl4 = bl11;
            n4 = n11;
            n5 = n12;
            bl5 = bl12;
            bl6 = bl13;
            n6 = n13;
        }
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public boolean noTransform() {
        return this.noTransform;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2 = this.headerValue;
        if (string2 != null) {
            return string2;
        }
        this.headerValue = string2 = this.headerValue();
        return string2;
    }

    public static final class Builder {
        int maxAgeSeconds = -1;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean noCache;
        boolean noStore;
        boolean noTransform;
        boolean onlyIfCached;

        public CacheControl build() {
            return new CacheControl(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder maxAge(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("maxAge < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            n2 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            this.maxAgeSeconds = n2;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder maxStale(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("maxStale < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            n2 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            this.maxStaleSeconds = n2;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder minFresh(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("minFresh < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            n2 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            this.minFreshSeconds = n2;
            return this;
        }

        public Builder noCache() {
            this.noCache = true;
            return this;
        }

        public Builder noStore() {
            this.noStore = true;
            return this;
        }

        public Builder noTransform() {
            this.noTransform = true;
            return this;
        }

        public Builder onlyIfCached() {
            this.onlyIfCached = true;
            return this;
        }
    }
}

