/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import java.nio.ByteBuffer;

public class VisualRandomAccessEntry
extends GroupEntry {
    public static final String TYPE = "rap ";
    private short numLeadingSamples;
    private boolean numLeadingSamplesKnown;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return bl;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (VisualRandomAccessEntry)object;
        if (this.numLeadingSamples != ((VisualRandomAccessEntry)object).numLeadingSamples) {
            return false;
        }
        if (this.numLeadingSamplesKnown == ((VisualRandomAccessEntry)object).numLeadingSamplesKnown) return bl;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ByteBuffer get() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        int n2 = this.numLeadingSamplesKnown ? 128 : 0;
        byteBuffer.put((byte)(n2 | this.numLeadingSamples & 0x7F));
        byteBuffer.rewind();
        return byteBuffer;
    }

    public short getNumLeadingSamples() {
        return this.numLeadingSamples;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n2;
        if (this.numLeadingSamplesKnown) {
            n2 = 1;
            return n2 * 31 + this.numLeadingSamples;
        }
        n2 = 0;
        return n2 * 31 + this.numLeadingSamples;
    }

    public boolean isNumLeadingSamplesKnown() {
        return this.numLeadingSamplesKnown;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        boolean bl = (by & 0x80) == 128;
        this.numLeadingSamplesKnown = bl;
        this.numLeadingSamples = (short)(by & 0x7F);
    }

    public void setNumLeadingSamples(short s2) {
        this.numLeadingSamples = s2;
    }

    public void setNumLeadingSamplesKnown(boolean bl) {
        this.numLeadingSamplesKnown = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("VisualRandomAccessEntry");
        stringBuilder.append("{numLeadingSamplesKnown=").append(this.numLeadingSamplesKnown);
        stringBuilder.append(", numLeadingSamples=").append(this.numLeadingSamples);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

