/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class CencSampleEncryptionInformationGroupEntry
extends GroupEntry {
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String TYPE = "seig";
    private int isEncrypted;
    private byte ivSize;
    private byte[] kid = new byte[16];

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !CencSampleEncryptionInformationGroupEntry.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return bl;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CencSampleEncryptionInformationGroupEntry)object;
        if (this.isEncrypted != ((CencSampleEncryptionInformationGroupEntry)object).isEncrypted) {
            return false;
        }
        if (this.ivSize != ((CencSampleEncryptionInformationGroupEntry)object).ivSize) {
            return false;
        }
        if (Arrays.equals(this.kid, ((CencSampleEncryptionInformationGroupEntry)object).kid)) return bl;
        return false;
    }

    @Override
    public ByteBuffer get() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        IsoTypeWriter.writeUInt24(byteBuffer, this.isEncrypted);
        IsoTypeWriter.writeUInt8(byteBuffer, this.ivSize);
        byteBuffer.put(this.kid);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public int getEncrypted() {
        return this.isEncrypted;
    }

    public byte getIvSize() {
        return this.ivSize;
    }

    public byte[] getKid() {
        return this.kid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n2;
        int n3 = this.isEncrypted;
        byte by = this.ivSize;
        if (this.kid != null) {
            n2 = Arrays.hashCode(this.kid);
            return n2 + (n3 * 31 + by) * 31;
        }
        n2 = 0;
        return n2 + (n3 * 31 + by) * 31;
    }

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.isEncrypted = IsoTypeReader.readUInt24(byteBuffer);
        this.ivSize = (byte)IsoTypeReader.readUInt8(byteBuffer);
        this.kid = new byte[16];
        byteBuffer.get(this.kid);
    }

    public void setEncrypted(int n2) {
        this.isEncrypted = n2;
    }

    public void setIvSize(byte by) {
        this.ivSize = by;
    }

    public void setKid(byte[] byArray) {
        if (!$assertionsDisabled && byArray.length != 16) {
            throw new AssertionError();
        }
        this.kid = byArray;
    }

    public String toString() {
        return "CencSampleEncryptionInformationGroupEntry{isEncrypted=" + this.isEncrypted + ", ivSize=" + this.ivSize + ", kid=" + Hex.encodeHex(this.kid) + '}';
    }
}

