/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MultiplyTimeScaleTrack
implements Track {
    Track source;
    private int timeScaleFactor;

    public MultiplyTimeScaleTrack(Track track, int n2) {
        this.source = track;
        this.timeScaleFactor = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<CompositionTimeToSample.Entry> adjustCtts(List<CompositionTimeToSample.Entry> object, int n2) {
        if (object == null) return null;
        ArrayList<CompositionTimeToSample.Entry> arrayList = new ArrayList<CompositionTimeToSample.Entry>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (CompositionTimeToSample.Entry)iterator.next();
            arrayList.add(new CompositionTimeToSample.Entry(((CompositionTimeToSample.Entry)object).getCount(), ((CompositionTimeToSample.Entry)object).getOffset() * n2));
        }
        return arrayList;
    }

    static List<TimeToSampleBox.Entry> adjustTts(List<TimeToSampleBox.Entry> object, int n2) {
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>();
        object = object.iterator();
        while (object.hasNext()) {
            TimeToSampleBox.Entry entry = (TimeToSampleBox.Entry)object.next();
            linkedList.add(new TimeToSampleBox.Entry(entry.getCount(), (long)n2 * entry.getDelta()));
        }
        return linkedList;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return MultiplyTimeScaleTrack.adjustCtts(this.source.getCompositionTimeEntries(), this.timeScaleFactor);
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return MultiplyTimeScaleTrack.adjustTts(this.source.getDecodingTimeEntries(), this.timeScaleFactor);
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.source.getMediaHeaderBox();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public List<Sample> getSamples() {
        return this.source.getSamples();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        TrackMetaData trackMetaData = (TrackMetaData)this.source.getTrackMetaData().clone();
        trackMetaData.setTimescale(this.source.getTrackMetaData().getTimescale() * (long)this.timeScaleFactor);
        return trackMetaData;
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public boolean isInMovie() {
        return this.source.isInMovie();
    }

    @Override
    public boolean isInPoster() {
        return this.source.isInPoster();
    }

    @Override
    public boolean isInPreview() {
        return this.source.isInPreview();
    }

    public String toString() {
        return "MultiplyTimeScaleTrack{source=" + this.source + '}';
    }
}

