/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.mp4.AbstractDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.AbstractSequentialList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AACTrackImpl
extends AbstractTrack {
    static Map<Integer, String> audioObjectTypes = new HashMap<Integer, String>();
    public static Map<Integer, Integer> samplingFrequencyIndexMap;
    long avgBitRate;
    int bufferSizeDB;
    AdtsHeader firstHeader;
    private String lang = "eng";
    long maxBitRate;
    SampleDescriptionBox sampleDescriptionBox;
    private List<Sample> samples;
    List<TimeToSampleBox.Entry> stts;
    TrackMetaData trackMetaData = new TrackMetaData();

    static {
        audioObjectTypes.put(1, "AAC Main");
        audioObjectTypes.put(2, "AAC LC (Low Complexity)");
        audioObjectTypes.put(3, "AAC SSR (Scalable Sample Rate)");
        audioObjectTypes.put(4, "AAC LTP (Long Term Prediction)");
        audioObjectTypes.put(5, "SBR (Spectral Band Replication)");
        audioObjectTypes.put(6, "AAC Scalable");
        audioObjectTypes.put(7, "TwinVQ");
        audioObjectTypes.put(8, "CELP (Code Excited Linear Prediction)");
        audioObjectTypes.put(9, "HXVC (Harmonic Vector eXcitation Coding)");
        audioObjectTypes.put(10, "Reserved");
        audioObjectTypes.put(11, "Reserved");
        audioObjectTypes.put(12, "TTSI (Text-To-Speech Interface)");
        audioObjectTypes.put(13, "Main Synthesis");
        audioObjectTypes.put(14, "Wavetable Synthesis");
        audioObjectTypes.put(15, "General MIDI");
        audioObjectTypes.put(16, "Algorithmic Synthesis and Audio Effects");
        audioObjectTypes.put(17, "ER (Error Resilient) AAC LC");
        audioObjectTypes.put(18, "Reserved");
        audioObjectTypes.put(19, "ER AAC LTP");
        audioObjectTypes.put(20, "ER AAC Scalable");
        audioObjectTypes.put(21, "ER TwinVQ");
        audioObjectTypes.put(22, "ER BSAC (Bit-Sliced Arithmetic Coding)");
        audioObjectTypes.put(23, "ER AAC LD (Low Delay)");
        audioObjectTypes.put(24, "ER CELP");
        audioObjectTypes.put(25, "ER HVXC");
        audioObjectTypes.put(26, "ER HILN (Harmonic and Individual Lines plus Noise)");
        audioObjectTypes.put(27, "ER Parametric");
        audioObjectTypes.put(28, "SSC (SinuSoidal Coding)");
        audioObjectTypes.put(29, "PS (Parametric Stereo)");
        audioObjectTypes.put(30, "MPEG Surround");
        audioObjectTypes.put(31, "(Escape value)");
        audioObjectTypes.put(32, "Layer-1");
        audioObjectTypes.put(33, "Layer-2");
        audioObjectTypes.put(34, "Layer-3");
        audioObjectTypes.put(35, "DST (Direct Stream Transfer)");
        audioObjectTypes.put(36, "ALS (Audio Lossless)");
        audioObjectTypes.put(37, "SLS (Scalable LosslesS)");
        audioObjectTypes.put(38, "SLS non-core");
        audioObjectTypes.put(39, "ER AAC ELD (Enhanced Low Delay)");
        audioObjectTypes.put(40, "SMR (Symbolic Music Representation) Simple");
        audioObjectTypes.put(41, "SMR Main");
        audioObjectTypes.put(42, "USAC (Unified Speech and Audio Coding) (no SBR)");
        audioObjectTypes.put(43, "SAOC (Spatial Audio Object Coding)");
        audioObjectTypes.put(44, "LD MPEG Surround");
        audioObjectTypes.put(45, "USAC");
        samplingFrequencyIndexMap = new HashMap<Integer, Integer>();
        samplingFrequencyIndexMap.put(96000, 0);
        samplingFrequencyIndexMap.put(88200, 1);
        samplingFrequencyIndexMap.put(64000, 2);
        samplingFrequencyIndexMap.put(48000, 3);
        samplingFrequencyIndexMap.put(44100, 4);
        samplingFrequencyIndexMap.put(32000, 5);
        samplingFrequencyIndexMap.put(24000, 6);
        samplingFrequencyIndexMap.put(22050, 7);
        samplingFrequencyIndexMap.put(16000, 8);
        samplingFrequencyIndexMap.put(12000, 9);
        samplingFrequencyIndexMap.put(11025, 10);
        samplingFrequencyIndexMap.put(8000, 11);
        samplingFrequencyIndexMap.put(0, 96000);
        samplingFrequencyIndexMap.put(1, 88200);
        samplingFrequencyIndexMap.put(2, 64000);
        samplingFrequencyIndexMap.put(3, 48000);
        samplingFrequencyIndexMap.put(4, 44100);
        samplingFrequencyIndexMap.put(5, 32000);
        samplingFrequencyIndexMap.put(6, 24000);
        samplingFrequencyIndexMap.put(7, 22050);
        samplingFrequencyIndexMap.put(8, 16000);
        samplingFrequencyIndexMap.put(9, 12000);
        samplingFrequencyIndexMap.put(10, 11025);
        samplingFrequencyIndexMap.put(11, 8000);
    }

    public AACTrackImpl(DataSource dataSource) throws IOException {
        this.parse(dataSource);
    }

    public AACTrackImpl(DataSource dataSource, String string2) throws IOException {
        this.lang = string2;
        this.parse(dataSource);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parse(DataSource object) throws IOException {
        this.stts = new LinkedList<TimeToSampleBox.Entry>();
        this.samples = new LinkedList<Sample>();
        this.firstHeader = this.readSamples((DataSource)object);
        double d2 = (double)this.firstHeader.sampleRate / 1024.0;
        double d3 = (double)this.samples.size() / d2;
        Object object2 = new LinkedList<Integer>();
        object = this.samples.iterator();
        long l2 = 0L;
        block0: while (true) {
            Iterator<Box> iterator;
            if (!object.hasNext()) {
                this.avgBitRate = (int)((double)(8L * l2) / d3);
                this.bufferSizeDB = 1536;
                this.sampleDescriptionBox = new SampleDescriptionBox();
                iterator = new AudioSampleEntry("mp4a");
                ((AudioSampleEntry)iterator).setChannelCount(2);
                ((AudioSampleEntry)iterator).setSampleRate(this.firstHeader.sampleRate);
                ((AbstractSampleEntry)iterator).setDataReferenceIndex(1);
                ((AudioSampleEntry)iterator).setSampleSize(16);
                object2 = new ESDescriptorBox();
                object = new ESDescriptor();
                object.setEsId(0);
                SLConfigDescriptor sLConfigDescriptor = new SLConfigDescriptor();
                sLConfigDescriptor.setPredefined(2);
                object.setSlConfigDescriptor(sLConfigDescriptor);
                sLConfigDescriptor = new DecoderConfigDescriptor();
                sLConfigDescriptor.setObjectTypeIndication(64);
                sLConfigDescriptor.setStreamType(5);
                sLConfigDescriptor.setBufferSizeDB(this.bufferSizeDB);
                sLConfigDescriptor.setMaxBitRate(this.maxBitRate);
                sLConfigDescriptor.setAvgBitRate(this.avgBitRate);
                AudioSpecificConfig audioSpecificConfig = new AudioSpecificConfig();
                audioSpecificConfig.setAudioObjectType(2);
                audioSpecificConfig.setSamplingFrequencyIndex(this.firstHeader.sampleFrequencyIndex);
                audioSpecificConfig.setChannelConfiguration(this.firstHeader.channelconfig);
                sLConfigDescriptor.setAudioSpecificInfo(audioSpecificConfig);
                object.setDecoderConfigDescriptor((DecoderConfigDescriptor)sLConfigDescriptor);
                ((AbstractDescriptorBox)((Object)object2)).setData(object.serialize());
                ((BasicContainer)iterator).addBox((Box)object2);
                this.sampleDescriptionBox.addBox((Box)((Object)iterator));
                this.trackMetaData.setCreationTime(new Date());
                this.trackMetaData.setModificationTime(new Date());
                this.trackMetaData.setLanguage(this.lang);
                this.trackMetaData.setVolume(1.0f);
                this.trackMetaData.setTimescale(this.firstHeader.sampleRate);
                return;
            }
            int n2 = (int)((Sample)object.next()).remaining();
            long l3 = l2 + (long)n2;
            ((LinkedList)object2).add(n2);
            while (true) {
                if (!((double)((LinkedList)object2).size() > d2)) {
                    l2 = l3;
                    if (((LinkedList)object2).size() != (int)d2) continue block0;
                    break;
                }
                ((LinkedList)object2).pop();
            }
            iterator = ((AbstractSequentialList)object2).iterator();
            n2 = 0;
            while (true) {
                if (!iterator.hasNext()) {
                    double d4 = (double)n2 * 8.0 / (double)((LinkedList)object2).size() * d2;
                    l2 = l3;
                    if (!(d4 > (double)this.maxBitRate)) continue block0;
                    this.maxBitRate = (int)d4;
                    l2 = l3;
                    continue block0;
                }
                n2 = (Integer)((Object)iterator.next()) + n2;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AdtsHeader readADTSHeader(DataSource object) throws IOException {
        Object object2;
        AdtsHeader adtsHeader;
        block3: {
            adtsHeader = new AdtsHeader();
            object2 = ByteBuffer.allocate(7);
            do {
                if (((Buffer)object2).position() < 7) continue;
                if (((BitReaderBuffer)(object2 = new BitReaderBuffer((ByteBuffer)((ByteBuffer)object2).rewind()))).readBits(12) != 4095) {
                    throw new IOException("Expected Start Word 0xfff");
                }
                break block3;
            } while (object.read((ByteBuffer)object2) != -1);
            return null;
        }
        adtsHeader.mpegVersion = ((BitReaderBuffer)object2).readBits(1);
        adtsHeader.layer = ((BitReaderBuffer)object2).readBits(2);
        adtsHeader.protectionAbsent = ((BitReaderBuffer)object2).readBits(1);
        adtsHeader.profile = ((BitReaderBuffer)object2).readBits(2) + 1;
        adtsHeader.sampleFrequencyIndex = ((BitReaderBuffer)object2).readBits(4);
        adtsHeader.sampleRate = samplingFrequencyIndexMap.get(adtsHeader.sampleFrequencyIndex);
        ((BitReaderBuffer)object2).readBits(1);
        adtsHeader.channelconfig = ((BitReaderBuffer)object2).readBits(3);
        adtsHeader.original = ((BitReaderBuffer)object2).readBits(1);
        adtsHeader.home = ((BitReaderBuffer)object2).readBits(1);
        adtsHeader.copyrightedStream = ((BitReaderBuffer)object2).readBits(1);
        adtsHeader.copyrightStart = ((BitReaderBuffer)object2).readBits(1);
        adtsHeader.frameLength = ((BitReaderBuffer)object2).readBits(13);
        adtsHeader.bufferFullness = ((BitReaderBuffer)object2).readBits(11);
        adtsHeader.numAacFramesPerAdtsFrame = ((BitReaderBuffer)object2).readBits(2) + 1;
        if (adtsHeader.numAacFramesPerAdtsFrame != 1) {
            throw new IOException("This muxer can only work with 1 AAC frame per ADTS frame");
        }
        if (adtsHeader.protectionAbsent != 0) return adtsHeader;
        object.read(ByteBuffer.allocate(2));
        return adtsHeader;
    }

    private AdtsHeader readSamples(DataSource dataSource) throws IOException {
        Object object = null;
        AdtsHeader adtsHeader;
        while ((adtsHeader = this.readADTSHeader(dataSource)) != null) {
            AdtsHeader adtsHeader2 = object;
            if (object == null) {
                adtsHeader2 = adtsHeader;
            }
            object = dataSource.map(dataSource.position(), adtsHeader.frameLength - adtsHeader.getSize());
            this.samples.add(new SampleImpl((ByteBuffer)object));
            dataSource.position(dataSource.position() + (long)adtsHeader.frameLength - (long)adtsHeader.getSize());
            ((ByteBuffer)object).rewind();
            this.stts.add(new TimeToSampleBox.Entry(1L, 1024L));
            object = adtsHeader2;
        }
        return object;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.stts;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public Box getMediaHeaderBox() {
        return new SoundMediaHeaderBox();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    public String toString() {
        return "AACTrackImpl{sampleRate=" + this.firstHeader.sampleRate + ", channelconfig=" + this.firstHeader.channelconfig + '}';
    }

    class AdtsHeader {
        int bufferFullness;
        int channelconfig;
        int copyrightStart;
        int copyrightedStream;
        int frameLength;
        int home;
        int layer;
        int mpegVersion;
        int numAacFramesPerAdtsFrame;
        int original;
        int profile;
        int protectionAbsent;
        int sampleFrequencyIndex;
        int sampleRate;

        AdtsHeader() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getSize() {
            if (this.protectionAbsent != 0) return 7;
            return 9;
        }
    }
}

