/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.util.Math;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class SyncSampleIntersectFinderImpl
implements FragmentIntersectionFinder {
    private static Logger LOG = Logger.getLogger(SyncSampleIntersectFinderImpl.class.getName());
    private static Map<CacheTuple, long[]> getSampleNumbersCache;
    private static Map<CacheTuple, long[]> getTimesCache;
    private final int minFragmentDurationSeconds;

    static {
        getTimesCache = new ConcurrentHashMap<CacheTuple, long[]>();
        getSampleNumbersCache = new ConcurrentHashMap<CacheTuple, long[]>();
    }

    public SyncSampleIntersectFinderImpl() {
        this.minFragmentDurationSeconds = 0;
    }

    public SyncSampleIntersectFinderImpl(int n2) {
        this.minFragmentDurationSeconds = n2;
    }

    private static long calculateTracktimesScalingFactor(Movie object, Track track) {
        object = ((Movie)object).getTracks().iterator();
        long l2 = 1L;
        while (object.hasNext()) {
            Track track2 = (Track)object.next();
            if (!track2.getHandler().equals(track.getHandler()) || track2.getTrackMetaData().getTimescale() == track.getTrackMetaData().getTimescale()) continue;
            l2 = Math.lcm(l2, track2.getTrackMetaData().getTimescale());
        }
        return l2;
    }

    public static List<long[]> getSyncSamplesTimestamps(Movie movie, Track track) {
        LinkedList<long[]> linkedList = new LinkedList<long[]>();
        Iterator<Track> iterator = movie.getTracks().iterator();
        while (iterator.hasNext()) {
            long[] lArray;
            Track track2 = iterator.next();
            if (!track2.getHandler().equals(track.getHandler()) || (lArray = track2.getSyncSamples()) == null || lArray.length <= 0) continue;
            linkedList.add(SyncSampleIntersectFinderImpl.getTimes(track2, movie));
        }
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long[] getTimes(Track object, Movie movie) {
        CacheTuple cacheTuple = new CacheTuple((Track)object, movie);
        long[] lArray = getTimesCache.get(cacheTuple);
        if (lArray != null) {
            return lArray;
        }
        long[] lArray2 = object.getSyncSamples();
        lArray = new long[lArray2.length];
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>(object.getDecodingTimeEntries());
        int n2 = 1;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        long l4 = 0L;
        long l5 = SyncSampleIntersectFinderImpl.calculateTracktimesScalingFactor(movie, (Track)object);
        while (true) {
            if ((long)n2 > lArray2[lArray2.length - 1]) {
                getTimesCache.put(cacheTuple, lArray);
                return lArray;
            }
            int n4 = n3;
            if ((long)n2 == lArray2[n3]) {
                lArray[n3] = l2 * l5;
                n4 = n3 + 1;
            }
            if (l4 == 0L) {
                object = (TimeToSampleBox.Entry)linkedList.poll();
                l4 = ((TimeToSampleBox.Entry)object).getCount();
                l3 = ((TimeToSampleBox.Entry)object).getDelta();
                --l4;
            } else {
                --l4;
            }
            l2 += l3;
            ++n2;
            n3 = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public long[] getCommonIndices(long[] object, long[] object2, long object3, long[] ... object4) {
        int n2;
        block17: {
            LinkedList<Long> linkedList = new LinkedList<Long>();
            LinkedList<Long> linkedList2 = new LinkedList<Long>();
            n2 = 0;
            block0: while (true) {
                int n3;
                if (n2 >= ((Object)object2).length) {
                    if ((double)linkedList.size() < (double)((Object)object).length * 0.25) {
                    } else {
                        if ((double)linkedList.size() < (double)((Object)object).length * 0.5) {
                            LOG.fine("There are less than 50% of common sync samples in the given track. This is implausible but I'm ok to continue.");
                        } else if (linkedList.size() < ((Object)object).length) {
                            LOG.finest("Common SyncSample positions vs. this tracks SyncSample positions: " + linkedList.size() + " vs. " + ((Object)object).length);
                        }
                        object = new LinkedList();
                        if (this.minFragmentDurationSeconds > 0) break;
                        object = linkedList;
                        break block17;
                    }
                    object2 = String.valueOf("") + String.format("%5d - Common:  [", linkedList.size());
                    object4 = linkedList.iterator();
                    while (true) {
                        if (!object4.hasNext()) break;
                        object3 = (Long)object4.next();
                        object2 = String.valueOf(object2) + String.format("%10d,", object3);
                    }
                    object2 = String.valueOf(object2) + "]";
                    LOG.warning((String)object2);
                    object2 = String.valueOf("") + String.format("%5d - In    :  [", ((Object)object).length);
                    n3 = ((Object)object).length;
                    n2 = 0;
                    while (true) {
                        if (n2 >= n3) {
                            object = String.valueOf(object2) + "]";
                            LOG.warning((String)object);
                            LOG.warning("There are less than 25% of common sync samples in the given track.");
                            throw new RuntimeException("There are less than 25% of common sync samples in the given track.");
                        }
                        object3 = object[n2];
                        object2 = String.valueOf(object2) + String.format("%10d,", object3);
                        ++n2;
                    }
                }
                int n4 = ((Object)object4).length;
                n3 = 1;
                int n5 = 0;
                while (true) {
                    if (n5 >= n4) {
                        if (n3 != 0) {
                            linkedList.add((long)object[n2]);
                            linkedList2.add((long)object2[n2]);
                        }
                        ++n2;
                        continue block0;
                    }
                    int n6 = Arrays.binarySearch((long[])object4[n5], (long)object2[n2]) >= 0 ? 1 : 0;
                    n3 &= n6;
                    ++n5;
                }
                break;
            }
            object2 = linkedList.iterator();
            object4 = linkedList2.iterator();
            long l2 = -1L;
            while (object2.hasNext() && object4.hasNext()) {
                long l3 = (Long)object2.next();
                long l4 = (Long)object4.next();
                if (l2 != -1L && (l4 - l2) / object3 < (long)this.minFragmentDurationSeconds) continue;
                object.add(l3);
                l2 = l4;
            }
        }
        object2 = new long[object.size()];
        n2 = 0;
        while (n2 < ((Object)object2).length) {
            object2[n2] = (Long)object.get(n2);
            ++n2;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public long[] sampleNumbers(Track object, Movie object2) {
        Track track;
        CacheTuple cacheTuple = new CacheTuple((Track)object, (Movie)object2);
        long[] lArray = getSampleNumbersCache.get(cacheTuple);
        if (lArray != null) {
            return lArray;
        }
        if ("vide".equals(object.getHandler())) {
            if (object.getSyncSamples() == null) throw new RuntimeException("Video Tracks need sync samples. Only tracks other than video may have no sync samples.");
            if (object.getSyncSamples().length <= 0) throw new RuntimeException("Video Tracks need sync samples. Only tracks other than video may have no sync samples.");
            List<long[]> list = SyncSampleIntersectFinderImpl.getSyncSamplesTimestamps((Movie)object2, (Track)object);
            object = this.getCommonIndices(object.getSyncSamples(), SyncSampleIntersectFinderImpl.getTimes((Track)object, (Movie)object2), object.getTrackMetaData().getTimescale(), (long[][])list.toArray((T[])new long[list.size()][]));
            getSampleNumbersCache.put(cacheTuple, (long[])object);
            return object;
        }
        if ("soun".equals(object.getHandler())) {
            double d2;
            long l2;
            long l3;
            long[] lArray2;
            int n2;
            Object object3;
            AudioSampleEntry audioSampleEntry = ((Movie)object2).getTracks().iterator();
            Object var4_6 = null;
            while (true) {
                if (!audioSampleEntry.hasNext()) {
                    void var4_7;
                    if (var4_7 == null) throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
                    object3 = this.sampleNumbers((Track)var4_7, (Movie)object2);
                    n2 = var4_7.getSamples().size();
                    lArray2 = new long[((Object)object3).length];
                    l3 = 192000L;
                    object2 = ((Movie)object2).getTracks().iterator();
                    break;
                }
                object3 = audioSampleEntry.next();
                if (object3.getSyncSamples() == null || !"vide".equals(object3.getHandler()) || object3.getSyncSamples().length <= 0) continue;
                Object object4 = object3;
            }
            block1: while (object2.hasNext()) {
                Track track2 = (Track)object2.next();
                if (!"soun".equals(track2.getHandler()) || (audioSampleEntry = (AudioSampleEntry)track2.getSampleDescriptionBox().getSampleEntry()).getSampleRate() >= 192000L) continue;
                l2 = audioSampleEntry.getSampleRate();
                d2 = (double)track2.getSamples().size() / (double)n2;
                long l4 = track2.getDecodingTimeEntries().get(0).getDelta();
                n2 = 0;
                while (true) {
                    l3 = l2;
                    if (n2 >= lArray2.length) break block1;
                    lArray2[n2] = (long)java.lang.Math.ceil((double)(object3[n2] - 1L) * d2 * (double)l4);
                    ++n2;
                }
            }
            object2 = (AudioSampleEntry)object.getSampleDescriptionBox().getSampleEntry();
            l2 = object.getDecodingTimeEntries().get(0).getDelta();
            d2 = (double)((AudioSampleEntry)object2).getSampleRate() / (double)l3;
            if (d2 != java.lang.Math.rint(d2)) {
                throw new RuntimeException("Sample rates must be a multiple of the lowest sample rate to create a correct file!");
            }
            n2 = 0;
            while (true) {
                if (n2 >= lArray2.length) {
                    getSampleNumbersCache.put(cacheTuple, lArray2);
                    return lArray2;
                }
                lArray2[n2] = (long)(1.0 + (double)lArray2[n2] * d2 / (double)l2);
                ++n2;
            }
        }
        Object object5 = ((Movie)object2).getTracks().iterator();
        do {
            if (object5.hasNext()) continue;
            throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
        } while ((track = object5.next()).getSyncSamples() == null || track.getSyncSamples().length <= 0);
        object5 = this.sampleNumbers(track, (Movie)object2);
        int n3 = track.getSamples().size();
        object2 = new long[((Object)object5).length];
        double d3 = (double)object.getSamples().size() / (double)n3;
        n3 = 0;
        while (true) {
            if (n3 >= ((Object)object2).length) {
                getSampleNumbersCache.put(cacheTuple, (long[])object2);
                return object2;
            }
            object2[n3] = (long)java.lang.Math.ceil((double)(object5[n3] - 1L) * d3) + 1L;
            ++n3;
        }
    }

    public static class CacheTuple {
        Movie movie;
        Track track;

        public CacheTuple(Track track, Movie movie) {
            this.track = track;
            this.movie = movie;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) return false;
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (CacheTuple)object;
            if (this.movie != null) {
                if (!this.movie.equals(((CacheTuple)object).movie)) {
                    return false;
                }
            } else if (((CacheTuple)object).movie != null) return false;
            if (this.track != null) {
                if (this.track.equals(((CacheTuple)object).track)) return bl;
                return false;
            }
            if (((CacheTuple)object).track == null) return bl;
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n2 = 0;
            int n3 = this.track != null ? this.track.hashCode() : 0;
            if (this.movie != null) {
                n2 = this.movie.hashCode();
            }
            return n3 * 31 + n2;
        }
    }
}

