/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessOffsetBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FragmentedMp4Builder
implements Mp4Builder {
    private static final Logger LOG = Logger.getLogger(FragmentedMp4Builder.class.getName());
    protected FragmentIntersectionFinder intersectionFinder = new SyncSampleIntersectFinderImpl();

    private long getTrackDuration(Movie movie, Track track) {
        return this.getDuration(track) * movie.getTimescale() / track.getTrackMetaData().getTimescale();
    }

    @Override
    public Container build(Movie movie) {
        LOG.fine("Creating movie " + movie);
        BasicContainer basicContainer = new BasicContainer();
        basicContainer.addBox(this.createFtyp(movie));
        basicContainer.addBox(this.createMoov(movie));
        Iterator<Box> iterator = this.createMoofMdat(movie).iterator();
        while (true) {
            if (!iterator.hasNext()) {
                basicContainer.addBox(this.createMfra(movie, basicContainer));
                return basicContainer;
            }
            basicContainer.addBox(iterator.next());
        }
    }

    protected DataInformationBox createDinf(Movie object, Track object2) {
        object = new DataInformationBox();
        object2 = new DataReferenceBox();
        ((BasicContainer)object).addBox((Box)object2);
        DataEntryUrlBox dataEntryUrlBox = new DataEntryUrlBox();
        dataEntryUrlBox.setFlags(1);
        ((BasicContainer)object2).addBox((Box)((Object)dataEntryUrlBox));
        return object;
    }

    public Box createFtyp(Movie object) {
        object = new LinkedList();
        object.add("isom");
        object.add("iso2");
        object.add("avc1");
        return new FileTypeBox("isom", 0L, (List)object);
    }

    protected Box createMdat(final long l2, final long l3, final Track track, final int n2) {
        return new Box(){
            Container parent;

            @Override
            public void getBox(WritableByteChannel writableByteChannel) throws IOException {
                Object object = ByteBuffer.allocate(8);
                IsoTypeWriter.writeUInt32((ByteBuffer)object, CastUtils.l2i(this.getSize()));
                ((ByteBuffer)object).put(IsoFile.fourCCtoBytes((String)this.getType()));
                ((ByteBuffer)object).rewind();
                writableByteChannel.write((ByteBuffer)object);
                object = FragmentedMp4Builder.this.getSamples(l2, l3, track, n2).iterator();
                while (object.hasNext()) {
                    ((Sample)object.next()).writeTo(writableByteChannel);
                }
                return;
            }

            @Override
            public long getOffset() {
                throw new RuntimeException("Doesn't have any meaning for programmatically created boxes");
            }

            @Override
            public Container getParent() {
                return this.parent;
            }

            @Override
            public long getSize() {
                Iterator<Sample> iterator = FragmentedMp4Builder.this.getSamples(l2, l3, track, n2).iterator();
                long l22 = 8L;
                while (iterator.hasNext()) {
                    l22 = iterator.next().remaining() + l22;
                }
                return l22;
            }

            @Override
            public String getType() {
                return "mdat";
            }

            @Override
            public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l22, BoxParser boxParser) throws IOException {
            }

            @Override
            public void setParent(Container container) {
                this.parent = container;
            }
        };
    }

    protected Box createMdhd(Movie object, Track track) {
        object = new MediaHeaderBox();
        ((MediaHeaderBox)((Object)object)).setCreationTime(track.getTrackMetaData().getCreationTime());
        ((MediaHeaderBox)((Object)object)).setDuration(this.getDuration(track));
        ((MediaHeaderBox)((Object)object)).setTimescale(track.getTrackMetaData().getTimescale());
        ((MediaHeaderBox)((Object)object)).setLanguage(track.getTrackMetaData().getLanguage());
        return object;
    }

    protected Box createMdia(Track track, Movie movie) {
        MediaBox mediaBox = new MediaBox();
        mediaBox.addBox(this.createMdhd(movie, track));
        mediaBox.addBox(this.createMdiaHdlr(track, movie));
        mediaBox.addBox(this.createMinf(track, movie));
        return mediaBox;
    }

    protected Box createMdiaHdlr(Track track, Movie object) {
        object = new HandlerBox();
        ((HandlerBox)((Object)object)).setHandlerType(track.getHandler());
        return object;
    }

    protected Box createMfhd(long l2, long l3, Track object, int n2) {
        object = new MovieFragmentHeaderBox();
        ((MovieFragmentHeaderBox)((Object)object)).setSequenceNumber(n2);
        return object;
    }

    protected Box createMfra(Movie object, Container container) {
        MovieFragmentRandomAccessBox movieFragmentRandomAccessBox = new MovieFragmentRandomAccessBox();
        object = ((Movie)object).getTracks().iterator();
        while (true) {
            if (!object.hasNext()) {
                object = new MovieFragmentRandomAccessOffsetBox();
                movieFragmentRandomAccessBox.addBox((Box)object);
                ((MovieFragmentRandomAccessOffsetBox)((Object)object)).setMfraSize(movieFragmentRandomAccessBox.getSize());
                return movieFragmentRandomAccessBox;
            }
            movieFragmentRandomAccessBox.addBox(this.createTfra((Track)object.next(), container));
        }
    }

    protected Box createMinf(Track track, Movie movie) {
        MediaInformationBox mediaInformationBox = new MediaInformationBox();
        mediaInformationBox.addBox(track.getMediaHeaderBox());
        mediaInformationBox.addBox(this.createDinf(movie, track));
        mediaInformationBox.addBox(this.createStbl(movie, track));
        return mediaInformationBox;
    }

    protected Box createMoof(long l2, long l3, Track object, int n2) {
        MovieFragmentBox movieFragmentBox = new MovieFragmentBox();
        movieFragmentBox.addBox(this.createMfhd(l2, l3, (Track)object, n2));
        movieFragmentBox.addBox(this.createTraf(l2, l3, (Track)object, n2));
        object = movieFragmentBox.getTrackRunBoxes().get(0);
        ((TrackRunBox)((Object)object)).setDataOffset(1);
        ((TrackRunBox)((Object)object)).setDataOffset((int)(8L + movieFragmentBox.getSize()));
        return movieFragmentBox;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<Box> createMoofMdat(Movie movie) {
        long[] lArray;
        Object object;
        LinkedList<Box> linkedList = new LinkedList<Box>();
        HashMap<Track, long[]> hashMap = new HashMap<Track, long[]>();
        Object object2 = movie.getTracks().iterator();
        int n2 = 0;
        while (true) {
            if (!object2.hasNext()) break;
            object = object2.next();
            lArray = this.intersectionFinder.sampleNumbers((Track)object, movie);
            hashMap.put((Track)object, lArray);
            n2 = Math.max(n2, lArray.length);
        }
        int n3 = 1;
        int n4 = 0;
        block1: while (n4 < n2) {
            object = this.sortTracksInSequence(movie.getTracks(), n4, hashMap).iterator();
            while (true) {
                long l2;
                long l3;
                if (!object.hasNext()) {
                    ++n4;
                    continue block1;
                }
                object2 = (Track)object.next();
                if (!this.getAllowedHandlers().isEmpty() && !this.getAllowedHandlers().contains(object2.getHandler()) || n4 >= (lArray = hashMap.get(object2)).length || (l3 = lArray[n4]) == (l2 = n4 + 1 < lArray.length ? lArray[n4 + 1] : (long)(object2.getSamples().size() + 1))) continue;
                linkedList.add(this.createMoof(l3, l2, (Track)object2, n3));
                linkedList.add(this.createMdat(l3, l2, (Track)object2, n3));
                ++n3;
            }
            break;
        }
        return linkedList;
    }

    protected Box createMoov(Movie movie) {
        MovieBox movieBox = new MovieBox();
        movieBox.addBox(this.createMvhd(movie));
        movieBox.addBox(this.createMvex(movie));
        Iterator<Track> iterator = movie.getTracks().iterator();
        while (iterator.hasNext()) {
            movieBox.addBox(this.createTrak(iterator.next(), movie));
        }
        return movieBox;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Box createMvex(Movie movie) {
        MovieExtendsBox movieExtendsBox = new MovieExtendsBox();
        MovieExtendsHeaderBox movieExtendsHeaderBox = new MovieExtendsHeaderBox();
        Iterator<Track> iterator = movie.getTracks().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            long l2 = this.getTrackDuration(movie, iterator.next());
            if (movieExtendsHeaderBox.getFragmentDuration() >= l2) continue;
            movieExtendsHeaderBox.setFragmentDuration(l2);
        }
        movieExtendsBox.addBox((Box)((Object)movieExtendsHeaderBox));
        iterator = movie.getTracks().iterator();
        while (iterator.hasNext()) {
            movieExtendsBox.addBox(this.createTrex(movie, iterator.next()));
        }
        return movieExtendsBox;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Box createMvhd(Movie object) {
        Object object2;
        long l2 = 0L;
        MovieHeaderBox movieHeaderBox = new MovieHeaderBox();
        movieHeaderBox.setVersion(1);
        movieHeaderBox.setCreationTime(new Date());
        movieHeaderBox.setModificationTime(new Date());
        long l3 = ((Movie)object).getTimescale();
        Iterator<Track> iterator = ((Movie)object).getTracks().iterator();
        long l4 = 0L;
        while (true) {
            if (!iterator.hasNext()) break;
            object2 = iterator.next();
            long l5 = this.getDuration((Track)object2) * l3 / object2.getTrackMetaData().getTimescale();
            if (l5 <= l4) continue;
            l4 = l5;
        }
        movieHeaderBox.setDuration(l4);
        movieHeaderBox.setTimescale(l3);
        object2 = ((Movie)object).getTracks().iterator();
        l4 = l2;
        while (true) {
            if (!object2.hasNext()) {
                movieHeaderBox.setNextTrackId(1L + l4);
                return movieHeaderBox;
            }
            object = (Track)object2.next();
            if (l4 >= object.getTrackMetaData().getTrackId()) continue;
            l4 = object.getTrackMetaData().getTrackId();
        }
    }

    protected Box createStbl(Movie object, Track track) {
        object = new SampleTableBox();
        ((BasicContainer)object).addBox(track.getSampleDescriptionBox());
        ((BasicContainer)object).addBox((Box)((Object)new TimeToSampleBox()));
        ((BasicContainer)object).addBox((Box)((Object)new StaticChunkOffsetBox()));
        return object;
    }

    protected Box createTfhd(long l2, long l3, Track track, int n2) {
        TrackFragmentHeaderBox trackFragmentHeaderBox = new TrackFragmentHeaderBox();
        trackFragmentHeaderBox.setDefaultSampleFlags(new SampleFlags());
        trackFragmentHeaderBox.setBaseDataOffset(-1L);
        trackFragmentHeaderBox.setTrackId(track.getTrackMetaData().getTrackId());
        return trackFragmentHeaderBox;
    }

    /*
     * Exception decompiling
     */
    protected Box createTfra(Track var1_1, Container var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Box createTkhd(Movie movie, Track track) {
        int n2 = 1;
        TrackHeaderBox trackHeaderBox = new TrackHeaderBox();
        trackHeaderBox.setVersion(1);
        if (!track.isEnabled()) {
            n2 = 0;
        }
        int n3 = n2;
        if (track.isInMovie()) {
            n3 = n2 + 2;
        }
        n2 = n3;
        if (track.isInPreview()) {
            n2 = n3 + 4;
        }
        n3 = n2;
        if (track.isInPoster()) {
            n3 = n2 + 8;
        }
        trackHeaderBox.setFlags(n3);
        trackHeaderBox.setAlternateGroup(track.getTrackMetaData().getGroup());
        trackHeaderBox.setCreationTime(track.getTrackMetaData().getCreationTime());
        trackHeaderBox.setDuration(this.getTrackDuration(movie, track));
        trackHeaderBox.setHeight(track.getTrackMetaData().getHeight());
        trackHeaderBox.setWidth(track.getTrackMetaData().getWidth());
        trackHeaderBox.setLayer(track.getTrackMetaData().getLayer());
        trackHeaderBox.setModificationTime(new Date());
        trackHeaderBox.setTrackId(track.getTrackMetaData().getTrackId());
        trackHeaderBox.setVolume(track.getTrackMetaData().getVolume());
        return trackHeaderBox;
    }

    protected Box createTraf(long l2, long l3, Track object, int n2) {
        TrackFragmentBox trackFragmentBox = new TrackFragmentBox();
        trackFragmentBox.addBox(this.createTfhd(l2, l3, (Track)object, n2));
        object = this.createTruns(l2, l3, (Track)object, n2).iterator();
        while (object.hasNext()) {
            trackFragmentBox.addBox((Box)object.next());
        }
        return trackFragmentBox;
    }

    protected Box createTrak(Track track, Movie movie) {
        LOG.fine("Creating Track " + track);
        TrackBox trackBox = new TrackBox();
        trackBox.addBox(this.createTkhd(movie, track));
        trackBox.addBox(this.createMdia(track, movie));
        return trackBox;
    }

    protected Box createTrex(Movie object, Track track) {
        TrackExtendsBox trackExtendsBox = new TrackExtendsBox();
        trackExtendsBox.setTrackId(track.getTrackMetaData().getTrackId());
        trackExtendsBox.setDefaultSampleDescriptionIndex(1L);
        trackExtendsBox.setDefaultSampleDuration(0L);
        trackExtendsBox.setDefaultSampleSize(0L);
        object = new SampleFlags();
        if ("soun".equals(track.getHandler()) || "subt".equals(track.getHandler())) {
            ((SampleFlags)object).setSampleDependsOn(2);
            ((SampleFlags)object).setSampleIsDependedOn(2);
        }
        trackExtendsBox.setDefaultSampleFlags((SampleFlags)object);
        return trackExtendsBox;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<? extends Box> createTruns(long l2, long l3, Track track, int n2) {
        long l4;
        TrackRunBox trackRunBox = new TrackRunBox();
        long[] lArray = this.getSampleSizes(l2, l3, track, n2);
        trackRunBox.setSampleDurationPresent(true);
        trackRunBox.setSampleSizePresent(true);
        ArrayList<TrackRunBox.Entry> arrayList = new ArrayList<TrackRunBox.Entry>(CastUtils.l2i(l3 - l2));
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        long l5 = l2 - 1L;
        long l6 = ((TimeToSampleBox.Entry)linkedList.peek()).getCount();
        while (true) {
            if (l5 <= l6) break;
            l5 -= l6;
            linkedList.remove();
            l6 = ((TimeToSampleBox.Entry)linkedList.peek()).getCount();
        }
        LinkedList<CompositionTimeToSample.Entry> linkedList2 = track.getCompositionTimeEntries() != null && track.getCompositionTimeEntries().size() > 0 ? new LinkedList<CompositionTimeToSample.Entry>(track.getCompositionTimeEntries()) : null;
        n2 = linkedList2 != null ? ((CompositionTimeToSample.Entry)linkedList2.peek()).getCount() : -1;
        l3 = n2;
        boolean bl = l3 > 0L;
        trackRunBox.setSampleCompositionTimeOffsetPresent(bl);
        long l7 = 1L;
        while (true) {
            if (l7 >= l2) break;
            l4 = l3--;
            if (linkedList2 != null) {
                l4 = l3;
                if (l3 == 0L) {
                    l4 = l3;
                    if (linkedList2.size() > 1) {
                        linkedList2.remove();
                        l4 = ((CompositionTimeToSample.Entry)linkedList2.element()).getCount();
                    }
                }
            }
            ++l7;
            l3 = l4;
        }
        bl = track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty() || track.getSyncSamples() != null && track.getSyncSamples().length != 0;
        trackRunBox.setSampleFlagsPresent(bl);
        l4 = l6 - l5;
        l6 = l3;
        n2 = 0;
        l3 = l4;
        while (true) {
            if (n2 >= lArray.length) {
                trackRunBox.setEntries(arrayList);
                return Collections.singletonList(trackRunBox);
            }
            TrackRunBox.Entry entry = new TrackRunBox.Entry();
            entry.setSampleSize(lArray[n2]);
            if (bl) {
                SampleFlags sampleFlags = new SampleFlags();
                if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
                    SampleDependencyTypeBox.Entry entry2 = track.getSampleDependencies().get(n2);
                    sampleFlags.setSampleDependsOn(entry2.getSampleDependsOn());
                    sampleFlags.setSampleIsDependedOn(entry2.getSampleIsDependentOn());
                    sampleFlags.setSampleHasRedundancy(entry2.getSampleHasRedundancy());
                }
                if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                    if (Arrays.binarySearch(track.getSyncSamples(), (long)n2 + l2) >= 0) {
                        sampleFlags.setSampleIsDifferenceSample(false);
                        sampleFlags.setSampleDependsOn(2);
                    } else {
                        sampleFlags.setSampleIsDifferenceSample(true);
                        sampleFlags.setSampleDependsOn(1);
                    }
                }
                entry.setSampleFlags(sampleFlags);
            }
            entry.setSampleDuration(((TimeToSampleBox.Entry)linkedList.peek()).getDelta());
            l3 = l4 = l3 - 1L;
            if (l4 == 0L) {
                l3 = l4;
                if (linkedList.size() > 1) {
                    linkedList.remove();
                    l3 = ((TimeToSampleBox.Entry)linkedList.peek()).getCount();
                }
            }
            l4 = l6--;
            if (linkedList2 != null) {
                entry.setSampleCompositionTimeOffset(((CompositionTimeToSample.Entry)linkedList2.peek()).getOffset());
                l4 = l6;
                if (l6 == 0L) {
                    l4 = l6;
                    if (linkedList2.size() > 1) {
                        linkedList2.remove();
                        l4 = ((CompositionTimeToSample.Entry)linkedList2.element()).getCount();
                    }
                }
            }
            arrayList.add(entry);
            ++n2;
            l6 = l4;
        }
    }

    public List<String> getAllowedHandlers() {
        return Arrays.asList("soun", "vide");
    }

    protected long getDuration(Track object) {
        Iterator<TimeToSampleBox.Entry> iterator = object.getDecodingTimeEntries().iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            object = iterator.next();
            long l3 = ((TimeToSampleBox.Entry)object).getCount();
            l2 = ((TimeToSampleBox.Entry)object).getDelta() * l3 + l2;
        }
        return l2;
    }

    public FragmentIntersectionFinder getFragmentIntersectionFinder() {
        return this.intersectionFinder;
    }

    protected long[] getSampleSizes(long l2, long l3, Track object, int n2) {
        List<Sample> list = this.getSamples(l2, l3, (Track)object, n2);
        object = new long[list.size()];
        n2 = 0;
        while (n2 < ((Object)object).length) {
            object[n2] = list.get(n2).remaining();
            ++n2;
        }
        return object;
    }

    protected List<Sample> getSamples(long l2, long l3, Track track, int n2) {
        return track.getSamples().subList(CastUtils.l2i(l2) - 1, CastUtils.l2i(l3) - 1);
    }

    public void setIntersectionFinder(FragmentIntersectionFinder fragmentIntersectionFinder) {
        this.intersectionFinder = fragmentIntersectionFinder;
    }

    protected List<Track> sortTracksInSequence(List<Track> list, final int n2, final Map<Track, long[]> map) {
        list = new LinkedList<Track>(list);
        Collections.sort(list, new Comparator<Track>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public int compare(Track track, Track track2) {
                long l2 = ((long[])map.get(track))[n2];
                long l3 = ((long[])map.get(track2))[n2];
                long[] lArray = TimeToSampleBox.blowupTimeToSamples(track.getDecodingTimeEntries());
                long[] lArray2 = TimeToSampleBox.blowupTimeToSamples(track2.getDecodingTimeEntries());
                long l4 = 0L;
                long l5 = 0L;
                int n22 = 1;
                while (true) {
                    if ((long)n22 >= l2) break;
                    l4 += lArray[n22 - 1];
                    ++n22;
                }
                n22 = 1;
                while ((long)n22 < l3) {
                    l5 += lArray2[n22 - 1];
                    ++n22;
                }
                return (int)(((double)l4 / (double)track.getTrackMetaData().getTimescale() - (double)l5 / (double)track2.getTrackMetaData().getTimescale()) * 100.0);
            }
        });
        return list;
    }
}

