/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.util.Matrix;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Movie {
    Matrix matrix = Matrix.ROTATE_0;
    List<Track> tracks = new LinkedList<Track>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long gcd(long l2, long l3) {
        if (l3 != 0L) return Movie.gcd(l3, l2 % l3);
        return l2;
    }

    public void addTrack(Track track) {
        if (this.getTrackByTrackId(track.getTrackMetaData().getTrackId()) != null) {
            track.getTrackMetaData().setTrackId(this.getNextTrackId());
        }
        this.tracks.add(track);
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public long getNextTrackId() {
        Iterator<Track> iterator = this.tracks.iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            Track track = iterator.next();
            if (l2 >= track.getTrackMetaData().getTrackId()) continue;
            l2 = track.getTrackMetaData().getTrackId();
        }
        return 1L + l2;
    }

    public long getTimescale() {
        long l2 = this.getTracks().iterator().next().getTrackMetaData().getTimescale();
        Iterator<Track> iterator = this.getTracks().iterator();
        while (iterator.hasNext()) {
            l2 = Movie.gcd(iterator.next().getTrackMetaData().getTimescale(), l2);
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Track getTrackByTrackId(long l2) {
        Track track;
        Iterator<Track> iterator = this.tracks.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((track = iterator.next()).getTrackMetaData().getTrackId() != l2);
        return track;
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public void setTracks(List<Track> list) {
        this.tracks = list;
    }

    public String toString() {
        Iterator<Track> iterator = this.tracks.iterator();
        String string2 = "Movie{ ";
        while (iterator.hasNext()) {
            Track track = iterator.next();
            string2 = String.valueOf(string2) + "track_" + track.getTrackMetaData().getTrackId() + " (" + track.getHandler() + ") ";
        }
        return String.valueOf(string2) + '}';
    }
}

