/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class AbstractContainerBox
extends BasicContainer
implements Box {
    ByteBuffer header;
    protected boolean largeBox;
    private long offset;
    Container parent;
    protected String type;

    public AbstractContainerBox(String string2) {
        this.type = string2;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        this.writeContainer(writableByteChannel);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ByteBuffer getHeader() {
        Object object;
        if (this.largeBox || this.getSize() >= 0x100000000L) {
            object = new byte[16];
            object[3] = (byte)1;
            object[4] = this.type.getBytes()[0];
            object[5] = this.type.getBytes()[1];
            object[6] = this.type.getBytes()[2];
            object[7] = this.type.getBytes()[3];
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).position(8);
            IsoTypeWriter.writeUInt64((ByteBuffer)object, this.getSize());
        } else {
            object = new byte[8];
            object[4] = this.type.getBytes()[0];
            object[5] = this.type.getBytes()[1];
            object[6] = this.type.getBytes()[2];
            object[7] = this.type.getBytes()[3];
            object = ByteBuffer.wrap((byte[])object);
            IsoTypeWriter.writeUInt32((ByteBuffer)object, this.getSize());
        }
        ((ByteBuffer)object).rewind();
        return object;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() {
        int n2;
        long l2 = this.getContainerSize();
        if (this.largeBox || 8L + l2 >= 0x100000000L) {
            n2 = 16;
            return (long)n2 + l2;
        }
        n2 = 8;
        return (long)n2 + l2;
    }

    @Override
    public String getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        this.offset = dataSource.position() - (long)byteBuffer.remaining();
        boolean bl = byteBuffer.remaining() == 16;
        this.largeBox = bl;
        this.parseContainer(dataSource, l2, boxParser);
    }

    @Override
    public void setParent(Container container) {
        this.parent = container;
    }
}

