/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class MapTypeAdapterFactory
implements TypeAdapterFactory {
    private final boolean complexMapKeySerialization;
    private final ConstructorConstructor constructorConstructor;

    public MapTypeAdapterFactory(ConstructorConstructor constructorConstructor, boolean bl) {
        this.constructorConstructor = constructorConstructor;
        this.complexMapKeySerialization = bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeAdapter<?> getKeyAdapter(Gson object, Type type) {
        void var1_3;
        void var2_5;
        if (var2_5 == Boolean.TYPE || var2_5 == Boolean.class) {
            TypeAdapter<Boolean> typeAdapter = TypeAdapters.BOOLEAN_AS_STRING;
            return var1_3;
        }
        TypeAdapter typeAdapter = object.getAdapter(TypeToken.get((Type)var2_5));
        return var1_3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> TypeAdapter<T> create(Gson object, TypeToken<T> object2) {
        void var1_3;
        void var2_5;
        Object object3 = var2_5.getType();
        if (!Map.class.isAssignableFrom(var2_5.getRawType())) {
            return var1_3;
        }
        Type[] typeArray = $Gson$Types.getMapKeyAndValueTypes((Type)object3, $Gson$Types.getRawType((Type)object3));
        TypeAdapter<?> typeAdapter = this.getKeyAdapter((Gson)object, typeArray[0]);
        object3 = object.getAdapter(TypeToken.get((Type)typeArray[1]));
        ObjectConstructor objectConstructor = this.constructorConstructor.get(var2_5);
        Adapter adapter = new Adapter((Gson)object, typeArray[0], typeAdapter, typeArray[1], object3, objectConstructor);
        return var1_3;
    }

    private final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final ObjectConstructor<? extends Map<K, V>> constructor;
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;

        public Adapter(Gson gson, Type type, TypeAdapter<K> typeAdapter, Type type2, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(gson, typeAdapter, type);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(gson, typeAdapter2, type2);
            this.constructor = objectConstructor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String keyToString(JsonElement object) {
            if (((JsonElement)object).isJsonPrimitive()) {
                if (((JsonPrimitive)(object = ((JsonElement)object).getAsJsonPrimitive())).isNumber()) {
                    return String.valueOf(((JsonPrimitive)object).getAsNumber());
                }
                if (((JsonPrimitive)object).isBoolean()) {
                    return Boolean.toString(((JsonPrimitive)object).getAsBoolean());
                }
                if (!((JsonPrimitive)object).isString()) throw new AssertionError();
                return ((JsonPrimitive)object).getAsString();
            }
            if (!((JsonElement)object).isJsonNull()) throw new AssertionError();
            return "null";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Map<K, V> read(JsonReader map) throws IOException {
            JsonToken jsonToken = ((JsonReader)((Object)map)).peek();
            if (jsonToken == JsonToken.NULL) {
                ((JsonReader)((Object)map)).nextNull();
                return null;
            }
            Map<K, V> map2 = this.constructor.construct();
            if (jsonToken == JsonToken.BEGIN_ARRAY) {
                ((JsonReader)((Object)map)).beginArray();
                while (((JsonReader)((Object)map)).hasNext()) {
                    ((JsonReader)((Object)map)).beginArray();
                    K k2 = this.keyTypeAdapter.read((JsonReader)((Object)map));
                    if (map2.put(k2, this.valueTypeAdapter.read((JsonReader)((Object)map))) != null) {
                        throw new JsonSyntaxException("duplicate key: " + k2);
                    }
                    ((JsonReader)((Object)map)).endArray();
                }
                ((JsonReader)((Object)map)).endArray();
                return map2;
            }
            ((JsonReader)((Object)map)).beginObject();
            while (((JsonReader)((Object)map)).hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue((JsonReader)((Object)map));
                K k3 = this.keyTypeAdapter.read((JsonReader)((Object)map));
                if (map2.put(k3, this.valueTypeAdapter.read((JsonReader)((Object)map))) == null) continue;
                throw new JsonSyntaxException("duplicate key: " + k3);
            }
            ((JsonReader)((Object)map)).endObject();
            return map2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void write(JsonWriter jsonWriter, Map<K, V> object) throws IOException {
            int n2 = 0;
            int n3 = 0;
            if (object == null) {
                jsonWriter.nullValue();
                return;
            }
            if (!MapTypeAdapterFactory.this.complexMapKeySerialization) {
                jsonWriter.beginObject();
                object = object.entrySet().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        jsonWriter.endObject();
                        return;
                    }
                    Map.Entry entry = object.next();
                    jsonWriter.name(String.valueOf(entry.getKey()));
                    this.valueTypeAdapter.write(jsonWriter, entry.getValue());
                }
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(object.size());
            ArrayList arrayList2 = new ArrayList(object.size());
            Iterator iterator = object.entrySet().iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                object = this.keyTypeAdapter.toJsonTree(entry.getKey());
                arrayList.add(object);
                arrayList2.add(entry.getValue());
                int n5 = ((JsonElement)object).isJsonArray() || ((JsonElement)object).isJsonObject() ? 1 : 0;
                n4 = n5 | n4;
            }
            if (n4 != 0) {
                jsonWriter.beginArray();
                n4 = n3;
                while (true) {
                    if (n4 >= arrayList.size()) {
                        jsonWriter.endArray();
                        return;
                    }
                    jsonWriter.beginArray();
                    Streams.write((JsonElement)arrayList.get(n4), jsonWriter);
                    this.valueTypeAdapter.write(jsonWriter, arrayList2.get(n4));
                    jsonWriter.endArray();
                    ++n4;
                }
            }
            jsonWriter.beginObject();
            n4 = n2;
            while (true) {
                if (n4 >= arrayList.size()) {
                    jsonWriter.endObject();
                    return;
                }
                jsonWriter.name(this.keyToString((JsonElement)arrayList.get(n4)));
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(n4));
                ++n4;
            }
        }
    }
}

