/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class UnsafeAllocator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UnsafeAllocator create() {
        UnsafeAllocator unsafeAllocator;
        try {
            unsafeAllocator = Class.forName("sun.misc.Unsafe");
            final Object object = ((Class)((Object)unsafeAllocator)).getDeclaredField("theUnsafe");
            ((Field)object).setAccessible(true);
            object = ((Field)object).get(null);
            final Method method = ((Class)((Object)unsafeAllocator)).getMethod("allocateInstance", Class.class);
            return new UnsafeAllocator(){

                @Override
                public <T> T newInstance(Class<T> clazz) throws Exception {
                    return (T)method.invoke(object, clazz);
                }
            };
        }
        catch (Exception exception) {
            try {
                final Method method = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                method.setAccessible(true);
                return new UnsafeAllocator(){

                    @Override
                    public <T> T newInstance(Class<T> clazz) throws Exception {
                        return (T)method.invoke(null, clazz, Object.class);
                    }
                };
            }
            catch (Exception exception2) {
                try {
                    unsafeAllocator = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                    ((Method)((Object)unsafeAllocator)).setAccessible(true);
                    final int n2 = (Integer)((Method)((Object)unsafeAllocator)).invoke(null, Object.class);
                    final Method method = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Integer.TYPE);
                    method.setAccessible(true);
                    return new UnsafeAllocator(){

                        @Override
                        public <T> T newInstance(Class<T> clazz) throws Exception {
                            return (T)method.invoke(null, clazz, n2);
                        }
                    };
                }
                catch (Exception exception3) {
                    return new UnsafeAllocator(){

                        @Override
                        public <T> T newInstance(Class<T> clazz) {
                            throw new UnsupportedOperationException("Cannot allocate " + clazz);
                        }
                    };
                }
            }
        }
    }

    public abstract <T> T newInstance(Class<T> var1) throws Exception;
}

