/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui.hex;

import com.coremedia.iso.gui.Iso8859_1;
import com.coremedia.iso.gui.hex.JHexEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JComponent;

public class JHexEditorASCII
extends JComponent
implements KeyListener,
MouseListener {
    private JHexEditor he;

    public JHexEditorASCII(JHexEditor jHexEditor) {
        this.he = jHexEditor;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(jHexEditor);
    }

    private void debug(String string2) {
        if (this.he.DEBUG) {
            System.out.println("JHexEditorASCII ==> " + string2);
        }
    }

    public int calcularPosicionRaton(int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(JHexEditor.font);
        this.debug("x=" + (n2 /= fontMetrics.stringWidth(" ") + 1) + " ,y=" + (n3 /= fontMetrics.getHeight()));
        return (n3 + this.he.getInicio()) * 16 + n2;
    }

    @Override
    public Dimension getMinimumSize() {
        this.debug("getMinimumSize()");
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this.getFontMetrics(JHexEditor.font);
        int n2 = fontMetrics.getHeight();
        int n3 = this.he.getNumberOfVisibleLines();
        dimension.setSize((fontMetrics.stringWidth(" ") + 1) * 16 + this.he.border * 2 + 1, n2 * n3 + this.he.border * 2 + 1);
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        this.debug("getPreferredSize()");
        return this.getMinimumSize();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.debug("keyReleased(" + keyEvent + ")");
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.debug("mouseClicked(" + mouseEvent + ")");
        this.he.cursor = this.calcularPosicionRaton(mouseEvent.getX(), mouseEvent.getY());
        this.requestFocus();
        this.he.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void paint(Graphics graphics) {
        long l2;
        this.debug("paint(" + graphics + ")");
        this.debug("cursor=" + this.he.cursor + " buff.length=" + this.he.buff.limit());
        Serializable serializable = this.getMinimumSize();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
        graphics.setColor(Color.black);
        graphics.setFont(JHexEditor.font);
        int n2 = this.he.getInicio() * 16;
        long l3 = l2 = (long)(this.he.getNumberOfVisibleLines() * 16 + n2);
        if (l2 > (long)this.he.buff.limit()) {
            l3 = this.he.buff.limit();
        }
        this.he.buff.position(n2);
        int n3 = 0;
        int n4 = 0;
        while ((long)n2 < l3) {
            if (n2 == this.he.cursor) {
                graphics.setColor(Color.blue);
                if (this.hasFocus()) {
                    this.he.filledCursor(graphics, n3, n4, 1);
                } else {
                    this.he.cuadro(graphics, n3, n4, 1);
                }
                if (this.hasFocus()) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(Color.black);
                }
            } else {
                graphics.setColor(Color.black);
            }
            String string2 = Iso8859_1.convert(new byte[]{this.he.buff.get()});
            serializable = this.he;
            int n5 = n3 + 1;
            ((JHexEditor)serializable).printString(graphics, string2, n3, n4);
            int n6 = n4;
            n3 = n5;
            if (n5 == 16) {
                n6 = n4 + 1;
                n3 = 0;
            }
            ++n2;
            n4 = n6;
        }
        return;
    }
}

