/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.FullBox;
import com.coremedia.iso.boxes.SchemeInformationBox;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ItemProtectionBox
extends AbstractContainerBox
implements FullBox {
    public static final String TYPE = "ipro";
    private int flags;
    private int version;

    public ItemProtectionBox() {
        super(TYPE);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        IsoTypeWriter.writeUInt8(byteBuffer, this.version);
        IsoTypeWriter.writeUInt24(byteBuffer, this.flags);
        IsoTypeWriter.writeUInt16(byteBuffer, this.getBoxes().size());
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SchemeInformationBox getItemProtectionScheme() {
        if (this.getBoxes(SchemeInformationBox.class).isEmpty()) return null;
        return this.getBoxes(SchemeInformationBox.class).get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() {
        int n2;
        long l2 = this.getContainerSize();
        if (this.largeBox || l2 + 6L >= 0x100000000L) {
            n2 = 16;
            return (long)n2 + (l2 + 6L);
        }
        n2 = 8;
        return (long)n2 + (l2 + 6L);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        byteBuffer = ByteBuffer.allocate(6);
        dataSource.read(byteBuffer);
        byteBuffer.rewind();
        this.version = IsoTypeReader.readUInt8(byteBuffer);
        this.flags = IsoTypeReader.readUInt24(byteBuffer);
        this.parseContainer(dataSource, l2, boxParser);
    }

    @Override
    public void setFlags(int n2) {
        this.flags = n2;
    }

    @Override
    public void setVersion(int n2) {
        this.version = n2;
    }
}

