/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import com.common.gmacs.downloader.Cache;
import com.common.gmacs.downloader.CacheDispatcher;
import com.common.gmacs.downloader.ExecutorDelivery;
import com.common.gmacs.downloader.Network;
import com.common.gmacs.downloader.NetworkDispatcher;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.RequestQueue$1;
import com.common.gmacs.downloader.ResponseDelivery;
import com.common.gmacs.downloader.VolleyLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestQueue {
    private static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    private final Cache mCache;
    private CacheDispatcher mCacheDispatcher;
    private final PriorityBlockingQueue<Request<?>> mCacheQueue;
    private final Set<Request<?>> mCurrentRequests;
    private final ResponseDelivery mDelivery;
    private NetworkDispatcher[] mDispatchers;
    private final List<RequestFinishedListener> mFinishedListeners;
    private final Network mNetwork;
    private final PriorityBlockingQueue<Request<?>> mNetworkQueue;
    private AtomicInteger mSequenceGenerator = new AtomicInteger();
    private final Map<String, Queue<Request<?>>> mWaitingRequests = new HashMap();

    public RequestQueue(Cache cache, Network network) {
        this(cache, network, 4);
    }

    public RequestQueue(Cache cache, Network network, int n2) {
        this(cache, network, n2, new ExecutorDelivery());
    }

    public RequestQueue(Cache cache, Network network, int n2, ResponseDelivery responseDelivery) {
        this.mCurrentRequests = new HashSet();
        this.mCacheQueue = new PriorityBlockingQueue();
        this.mNetworkQueue = new PriorityBlockingQueue();
        this.mFinishedListeners = new ArrayList<RequestFinishedListener>();
        this.mCache = cache;
        this.mNetwork = network;
        this.mDispatchers = new NetworkDispatcher[n2];
        this.mDelivery = responseDelivery;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Request<T> add(Request<T> request) {
        request.setRequestQueue(this);
        Collection<Object> collection = this.mCurrentRequests;
        synchronized (collection) {
            this.mCurrentRequests.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        request.addMarker("add-to-queue");
        if (!request.shouldCache()) {
            this.mNetworkQueue.add(request);
            return request;
        }
        Map<String, Queue<Request<?>>> map = this.mWaitingRequests;
        synchronized (map) {
            String string2 = request.getCacheKey();
            if (this.mWaitingRequests.containsKey(string2)) {
                Queue<Request<?>> queue = this.mWaitingRequests.get(string2);
                collection = queue;
                if (queue == null) {
                    collection = new Collection<Object>();
                }
                collection.add(request);
                this.mWaitingRequests.put(string2, (Queue<Request<?>>)collection);
                if (!VolleyLog.DEBUG) return request;
                VolleyLog.v("Request for cacheKey=%s is in flight, putting on hold.", string2);
            } else {
                this.mWaitingRequests.put(string2, null);
                this.mCacheQueue.add(request);
            }
            return request;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void addRequestFinishedListener(RequestFinishedListener<T> requestFinishedListener) {
        List<RequestFinishedListener> list = this.mFinishedListeners;
        synchronized (list) {
            this.mFinishedListeners.add(requestFinishedListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelAll(RequestFilter requestFilter) {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            Iterator<Request<?>> iterator = this.mCurrentRequests.iterator();
            while (iterator.hasNext()) {
                Request<?> request = iterator.next();
                if (!requestFilter.apply(request)) continue;
                request.cancel();
            }
            return;
        }
    }

    public void cancelAll(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot cancelAll with a null tag");
        }
        this.cancelAll(new RequestQueue$1(this, object));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    <T> void finish(Request<T> object) {
        Object object2 = this.mCurrentRequests;
        // MONITORENTER : object2
        this.mCurrentRequests.remove(object);
        // MONITOREXIT : object2
        object2 = this.mFinishedListeners;
        // MONITORENTER : object2
        Object object3 = this.mFinishedListeners.iterator();
        while (object3.hasNext()) {
            object3.next().onRequestFinished(object);
        }
        // MONITOREXIT : object2
        if (!object.shouldCache()) return;
        object2 = this.mWaitingRequests;
        // MONITORENTER : object2
        object = object.getCacheKey();
        object3 = this.mWaitingRequests.remove(object);
        if (object3 != null) {
            if (VolleyLog.DEBUG) {
                VolleyLog.v("Releasing %d waiting requests for cacheKey=%s.", object3.size(), object);
            }
            this.mCacheQueue.addAll((Collection<Request<?>>)object3);
        }
        // MONITOREXIT : object2
    }

    public Cache getCache() {
        return this.mCache;
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void removeRequestFinishedListener(RequestFinishedListener<T> requestFinishedListener) {
        List<RequestFinishedListener> list = this.mFinishedListeners;
        synchronized (list) {
            this.mFinishedListeners.remove(requestFinishedListener);
            return;
        }
    }

    public void start() {
        this.mCacheDispatcher = new CacheDispatcher(this.mCacheQueue, this.mNetworkQueue, this.mCache, this.mDelivery);
        this.mCacheDispatcher.start();
        for (int i2 = 0; i2 < this.mDispatchers.length; ++i2) {
            NetworkDispatcher networkDispatcher;
            this.mDispatchers[i2] = networkDispatcher = new NetworkDispatcher(this.mNetworkQueue, this.mNetwork, this.mCache, this.mDelivery);
            networkDispatcher.start();
        }
    }

    public void stop() {
        if (this.mDelivery != null) {
            this.mDelivery.stop();
        }
        if (this.mCacheDispatcher != null) {
            this.mCacheDispatcher.quit();
        }
        for (int i2 = 0; i2 < this.mDispatchers.length; ++i2) {
            if (this.mDispatchers[i2] == null) continue;
            this.mDispatchers[i2].quit();
        }
    }

    public static interface RequestFilter {
        public boolean apply(Request<?> var1);
    }

    public static interface RequestFinishedListener<T> {
        public void onRequestFinished(Request<T> var1);
    }
}

