/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import android.os.Handler;
import android.os.HandlerThread;
import com.common.gmacs.downloader.ExecutorDelivery$1;
import com.common.gmacs.downloader.ExecutorDelivery$2;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.Response;
import com.common.gmacs.downloader.ResponseDelivery;
import com.common.gmacs.downloader.VolleyError;
import java.util.concurrent.Executor;

public class ExecutorDelivery
implements ResponseDelivery {
    private Handler handler;
    private HandlerThread handlerThread;
    private final Executor mResponsePoster;

    public ExecutorDelivery() {
        if (this.handlerThread == null) {
            this.handlerThread = new HandlerThread("DownloadResultDispatcher");
        }
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.mResponsePoster = new ExecutorDelivery$2(this);
    }

    public ExecutorDelivery(Handler handler) {
        this.mResponsePoster = new ExecutorDelivery$1(this, handler);
    }

    public ExecutorDelivery(Executor executor) {
        this.mResponsePoster = executor;
    }

    static /* synthetic */ Handler access$000(ExecutorDelivery executorDelivery) {
        return executorDelivery.handler;
    }

    @Override
    public void postError(Request<?> request, VolleyError object) {
        request.addMarker("post-error");
        object = Response.error((VolleyError)object);
        this.mResponsePoster.execute(new ResponseDeliveryRunnable(request, (Response)object, null));
    }

    @Override
    public void postResponse(Request<?> request, Response<?> response) {
        this.postResponse(request, response, null);
    }

    @Override
    public void postResponse(Request<?> request, Response<?> response, Runnable runnable) {
        request.markDelivered();
        request.addMarker("post-response");
        this.mResponsePoster.execute(new ResponseDeliveryRunnable(request, response, runnable));
    }

    @Override
    public void stop() {
        if (this.handlerThread != null) {
            this.handlerThread.quit();
        }
    }

    private class ResponseDeliveryRunnable
    implements Runnable {
        private final Request mRequest;
        private final Response mResponse;
        private final Runnable mRunnable;

        public ResponseDeliveryRunnable(Request request, Response response, Runnable runnable) {
            this.mRequest = request;
            this.mResponse = response;
            this.mRunnable = runnable;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("canceled-at-delivery");
                return;
            }
            if (this.mResponse.isSuccess()) {
                this.mRequest.deliverResponse(this.mResponse.result);
            } else {
                this.mRequest.deliverError(this.mResponse.error);
            }
            if (this.mResponse.intermediate) {
                this.mRequest.addMarker("intermediate-response");
            } else {
                this.mRequest.finish("done");
            }
            if (this.mRunnable == null) return;
            this.mRunnable.run();
        }
    }
}

