/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import android.os.SystemClock;
import com.common.gmacs.downloader.Cache;
import com.common.gmacs.downloader.DiskBasedCache$1;
import com.common.gmacs.downloader.VolleyLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiskBasedCache
implements Cache {
    private static final int CACHE_MAGIC = 538247942;
    private static final int DEFAULT_DISK_USAGE_BYTES = 0x6400000;
    private static final float HYSTERESIS_FACTOR = 0.9f;
    private final Map<String, CacheHeader> mEntries = new LinkedHashMap<String, CacheHeader>(16, 0.75f, true);
    private final int mMaxCacheSizeInBytes;
    private final File mRootDirectory;
    private long mTotalSize = 0L;

    public DiskBasedCache(File file) {
        this(file, 0x6400000);
    }

    public DiskBasedCache(File file, int n2) {
        this.mRootDirectory = file;
        this.mMaxCacheSizeInBytes = n2;
    }

    private String getFilenameForKey(String string2) {
        int n2 = string2.length() / 2;
        int n3 = string2.substring(0, n2).hashCode();
        return String.valueOf(n3) + String.valueOf(string2.substring(n2).hashCode());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void pruneIfNeeded(long l2) {
        if (this.mTotalSize + l2 < (long)this.mMaxCacheSizeInBytes) {
            return;
        }
        if (VolleyLog.DEBUG) {
            VolleyLog.v("Pruning old cache entries.", new Object[0]);
        }
        long l3 = this.mTotalSize;
        long l4 = SystemClock.elapsedRealtime();
        Iterator<Map.Entry<String, CacheHeader>> iterator = this.mEntries.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            CacheHeader cacheHeader = iterator.next().getValue();
            if (this.getFileForKey(cacheHeader.key).delete()) {
                this.mTotalSize -= cacheHeader.size;
            } else {
                VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", cacheHeader.key, this.getFilenameForKey(cacheHeader.key));
            }
            iterator.remove();
            ++n2;
            if (!((float)(this.mTotalSize + l2) < (float)this.mMaxCacheSizeInBytes * 0.9f)) continue;
        }
        if (!VolleyLog.DEBUG) return;
        VolleyLog.v("pruned %d files, %d bytes, %d ms", n2, this.mTotalSize - l3, SystemClock.elapsedRealtime() - l4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void putEntry(String string2, CacheHeader cacheHeader) {
        if (!this.mEntries.containsKey(string2)) {
            this.mTotalSize += cacheHeader.size;
        } else {
            CacheHeader cacheHeader2 = this.mEntries.get(string2);
            long l2 = this.mTotalSize;
            this.mTotalSize = cacheHeader.size - cacheHeader2.size + l2;
        }
        this.mEntries.put(string2, cacheHeader);
    }

    private static int read(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return n2;
    }

    static int readInt(InputStream inputStream) {
        return 0 | DiskBasedCache.read(inputStream) << 0 | DiskBasedCache.read(inputStream) << 8 | DiskBasedCache.read(inputStream) << 16 | DiskBasedCache.read(inputStream) << 24;
    }

    static long readLong(InputStream inputStream) {
        return 0L | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 0 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 8 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 16 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 24 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 32 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 40 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 48 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 56;
    }

    static String readString(InputStream inputStream) {
        return new String(DiskBasedCache.streamToBytes(inputStream, (int)DiskBasedCache.readLong(inputStream)), "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     */
    static Map<String, String> readStringStringMap(InputStream inputStream) {
        int n2 = DiskBasedCache.readInt(inputStream);
        Map<String, String> map = n2 == 0 ? Collections.emptyMap() : new HashMap(n2);
        int n3 = 0;
        while (n3 < n2) {
            map.put(DiskBasedCache.readString(inputStream).intern(), DiskBasedCache.readString(inputStream).intern());
            ++n3;
        }
        return map;
    }

    private void removeEntry(String string2) {
        CacheHeader cacheHeader = this.mEntries.get(string2);
        if (cacheHeader != null) {
            this.mTotalSize -= cacheHeader.size;
            this.mEntries.remove(string2);
        }
    }

    private static byte[] streamToBytes(InputStream inputStream, int n2) {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IOException("Incorrect length " + n2);
        }
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Expected " + n2 + " bytes, read " + n3 + " bytes");
        }
        return byArray;
    }

    static void writeInt(OutputStream outputStream, int n2) {
        outputStream.write(n2 >> 0 & 0xFF);
        outputStream.write(n2 >> 8 & 0xFF);
        outputStream.write(n2 >> 16 & 0xFF);
        outputStream.write(n2 >> 24 & 0xFF);
    }

    static void writeLong(OutputStream outputStream, long l2) {
        outputStream.write((byte)(l2 >>> 0));
        outputStream.write((byte)(l2 >>> 8));
        outputStream.write((byte)(l2 >>> 16));
        outputStream.write((byte)(l2 >>> 24));
        outputStream.write((byte)(l2 >>> 32));
        outputStream.write((byte)(l2 >>> 40));
        outputStream.write((byte)(l2 >>> 48));
        outputStream.write((byte)(l2 >>> 56));
    }

    static void writeString(OutputStream outputStream, String object) {
        object = ((String)object).getBytes("UTF-8");
        DiskBasedCache.writeLong(outputStream, ((Object)object).length);
        outputStream.write((byte[])object, 0, ((Object)object).length);
    }

    /*
     * WARNING - void declaration
     */
    static void writeStringStringMap(Map<String, String> object2, OutputStream outputStream) {
        void var1_3;
        if (object2 != null) {
            DiskBasedCache.writeInt((OutputStream)var1_3, object2.size());
            for (Map.Entry entry : object2.entrySet()) {
                DiskBasedCache.writeString((OutputStream)var1_3, (String)entry.getKey());
                DiskBasedCache.writeString((OutputStream)var1_3, (String)entry.getValue());
            }
        } else {
            DiskBasedCache.writeInt((OutputStream)var1_3, 0);
        }
    }

    @Override
    public void clear() {
        synchronized (this) {
            block7: {
                File[] fileArray = this.mRootDirectory.listFiles();
                if (fileArray == null) break block7;
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    fileArray[i2].delete();
                    continue;
                }
            }
            this.mEntries.clear();
            this.mTotalSize = 0L;
            VolleyLog.d("Cache cleared.", new Object[0]);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Cache.Entry get(String var1_1) {
        synchronized (this) {
            block24: {
                var2_8 = this.mEntries.get(var1_1);
                if (var2_8 != null) break block24;
                var1_1 = null;
lbl6:
                // 7 sources

                return var1_1;
            }
            var3_12 = this.getFileForKey((String)var1_1);
            var6_15 = new FileInputStream(var3_12);
            var5_14 = new BufferedInputStream(var6_15);
            var4_13 = new CountingInputStream((InputStream)var5_14, null);
            var5_14 = var4_13;
            CacheHeader.readHeader(var4_13);
            var5_14 = var4_13;
            var1_1 = var5_14 = (var2_8 = var2_8.toCacheEntry(DiskBasedCache.streamToBytes(var4_13, (int)(var3_12.length() - (long)CountingInputStream.access$100(var4_13)))));
            if (var4_13 == null) ** GOTO lbl6
            try {
                var4_13.close();
                var1_1 = var5_14;
            }
            catch (IOException var1_2) {
                var1_1 = null;
            }
            catch (IOException var2_9) {
                var4_13 = null;
lbl32:
                // 2 sources

                while (true) {
                    block25: {
                        var5_14 = var4_13;
                        VolleyLog.d("%s: %s", new Object[]{var3_12.getAbsolutePath(), var2_10.toString()});
                        var5_14 = var4_13;
                        this.remove((String)var1_1);
                        if (var4_13 == null) break block25;
                        try {
                            var4_13.close();
                        }
                        catch (IOException var1_3) {
                            var1_1 = null;
                            ** GOTO lbl6
                        }
                    }
                    var1_1 = null;
                    ** GOTO lbl6
                    break;
                }
            }
            catch (Throwable var1_4) {
                var5_14 = null;
lbl50:
                // 2 sources

                while (true) {
                    if (var5_14 == null) ** GOTO lbl55
                    var5_14.close();
lbl55:
                    // 2 sources

                    throw var1_1;
                    break;
                }
                {
                    catch (Throwable var1_5) {
                        throw var1_5;
                    }
                }
                finally {
                }
                {
                    catch (IOException var1_6) {
                        var1_1 = null;
                        ** continue;
                    }
                }
            }
            {
                catch (Throwable var1_7) {
                    ** continue;
                }
            }
            catch (IOException var2_11) {
                ** continue;
            }
        }
    }

    public File getFileForKey(String string2) {
        return new File(this.mRootDirectory, this.getFilenameForKey(string2));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize() {
        synchronized (this) {
            if (!this.mRootDirectory.exists()) {
                if (this.mRootDirectory.mkdirs() != false) return;
                VolleyLog.e("Unable to create cache dir %s", new Object[]{this.mRootDirectory.getAbsolutePath()});
                return;
            }
            var1_1 = this.mRootDirectory.listFiles();
            if (var1_1 == null) return;
            var2_2 = var1_1.length;
            var3_3 = 0;
            block16: while (var3_3 < var2_2) {
                block20: {
                    var4_4 = var1_1[var3_3];
                    var5_5 = null;
                    var7_15 = new FileInputStream(var4_4);
                    var5_5 = var6_11 = new BufferedInputStream((InputStream)var7_15);
                    var7_15 = CacheHeader.readHeader(var6_11);
                    var5_5 = var6_11;
                    var7_15.size = var4_4.length();
                    var5_5 = var6_11;
                    this.putEntry(var7_15.key, (CacheHeader)var7_15);
                    if (var6_11 == null) break block20;
                    var6_11.close();
                }
lbl26:
                // 5 sources

                while (true) {
                    ++var3_3;
                    continue block16;
                    break;
                }
            }
            return;
            catch (IOException var5_6) {
                block21: {
                    var6_11 = null;
lbl32:
                    // 2 sources

                    while (var4_4 != null) {
                        var5_5 = var6_11;
                        try {
                            var4_4.delete();
                            break block21;
                        }
                        catch (Throwable var6_14) {
                            ** GOTO lbl-1000
                        }
                    }
                    break block21;
                    catch (IOException var5_10) {
                        ** GOTO lbl32
                    }
                }
                if (var6_11 == null) ** GOTO lbl26
                try {
                    var6_11.close();
                }
                catch (IOException var5_7) {}
            }
            catch (Throwable var6_12) lbl-1000:
            // 2 sources

            {
                if (var5_5 == null) throw var6_13;
                try {
                    var5_5.close();
                    throw var6_13;
                }
                catch (IOException var5_9) {
                    throw var6_13;
                }
            }
            catch (IOException var5_8) {
                ** continue;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invalidate(String string2, boolean bl) {
        synchronized (this) {
            Cache.Entry entry = this.get(string2);
            if (entry != null) {
                void var2_2;
                entry.softTtl = 0L;
                if (var2_2 != false) {
                    entry.ttl = 0L;
                }
                this.put(string2, entry);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(String object, Cache.Entry entry) {
        synchronized (this) {
            this.pruneIfNeeded(entry.data.length);
            File file = this.getFileForKey((String)object);
            try {
                Object object2 = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object2);
                object2 = new CacheHeader((String)object, entry);
                if (!((CacheHeader)object2).writeHeader(bufferedOutputStream)) {
                    bufferedOutputStream.close();
                    VolleyLog.d("Failed to write header for %s", file.getAbsolutePath());
                    object = new IOException();
                    throw object;
                }
                bufferedOutputStream.write(entry.data);
                bufferedOutputStream.close();
                this.putEntry((String)object, (CacheHeader)object2);
            }
            catch (IOException iOException) {
                if (!file.delete()) {
                    VolleyLog.d("Could not clean up file %s", file.getAbsolutePath());
                }
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void put(String var1_1, File var2_14) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [10, 11 : 154->175)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(String string2) {
        synchronized (this) {
            boolean bl = this.getFileForKey(string2).delete();
            this.removeEntry(string2);
            if (!bl) {
                VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", string2, this.getFilenameForKey(string2));
            }
            return;
        }
    }

    static class CacheHeader {
        public String etag;
        public String key;
        public long lastModified;
        public Map<String, String> responseHeaders;
        public long serverDate;
        public long size;
        public long softTtl;
        public long ttl;

        private CacheHeader() {
        }

        public CacheHeader(String string2, long l2) {
            this.key = string2;
            this.size = l2;
            this.responseHeaders = Collections.emptyMap();
        }

        public CacheHeader(String string2, Cache.Entry entry) {
            this.key = string2;
            this.size = entry.data.length;
            this.etag = entry.etag;
            this.serverDate = entry.serverDate;
            this.lastModified = entry.lastModified;
            this.ttl = entry.ttl;
            this.softTtl = entry.softTtl;
            this.responseHeaders = entry.responseHeaders;
        }

        public static CacheHeader readHeader(InputStream inputStream) {
            CacheHeader cacheHeader = new CacheHeader();
            if (DiskBasedCache.readInt(inputStream) != 538247942) {
                throw new IOException();
            }
            cacheHeader.key = DiskBasedCache.readString(inputStream);
            cacheHeader.etag = DiskBasedCache.readString(inputStream);
            if (cacheHeader.etag.equals("")) {
                cacheHeader.etag = null;
            }
            cacheHeader.serverDate = DiskBasedCache.readLong(inputStream);
            cacheHeader.lastModified = DiskBasedCache.readLong(inputStream);
            cacheHeader.ttl = DiskBasedCache.readLong(inputStream);
            cacheHeader.softTtl = DiskBasedCache.readLong(inputStream);
            cacheHeader.responseHeaders = DiskBasedCache.readStringStringMap(inputStream);
            return cacheHeader;
        }

        public Cache.Entry toCacheEntry(byte[] byArray) {
            Cache.Entry entry = new Cache.Entry();
            entry.data = byArray;
            entry.etag = this.etag;
            entry.serverDate = this.serverDate;
            entry.lastModified = this.lastModified;
            entry.ttl = this.ttl;
            entry.softTtl = this.softTtl;
            entry.responseHeaders = this.responseHeaders;
            return entry;
        }

        public String toString() {
            return "CacheHeader{size=" + this.size + ", key='" + this.key + '\'' + ", etag='" + this.etag + '\'' + ", serverDate=" + this.serverDate + ", lastModified=" + this.lastModified + ", ttl=" + this.ttl + ", softTtl=" + this.softTtl + ", responseHeaders=" + this.responseHeaders + '}';
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean writeHeader(OutputStream outputStream) {
            boolean bl = true;
            try {
                DiskBasedCache.writeInt(outputStream, 538247942);
                DiskBasedCache.writeString(outputStream, this.key);
                String string2 = this.etag == null ? "" : this.etag;
                DiskBasedCache.writeString(outputStream, string2);
                DiskBasedCache.writeLong(outputStream, this.serverDate);
                DiskBasedCache.writeLong(outputStream, this.lastModified);
                DiskBasedCache.writeLong(outputStream, this.ttl);
                DiskBasedCache.writeLong(outputStream, this.softTtl);
                DiskBasedCache.writeStringStringMap(this.responseHeaders, outputStream);
                outputStream.flush();
                return bl;
            }
            catch (IOException iOException) {
                VolleyLog.d("%s", iOException.toString());
                return false;
            }
        }
    }

    private static class CountingInputStream
    extends FilterInputStream {
        private int bytesRead = 0;

        private CountingInputStream(InputStream inputStream) {
            super(inputStream);
        }

        /* synthetic */ CountingInputStream(InputStream inputStream, DiskBasedCache$1 diskBasedCache$1) {
            this(inputStream);
        }

        static /* synthetic */ int access$100(CountingInputStream countingInputStream) {
            return countingInputStream.bytesRead;
        }

        @Override
        public int read() {
            int n2 = super.read();
            if (n2 != -1) {
                ++this.bytesRead;
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            if ((n2 = super.read(byArray, n2, n3)) != -1) {
                this.bytesRead += n2;
            }
            return n2;
        }
    }
}

