/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import android.os.Process;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.downloader.Cache;
import com.common.gmacs.downloader.CacheDispatcher$1;
import com.common.gmacs.downloader.CacheDispatcher$2;
import com.common.gmacs.downloader.NetworkResponse;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.Response;
import com.common.gmacs.downloader.ResponseDelivery;
import com.common.gmacs.downloader.VolleyLog;
import java.util.concurrent.BlockingQueue;

public class CacheDispatcher
extends Thread {
    private static final boolean DEBUG = VolleyLog.DEBUG;
    private final Cache mCache;
    private final BlockingQueue<Request<?>> mCacheQueue;
    private final ResponseDelivery mDelivery;
    private final BlockingQueue<Request<?>> mNetworkQueue;
    private volatile boolean mQuit = false;

    public CacheDispatcher(BlockingQueue<Request<?>> blockingQueue, BlockingQueue<Request<?>> blockingQueue2, Cache cache, ResponseDelivery responseDelivery) {
        super("CacheDispatcher");
        this.mCacheQueue = blockingQueue;
        this.mNetworkQueue = blockingQueue2;
        this.mCache = cache;
        this.mDelivery = responseDelivery;
    }

    static /* synthetic */ ResponseDelivery access$000(CacheDispatcher cacheDispatcher) {
        return cacheDispatcher.mDelivery;
    }

    static /* synthetic */ BlockingQueue access$100(CacheDispatcher cacheDispatcher) {
        return cacheDispatcher.mNetworkQueue;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (DEBUG) {
            VolleyLog.v("start new dispatcher", new Object[0]);
        }
        Process.setThreadPriority((int)10);
        this.mCache.initialize();
        while (true) {
            Request<?> request;
            try {
                while (true) {
                    request = this.mCacheQueue.take();
                    request.addMarker("cache-queue-take");
                    if (request.isCanceled()) {
                        request.finish("cache-discard-canceled");
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                if (!this.mQuit) continue;
                return;
            }
            {
                Object object;
                if (request.getUrl().startsWith("/")) {
                    object = new CacheDispatcher$1(this, request);
                    ClientManager.post((Runnable)object);
                    continue;
                }
                Object object2 = this.mCache.get(request.getCacheKey());
                if (object2 == null) {
                    request.addMarker("cache-miss");
                    this.mNetworkQueue.put(request);
                    continue;
                }
                if (((Cache.Entry)object2).isExpired()) {
                    request.addMarker("cache-hit-expired");
                    request.setCacheEntry((Cache.Entry)object2);
                    this.mNetworkQueue.put(request);
                    continue;
                }
                request.addMarker("cache-hit");
                object = new NetworkResponse(((Cache.Entry)object2).data, ((Cache.Entry)object2).responseHeaders);
                object = request.parseNetworkResponse((NetworkResponse)object);
                request.addMarker("cache-hit-parsed");
                if (!((Cache.Entry)object2).refreshNeeded()) {
                    this.mDelivery.postResponse(request, (Response<?>)object);
                    continue;
                }
                request.addMarker("cache-hit-refresh-needed");
                request.setCacheEntry((Cache.Entry)object2);
                ((Response)object).intermediate = true;
                ResponseDelivery responseDelivery = this.mDelivery;
                object2 = new CacheDispatcher$2(this, request);
                responseDelivery.postResponse(request, (Response<?>)object, (Runnable)object2);
                continue;
            }
            break;
        }
    }
}

