/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import java.io.File;
import java.util.Collections;
import java.util.Map;

public interface Cache {
    public void clear();

    public Entry get(String var1);

    public void initialize();

    public void invalidate(String var1, boolean var2);

    public void put(String var1, Entry var2);

    public void put(String var1, File var2);

    public void remove(String var1);

    public static class Entry {
        public byte[] data;
        public String etag;
        public long lastModified;
        public Map<String, String> responseHeaders = Collections.emptyMap();
        public long serverDate;
        public long softTtl;
        public long ttl;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isExpired() {
            if (this.ttl == 0L) return false;
            if (this.ttl >= System.currentTimeMillis()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean refreshNeeded() {
            if (this.softTtl == 0L) return false;
            if (this.softTtl >= System.currentTimeMillis()) return false;
            return true;
        }
    }
}

