/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkEnforcingInputStream
extends FilterInputStream {
    private static final int END_OF_STREAM = -1;
    private static final int UNSET = Integer.MIN_VALUE;
    private int availableBytes = Integer.MIN_VALUE;

    public MarkEnforcingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getBytesToRead(long l2) {
        if (this.availableBytes == 0) {
            return -1L;
        }
        long l3 = l2;
        if (this.availableBytes == Integer.MIN_VALUE) return l3;
        l3 = l2;
        if (l2 <= (long)this.availableBytes) return l3;
        return this.availableBytes;
    }

    private void updateAvailableBytesAfterRead(long l2) {
        if (this.availableBytes != Integer.MIN_VALUE && l2 != -1L) {
            this.availableBytes = (int)((long)this.availableBytes - l2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int available() throws IOException {
        if (this.availableBytes != Integer.MIN_VALUE) return Math.min(this.availableBytes, super.available());
        return super.available();
    }

    @Override
    public void mark(int n2) {
        super.mark(n2);
        this.availableBytes = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        if (this.getBytesToRead(1L) == -1L) {
            return -1;
        }
        int n2 = super.read();
        this.updateAvailableBytesAfterRead(1L);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = -1;
        if ((n3 = (int)this.getBytesToRead(n3)) == -1) {
            return n4;
        }
        n2 = super.read(byArray, n2, n3);
        this.updateAvailableBytesAfterRead(n2);
        return n2;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.availableBytes = Integer.MIN_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long skip(long l2) throws IOException {
        long l3 = -1L;
        if ((l2 = this.getBytesToRead(l2)) == -1L) {
            return l3;
        }
        l2 = super.skip(l2);
        this.updateAvailableBytesAfterRead(l2);
        return l2;
    }
}

