/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.util.Log;
import com.bumptech.glide.util.Util;
import java.util.Queue;

public final class ByteArrayPool {
    private static final ByteArrayPool BYTE_ARRAY_POOL = new ByteArrayPool();
    private static final int MAX_BYTE_ARRAY_COUNT = 32;
    private static final int MAX_SIZE = 0x20C000;
    private static final String TAG = "ByteArrayPool";
    private static final int TEMP_BYTES_SIZE = 65536;
    private final Queue<byte[]> tempQueue = Util.createQueue((int)0);

    private ByteArrayPool() {
    }

    public static ByteArrayPool get() {
        return BYTE_ARRAY_POOL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            this.tempQueue.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() {
        byte[] byArray;
        Object object = this.tempQueue;
        synchronized (object) {
            byArray = this.tempQueue.poll();
        }
        object = byArray;
        if (byArray != null) return object;
        byArray = new byte[65536];
        object = byArray;
        if (!Log.isLoggable((String)TAG, (int)3)) return object;
        Log.d((String)TAG, (String)"Created temp bytes");
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean releaseBytes(byte[] byArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (byArray.length != 65536) {
            return bl2;
        }
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            bl2 = bl;
            if (this.tempQueue.size() >= 32) return bl2;
            bl2 = true;
            this.tempQueue.offer(byArray);
            return bl2;
        }
    }
}

