/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.os.ParcelFileDescriptor;
import com.bumptech.glide.load.Encoder;
import com.bumptech.glide.load.model.ImageVideoWrapper;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageVideoWrapperEncoder
implements Encoder<ImageVideoWrapper> {
    private final Encoder<ParcelFileDescriptor> fileDescriptorEncoder;
    private String id;
    private final Encoder<InputStream> streamEncoder;

    public ImageVideoWrapperEncoder(Encoder<InputStream> encoder, Encoder<ParcelFileDescriptor> encoder2) {
        this.streamEncoder = encoder;
        this.fileDescriptorEncoder = encoder2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean encode(ImageVideoWrapper imageVideoWrapper, OutputStream outputStream) {
        if (imageVideoWrapper.getStream() == null) return this.fileDescriptorEncoder.encode(imageVideoWrapper.getFileDescriptor(), outputStream);
        return this.streamEncoder.encode(imageVideoWrapper.getStream(), outputStream);
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.streamEncoder.getId() + this.fileDescriptorEncoder.getId();
        }
        return this.id;
    }
}

