/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.prefill.BitmapPreFillRunner;
import com.bumptech.glide.load.engine.prefill.PreFillQueue;
import com.bumptech.glide.load.engine.prefill.PreFillType;
import com.bumptech.glide.util.Util;
import java.util.HashMap;

public final class BitmapPreFiller {
    private final BitmapPool bitmapPool;
    private BitmapPreFillRunner current;
    private final DecodeFormat defaultFormat;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final MemoryCache memoryCache;

    public BitmapPreFiller(MemoryCache memoryCache, BitmapPool bitmapPool, DecodeFormat decodeFormat) {
        this.memoryCache = memoryCache;
        this.bitmapPool = bitmapPool;
        this.defaultFormat = decodeFormat;
    }

    private static int getSizeInBytes(PreFillType preFillType) {
        return Util.getBitmapByteSize((int)preFillType.getWidth(), (int)preFillType.getHeight(), (Bitmap.Config)preFillType.getConfig());
    }

    PreFillQueue generateAllocationOrder(PreFillType[] preFillTypeArray) {
        int n2;
        int n3 = 0;
        int n4 = this.memoryCache.getMaxSize();
        int n5 = this.memoryCache.getCurrentSize();
        int n6 = this.bitmapPool.getMaxSize();
        int n7 = preFillTypeArray.length;
        int n8 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            n8 += preFillTypeArray[n2].getWeight();
        }
        float f2 = (float)(n4 - n5 + n6) / (float)n8;
        HashMap<PreFillType, Integer> hashMap = new HashMap<PreFillType, Integer>();
        n8 = preFillTypeArray.length;
        for (n2 = n3; n2 < n8; ++n2) {
            PreFillType preFillType = preFillTypeArray[n2];
            hashMap.put(preFillType, Math.round((float)preFillType.getWeight() * f2) / BitmapPreFiller.getSizeInBytes(preFillType));
        }
        return new PreFillQueue(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void preFill(PreFillType.Builder ... object) {
        if (this.current != null) {
            this.current.cancel();
        }
        PreFillType[] preFillTypeArray = new PreFillType[((PreFillType.Builder[])object).length];
        int n2 = 0;
        while (true) {
            if (n2 >= ((PreFillType.Builder[])object).length) {
                PreFillQueue preFillQueue = this.generateAllocationOrder(preFillTypeArray);
                this.current = new BitmapPreFillRunner(this.bitmapPool, this.memoryCache, preFillQueue);
                this.handler.post((Runnable)this.current);
                return;
            }
            PreFillType.Builder builder = object[n2];
            if (builder.getConfig() == null) {
                Bitmap.Config config = this.defaultFormat == DecodeFormat.ALWAYS_ARGB_8888 || this.defaultFormat == DecodeFormat.PREFER_ARGB_8888 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                builder.setConfig(config);
            }
            preFillTypeArray[n2] = builder.build();
            ++n2;
        }
    }
}

