/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.gifdecoder.GifFrame;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.gifdecoder.GifHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifDecoder {
    private static final Bitmap.Config BITMAP_CONFIG;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int NULL_CODE = -1;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_OPEN_ERROR = 2;
    public static final int STATUS_PARTIAL_DECODE = 3;
    private static final String TAG;
    private int[] act;
    private BitmapProvider bitmapProvider;
    private final byte[] block = new byte[256];
    private byte[] data;
    private int framePointer;
    private GifHeader header;
    private byte[] mainPixels;
    private int[] mainScratch;
    private GifHeaderParser parser;
    private byte[] pixelStack;
    private short[] prefix;
    private Bitmap previousImage;
    private ByteBuffer rawData;
    private boolean savePrevious;
    private int status;
    private byte[] suffix;

    static {
        TAG = GifDecoder.class.getSimpleName();
        BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    }

    public GifDecoder(BitmapProvider bitmapProvider) {
        this.bitmapProvider = bitmapProvider;
        this.header = new GifHeader();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void decodeBitmapData(GifFrame object) {
        int n2;
        if (object != null) {
            this.rawData.position(((GifFrame)object).bufferFrameStart);
        }
        int n3 = object == null ? this.header.width * this.header.height : ((GifFrame)object).iw * ((GifFrame)object).ih;
        if (this.mainPixels == null || this.mainPixels.length < n3) {
            this.mainPixels = new byte[n3];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n4 = this.read();
        int n5 = 1 << n4;
        int n6 = -1;
        int n7 = n4 + 1;
        for (n2 = 0; n2 < n5; ++n2) {
            this.prefix[n2] = (short)0;
            this.suffix[n2] = (byte)n2;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = n7;
        int n14 = (1 << n7) - 1;
        int n15 = n5 + 2;
        n7 = 0;
        int n16 = 0;
        n2 = 0;
        block1: while (true) {
            int n17;
            block25: {
                block26: {
                    block24: {
                        if (n9 >= n3) break block24;
                        n17 = n7;
                        n7 = n16;
                        if (n16 != 0) break block25;
                        n7 = this.readBlock();
                        if (n7 > 0) break block26;
                        this.status = 3;
                    }
                    while (true) {
                        if (n2 >= n3) {
                            return;
                        }
                        this.mainPixels[n2] = (byte)0;
                        ++n2;
                    }
                }
                n17 = 0;
            }
            int n18 = this.block[n17];
            int n19 = n17 + 1;
            n17 = n7 - 1;
            n16 = n13;
            int n20 = n14;
            n14 = n8 + ((n18 & 0xFF) << n12);
            n7 = n15;
            n8 = n12 + 8;
            n15 = n6;
            n13 = n2;
            n2 = n20;
            while (n8 >= n16) {
                n12 = n14 & n2;
                n14 >>= n16;
                n8 -= n16;
                if (n12 == n5) {
                    n16 = n4 + 1;
                    n2 = (1 << n16) - 1;
                    n7 = n5 + 2;
                    n15 = -1;
                    continue;
                }
                if (n12 > n7) {
                    this.status = 3;
                    n12 = n8;
                    n6 = n16;
                    n20 = n7;
                    n7 = n19;
                    n8 = n14;
                    n14 = n2;
                    n16 = n17;
                    n2 = n13;
                    n13 = n6;
                    n6 = n15;
                    n15 = n20;
                    continue block1;
                }
                if (n12 == n5 + 1) {
                    n12 = n8;
                    n6 = n16;
                    n20 = n7;
                    n7 = n19;
                    n8 = n14;
                    n14 = n2;
                    n16 = n17;
                    n2 = n13;
                    n13 = n6;
                    n6 = n15;
                    n15 = n20;
                    continue block1;
                }
                if (n15 == -1) {
                    this.pixelStack[n10] = this.suffix[n12];
                    ++n10;
                    n11 = n12;
                    n15 = n12;
                    continue;
                }
                if (n12 >= n7) {
                    this.pixelStack[n10] = (byte)n11;
                    ++n10;
                    n11 = n15;
                } else {
                    n11 = n12;
                }
                while (n11 >= n5) {
                    this.pixelStack[n10] = this.suffix[n11];
                    n11 = this.prefix[n11];
                    ++n10;
                }
                n20 = this.suffix[n11] & 0xFF;
                object = this.pixelStack;
                n18 = n10 + 1;
                object[n10] = (byte)n20;
                n6 = n16;
                n10 = n2;
                n11 = n7;
                if (n7 < 4096) {
                    this.prefix[n7] = (short)n15;
                    this.suffix[n7] = (byte)n20;
                    n6 = n16;
                    n10 = n2;
                    n11 = ++n7;
                    if ((n7 & n2) == 0) {
                        n6 = n16;
                        n10 = n2;
                        n11 = n7;
                        if (n7 < 4096) {
                            n6 = n16 + 1;
                            n10 = n2 + n7;
                            n11 = n7;
                        }
                    }
                }
                n7 = n9;
                n2 = n18;
                while (n2 > 0) {
                    this.mainPixels[n13] = this.pixelStack[--n2];
                    ++n7;
                    ++n13;
                }
                n9 = n7;
                n15 = n12;
                n12 = n2;
                n16 = n6;
                n2 = n10;
                n7 = n11;
                n10 = n12;
                n11 = n20;
            }
            n20 = n2;
            n2 = n17;
            n6 = n16;
            n17 = n7;
            n12 = n8;
            n7 = n19;
            n16 = n2;
            n2 = n13;
            n8 = n14;
            n13 = n6;
            n6 = n15;
            n14 = n20;
            n15 = n17;
        }
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    private Bitmap getNextBitmap() {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = this.bitmapProvider.obtain(this.header.width, this.header.height, BITMAP_CONFIG);
        if (bitmap == null) {
            bitmap2 = Bitmap.createBitmap((int)this.header.width, (int)this.header.height, (Bitmap.Config)BITMAP_CONFIG);
        }
        GifDecoder.setAlpha(bitmap2);
        return bitmap2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int read() {
        int n2 = 0;
        try {
            byte by = this.rawData.get();
            return by & 0xFF;
        }
        catch (Exception exception) {
            this.status = 1;
            return n2;
        }
    }

    private int readBlock() {
        int n2 = this.read();
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            while (true) {
                n3 = n4;
                if (n4 >= n2) break;
                n3 = n2 - n4;
                try {
                    this.rawData.get(this.block, n4, n3);
                    n4 += n3;
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (String)"Error Reading Block", (Throwable)exception);
                    this.status = 1;
                    n3 = n4;
                    break;
                }
            }
        }
        return n3;
    }

    @TargetApi(value=12)
    private static void setAlpha(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Bitmap setPixels(GifFrame gifFrame, GifFrame gifFrame2) {
        int n2;
        int n3 = this.header.width;
        int n4 = this.header.height;
        int[] nArray = this.mainScratch;
        if (gifFrame2 != null && gifFrame2.dispose > 0) {
            if (gifFrame2.dispose == 2) {
                n2 = 0;
                if (!gifFrame.transparency) {
                    n2 = this.header.bgColor;
                }
                Arrays.fill(nArray, n2);
            } else if (gifFrame2.dispose == 3 && this.previousImage != null) {
                this.previousImage.getPixels(nArray, 0, n3, 0, 0, n3, n4);
            }
        }
        this.decodeBitmapData(gifFrame);
        int n5 = 1;
        int n6 = 8;
        int n7 = 0;
        int n8 = 0;
        while (true) {
            int n9;
            int n10;
            block20: {
                block19: {
                    block18: {
                        if (n8 >= gifFrame.ih) break block18;
                        if (!gifFrame.interlace) break block19;
                        n2 = n7;
                        n10 = n6;
                        n9 = n5;
                        if (n7 >= gifFrame.ih) {
                            n9 = n5 + 1;
                            switch (n9) {
                                default: {
                                    n10 = n6;
                                    n2 = n7;
                                    break;
                                }
                                case 2: {
                                    n2 = 4;
                                    n10 = n6;
                                    break;
                                }
                                case 3: {
                                    n2 = 2;
                                    n10 = 4;
                                    break;
                                }
                                case 4: {
                                    n2 = 1;
                                    n10 = 2;
                                }
                            }
                        }
                        n7 = n2 + n10;
                        n5 = n9;
                        break block20;
                    }
                    if (this.savePrevious && (gifFrame.dispose == 0 || gifFrame.dispose == 1)) {
                        if (this.previousImage == null) {
                            this.previousImage = this.getNextBitmap();
                        }
                        this.previousImage.setPixels(nArray, 0, n3, 0, 0, n3, n4);
                    }
                    gifFrame = this.getNextBitmap();
                    gifFrame.setPixels(nArray, 0, n3, 0, 0, n3, n4);
                    return gifFrame;
                }
                n2 = n8;
                n10 = n6;
            }
            if ((n2 += gifFrame.iy) < this.header.height) {
                int n11 = this.header.width * n2;
                n6 = n11 + gifFrame.ix;
                n2 = n9 = gifFrame.iw + n6;
                if (this.header.width + n11 < n9) {
                    n2 = this.header.width + n11;
                }
                n9 = gifFrame.iw * n8;
                while (n6 < n2) {
                    n11 = this.mainPixels[n9];
                    if ((n11 = this.act[n11 & 0xFF]) != 0) {
                        nArray[n6] = n11;
                    }
                    ++n6;
                    ++n9;
                }
            }
            ++n8;
            n6 = n10;
        }
    }

    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
    }

    public void clear() {
        this.header = null;
        this.data = null;
        this.mainPixels = null;
        this.mainScratch = null;
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
        this.rawData = null;
    }

    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDelay(int n2) {
        int n3;
        int n4 = n3 = -1;
        if (n2 >= 0) {
            n4 = n3;
            if (n2 < this.header.frameCount) {
                n4 = this.header.frames.get((int)n2).delay;
            }
        }
        return n4;
    }

    public int getFrameCount() {
        return this.header.frameCount;
    }

    public int getHeight() {
        return this.header.height;
    }

    public int getLoopCount() {
        return this.header.loopCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNextDelay() {
        if (this.header.frameCount <= 0) return -1;
        if (this.framePointer >= 0) return this.getDelay(this.framePointer);
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getNextFrame() {
        int n2 = 0;
        synchronized (this) {
            Object object;
            Object object2;
            if (this.header.frameCount <= 0 || this.framePointer < 0) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    object2 = TAG;
                    object = new StringBuilder();
                    Log.d((String)object2, (String)((StringBuilder)object).append("unable to decode frame, frameCount=").append(this.header.frameCount).append(" framePointer=").append(this.framePointer).toString());
                }
                this.status = 1;
            }
            if (this.status == 1 || this.status == 2) {
                if (!Log.isLoggable((String)TAG, (int)3)) return null;
                object = TAG;
                object2 = new StringBuilder();
                Log.d((String)object, (String)((StringBuilder)object2).append("Unable to decode frame, status=").append(this.status).toString());
                return null;
            }
            this.status = 0;
            object2 = this.header.frames.get(this.framePointer);
            int n3 = this.framePointer - 1;
            object = n3 >= 0 ? this.header.frames.get(n3) : null;
            if (((GifFrame)object2).lct == null) {
                this.act = this.header.gct;
            } else {
                this.act = ((GifFrame)object2).lct;
                if (this.header.bgIndex == ((GifFrame)object2).transIndex) {
                    this.header.bgColor = 0;
                }
            }
            if (((GifFrame)object2).transparency) {
                n2 = this.act[((GifFrame)object2).transIndex];
                this.act[((GifFrame)object2).transIndex] = 0;
            }
            if (this.act == null) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"No Valid Color Table");
                }
                this.status = 1;
                return null;
            }
            object = this.setPixels((GifFrame)object2, (GifFrame)object);
            if (!((GifFrame)object2).transparency) return object;
            this.act[((GifFrame)object2).transIndex] = n2;
            return object;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public int getWidth() {
        return this.header.width;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(InputStream var1_1, int var2_3) {
        block8: {
            var3_4 = 16384;
            if (var1_1 == null) break block8;
            if (var2_3 > 0) {
                var3_4 = var2_3 + 4096;
            }
            try {
                var4_5 = new ByteArrayOutputStream(var3_4);
                var5_6 = new byte[16384];
                while ((var2_3 = var1_1.read(var5_6, 0, var5_6.length)) != -1) {
                    var4_5.write(var5_6, 0, var2_3);
                }
            }
            catch (IOException var5_7) {
                Log.w((String)GifDecoder.TAG, (String)"Error reading data from stream", (Throwable)var5_7);
lbl15:
                // 3 sources

                while (true) {
                    if (var1_1 == null) return this.status;
                    try {
                        var1_1.close();
                        return this.status;
                    }
                    catch (IOException var1_2) {
                        Log.w((String)GifDecoder.TAG, (String)"Error closing stream", (Throwable)var1_2);
                        return this.status;
                    }
                    break;
                }
            }
            {
                var4_5.flush();
                this.read(var4_5.toByteArray());
                ** GOTO lbl15
            }
        }
        this.status = 2;
        ** while (true)
    }

    public int read(byte[] object) {
        this.data = object;
        this.header = this.getHeaderParser().setData((byte[])object).parseHeader();
        if (object != null) {
            this.rawData = ByteBuffer.wrap((byte[])object);
            this.rawData.rewind();
            this.rawData.order(ByteOrder.LITTLE_ENDIAN);
            this.mainPixels = new byte[this.header.width * this.header.height];
            this.mainScratch = new int[this.header.width * this.header.height];
            this.savePrevious = false;
            object = this.header.frames.iterator();
            while (object.hasNext()) {
                if (((GifFrame)object.next()).dispose != 3) continue;
                this.savePrevious = true;
                break;
            }
        }
        return this.status;
    }

    public void resetFrameIndex() {
        this.framePointer = -1;
    }

    public void setData(GifHeader gifHeader, byte[] object) {
        this.header = gifHeader;
        this.data = object;
        this.status = 0;
        this.framePointer = -1;
        this.rawData = ByteBuffer.wrap((byte[])object);
        this.rawData.rewind();
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        object = gifHeader.frames.iterator();
        while (object.hasNext()) {
            if (((GifFrame)object.next()).dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.mainPixels = new byte[gifHeader.width * gifHeader.height];
        this.mainScratch = new int[gifHeader.width * gifHeader.height];
    }

    public static interface BitmapProvider {
        public Bitmap obtain(int var1, int var2, Bitmap.Config var3);

        public void release(Bitmap var1);
    }
}

