/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.disklrucache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;

final class Util {
    static final Charset US_ASCII = Charset.forName("US-ASCII");
    static final Charset UTF_8 = Charset.forName("UTF-8");

    private Util() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void deleteContents(File file2) throws IOException {
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            throw new IOException("not a readable directory: " + file2);
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                Util.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete file: " + file2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readFully(Reader reader) throws IOException {
        try {
            int n2;
            StringWriter stringWriter = new StringWriter();
            Object object = new char[1024];
            while ((n2 = reader.read((char[])object)) != -1) {
                stringWriter.write((char[])object, 0, n2);
            }
            object = stringWriter.toString();
            return object;
        }
        finally {
            reader.close();
        }
    }
}

