/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view.emoji;

import com.android.gmacs.view.emoji.GifEmoji;
import com.android.gmacs.view.emoji.GifGroup;
import com.common.gmacs.parse.gif.IGifParser;
import com.common.gmacs.utils.FileUtil;
import com.common.gmacs.utils.GmacsEnvi;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONObject;

public class GifUtil
implements IGifParser {
    public static final int GIF_COUNT = 8;
    public static final String GIF_PATH = "gif";
    private static ArrayList<GifGroup> gifGoups;
    private static volatile GifUtil ourInstance;

    private GifUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GifEmoji getGif(String object) {
        ArrayList<GifGroup> arrayList = GifUtil.getGifGroups();
        if (arrayList == null) {
            return null;
        }
        Object object2 = object;
        if (object != null) {
            object2 = ((String)object).replace(".gif", "");
        }
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            GifEmoji gifEmoji = arrayList.get((int)n3).emojiMap.get(object2);
            object = gifEmoji;
            if (gifEmoji != null) return object;
            ++n3;
        }
        return null;
    }

    public static String getGifFromSd(String string2) {
        Object var1_1 = null;
        File file = FileUtil.getCacheFile((String)GIF_PATH, (String)string2);
        string2 = var1_1;
        if (file.exists()) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<GifGroup> getGifGroups() {
        synchronized (GifUtil.class) {
            String[] stringArray = gifGoups;
            if (stringArray != null) return gifGoups;
            try {
                stringArray = new ArrayList();
                gifGoups = stringArray;
                stringArray = GmacsEnvi.appContext.getAssets().list(GIF_PATH);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    Object object = GmacsEnvi.appContext.getAssets();
                    StringBuilder stringBuilder = new StringBuilder();
                    object = GifUtil.parseGifGroup(GifUtil.readJsonInfo(object.open(stringBuilder.append("gif/").append(stringArray[n2]).append("/info.json").toString())));
                    gifGoups.add((GifGroup)object);
                    ++n2;
                }
                return gifGoups;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return gifGoups;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getGifPath(String object) {
        ArrayList<GifGroup> arrayList = GifUtil.getGifGroups();
        if (arrayList == null) {
            return null;
        }
        Object object2 = object;
        if (object != null) {
            object2 = ((String)object).replace(".gif", "");
        }
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            object = arrayList.get((int)n3).emojiMap.get(object2);
            if (object != null) {
                return ((GifEmoji)object).gifPath;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifUtil getInstance() {
        if (ourInstance == null) {
            synchronized (GifUtil.class) {
                if (ourInstance == null) {
                    GifUtil gifUtil;
                    ourInstance = gifUtil = new GifUtil();
                }
            }
        }
        return ourInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifGroup parseGifGroup(String arrayList) {
        int n2;
        int n3;
        int n4;
        JSONObject jSONObject;
        GifGroup gifGroup;
        try {
            gifGroup = new GifGroup();
            jSONObject = new LinkedHashMap();
            gifGroup.emojiMap = jSONObject;
            jSONObject = new ArrayList();
            gifGroup.emojiLists = jSONObject;
            jSONObject = new JSONObject(arrayList);
            gifGroup.id = jSONObject.optString("id");
            arrayList = new ArrayList<GifEmoji>();
            gifGroup.path = ((StringBuilder)((Object)arrayList)).append("gif/").append(jSONObject.optString("path")).toString();
            arrayList = new ArrayList<GifEmoji>();
            gifGroup.icon = ((StringBuilder)((Object)arrayList)).append(gifGroup.path).append("/").append(jSONObject.optString("icon")).toString();
            gifGroup.name = jSONObject.optString("name");
            jSONObject = jSONObject.optJSONArray("gifs");
            n4 = jSONObject.length();
            n3 = 0;
            n2 = 1;
            arrayList = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        while (n3 < n4) {
            JSONObject jSONObject2 = jSONObject.optJSONObject(n3);
            GifEmoji gifEmoji = new GifEmoji();
            gifEmoji.serverId = jSONObject2.optString("serverId");
            gifEmoji.gifName = jSONObject2.optString("gifName");
            StringBuilder stringBuilder = new StringBuilder();
            gifEmoji.pngPath = stringBuilder.append(gifGroup.path).append("/").append(jSONObject2.optString("pngPath")).toString();
            stringBuilder = new StringBuilder();
            gifEmoji.gifPath = stringBuilder.append(gifGroup.path).append("/").append(jSONObject2.optString("gifPath")).toString();
            gifGroup.emojiMap.put(gifEmoji.serverId, gifEmoji);
            if (n2 == 1) {
                arrayList = new ArrayList<GifEmoji>();
            }
            arrayList.add(gifEmoji);
            if (n2 == 8) {
                gifGroup.emojiLists.add(arrayList);
                n2 = 1;
            } else {
                ++n2;
            }
            ++n3;
        }
        return gifGroup;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readJsonInfo(InputStream object) {
        BufferedReader bufferedReader;
        StringBuilder stringBuilder;
        try {
            stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((object = bufferedReader.readLine()) != null) {
                stringBuilder.append((String)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
        {
            bufferedReader.close();
            return stringBuilder.toString();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getGifNameById(String object) {
        if ((object = GifUtil.getGif((String)object)) != null) return "[" + ((GifEmoji)object).gifName + "]";
        return "[\u52a8\u753b]";
    }
}

