/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;

public class PinnedHeaderListView
extends ListView {
    private final int fMaxAlpha;
    private boolean forceHeaderViewVisible = true;
    private PinnedHeaderListAdapter mAdapter;
    private boolean mEnabledDynamicAlphaEffect = true;
    private boolean mFirstLayout;
    private View mHeaderView;
    private int mHeaderViewHeight;
    private boolean mHeaderViewVisible;
    private int mHeaderViewWidth;
    private boolean mIsTouchDown;

    public PinnedHeaderListView(Context context) {
        super(context);
        this.fMaxAlpha = 255;
    }

    public PinnedHeaderListView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.fMaxAlpha = 255;
    }

    public PinnedHeaderListView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.fMaxAlpha = 255;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void configureHeaderView(int n2) {
        if (this.mHeaderView == null) return;
        if (this.mAdapter == null) return;
        int n3 = this.getChildAt(0) == null || this.getChildAt(0).getTag() == null ? 0 : this.mAdapter.getPinnedHeaderState(n2);
        switch (n3) {
            case 0: {
                this.mHeaderViewVisible = false;
                return;
            }
            case 1: {
                this.mAdapter.configurePinnedHeader(this.mHeaderView, n2, 255);
                if (this.mHeaderView.getTop() != 0) {
                    this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
                }
                this.mHeaderViewVisible = true;
                return;
            }
            case 2: {
                View view = this.getChildAt(0);
                if (view == null) return;
                int n4 = view.getBottom();
                if (n4 < (n3 = this.mHeaderView.getHeight())) {
                    n4 -= n3;
                    n3 = (n3 + n4) * 255 / n3;
                } else {
                    n3 = 255;
                    n4 = 0;
                }
                PinnedHeaderListAdapter pinnedHeaderListAdapter = this.mAdapter;
                view = this.mHeaderView;
                if (!this.mEnabledDynamicAlphaEffect) {
                    n3 = 255;
                }
                pinnedHeaderListAdapter.configurePinnedHeader(view, n2, n3);
                if (this.mHeaderView.getTop() != n4) {
                    this.mHeaderView.layout(0, n4, this.mHeaderViewWidth, this.mHeaderViewHeight + n4);
                }
                this.mHeaderViewVisible = true;
                return;
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHeaderViewVisible && this.forceHeaderViewVisible) {
            this.drawChild(canvas, this.mHeaderView, this.getDrawingTime());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        try {
            super.onLayout(bl, n2, n3, n4, n5);
        }
        catch (IllegalStateException illegalStateException) {}
        if (this.mHeaderView != null && bl) {
            if (!this.mFirstLayout) {
                this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
                this.mFirstLayout = true;
            }
            this.configureHeaderView(this.getFirstVisiblePosition());
        }
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        if (this.mHeaderView != null) {
            this.measureChild(this.mHeaderView, n2, n3);
            this.mHeaderViewWidth = this.mHeaderView.getMeasuredWidth();
            this.mHeaderViewHeight = this.mHeaderView.getMeasuredHeight();
        }
    }

    public void onPinnedHeaderScroll(int n2) {
        if (this.mHeaderView != null) {
            this.configureHeaderView(n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = true;
        if (!this.mHeaderViewVisible) return super.onTouchEvent(motionEvent);
        if (!(motionEvent.getY() <= (float)this.mHeaderViewHeight)) return super.onTouchEvent(motionEvent);
        switch (motionEvent.getAction()) {
            default: {
                this.mIsTouchDown = false;
                return super.onTouchEvent(motionEvent);
            }
            case 0: {
                this.mIsTouchDown = true;
                return bl;
            }
            case 1: 
        }
        if (!this.mIsTouchDown) return super.onTouchEvent(motionEvent);
        this.mIsTouchDown = false;
        return bl;
    }

    public void setAdapter(ListAdapter listAdapter) {
        super.setAdapter(listAdapter);
        this.mAdapter = (PinnedHeaderListAdapter)listAdapter;
    }

    public void setEnabledPinnedHeaderDynamicAlphaEffect(boolean bl) {
        this.mEnabledDynamicAlphaEffect = bl;
    }

    public void setForceHeaderViewVisible(boolean bl) {
        this.forceHeaderViewVisible = bl;
    }

    public void setPinnedHeaderView(View view) {
        if (Build.VERSION.SDK_INT >= 8) {
            this.mHeaderView = view;
            if (this.mHeaderView != null) {
                this.setFadingEdgeLength(0);
            }
            this.requestLayout();
        }
    }

    public void setSearchAdapter(ListAdapter listAdapter) {
        super.setAdapter(listAdapter);
    }

    public void setSelection(int n2) {
        this.smoothScrollBy(0, 0);
        super.setSelection(n2);
    }

    public static interface PinnedHeaderListAdapter {
        public static final int PINNED_HEADER_GONE = 0;
        public static final int PINNED_HEADER_PUSHED_UP = 2;
        public static final int PINNED_HEADER_VISIBLE = 1;

        public void configurePinnedHeader(View var1, int var2, int var3);

        public int getPinnedHeaderState(int var1);
    }
}

