/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.view.NetworkImageView;
import com.common.gmacs.parse.talk.Talk;
import com.common.gmacs.utils.ImageUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

public class ConversationListAdapter
extends BaseAdapter {
    private Context context;
    private LayoutInflater li;
    private SimpleDateFormat mSimpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
    protected ArrayList<Talk> talkList;

    public ConversationListAdapter(Context context, ArrayList<Talk> arrayList) {
        this.context = context;
        this.li = LayoutInflater.from((Context)context);
        this.talkList = arrayList;
    }

    protected int defaultAvatarRes(int n2) {
        return R.drawable.gmacs_ic_default_avatar;
    }

    protected String defaultName() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCount() {
        if (this.talkList != null) return this.talkList.size();
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getItem(int n2) {
        if (this.talkList == null) return null;
        return this.talkList.get(n2);
    }

    public long getItemId(int n2) {
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getSendStateImageSrcId(Talk talk) {
        int n2 = -1;
        if (!TextUtils.isEmpty((CharSequence)talk.mDraftBoxMsg)) {
            return n2;
        }
        int n3 = n2;
        if (talk.getmLastMessage() == null) return n3;
        n3 = n2;
        if (talk.getmLastMessage().mMsgDetail == null) return n3;
        n3 = n2;
        if (!talk.getmLastMessage().mMsgDetail.mIsSelfSendMsg) return n3;
        if (talk.getmLastMessage().mMsgDetail.isMsgSending()) {
            return R.drawable.gmacs_ic_msg_sending_state;
        }
        n3 = n2;
        if (!talk.getmLastMessage().mMsgDetail.isMsgSendFailed()) return n3;
        return R.drawable.gmacs_ic_msg_sended_failed;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View getView(int n2, View view, ViewGroup object) {
        if (view == null) {
            view = this.li.inflate(R.layout.gmacs_conversation_list_item, null);
            object = new ViewHolder();
            ((ViewHolder)object).iv_user_avatar = (NetworkImageView)view.findViewById(R.id.iv_avatar);
            ((ViewHolder)object).tv_name = (TextView)view.findViewById(R.id.tv_conversation_name);
            ((ViewHolder)object).iv_msg_status = (ImageView)view.findViewById(R.id.iv_conversation_msg_status);
            ((ViewHolder)object).tv_msg_text = (TextView)view.findViewById(R.id.tv_conversation_msg_text);
            ((ViewHolder)object).tv_msg_time = (TextView)view.findViewById(R.id.tv_conversation_msg_time);
            ((ViewHolder)object).tv_msg_count = (TextView)view.findViewById(R.id.tv_conversation_msg_count);
            ((ViewHolder)object).v_divider = view.findViewById(R.id.v_conversation_divider);
            ((ViewHolder)object).other_info_layout = view.findViewById(R.id.conversation_list_other_info);
            view.setTag(object);
            view.setTag(R.id.conversation_list_other_info, (Object)true);
        } else {
            object = (ViewHolder)view.getTag();
            view.setTag(R.id.conversation_list_other_info, (Object)false);
        }
        ((ViewHolder)object).onBind(n2, this.talkList.get(n2));
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String messageTimeFormat(long l2) {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(6);
        int n5 = calendar.get(4);
        calendar.setTimeInMillis(l2);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        int n6 = calendar.get(1);
        int n7 = calendar.get(2);
        int n8 = calendar.get(6);
        int n9 = calendar.get(4);
        if (n2 == n6) {
            if ((n8 = n4 - n8) == 0) {
                this.mSimpleDateFormat.applyPattern("HH:mm");
                return this.mSimpleDateFormat.format(calendar.getTime());
            }
            if (n8 == 1) {
                return "\u6628\u5929";
            }
            if ((n9 - 1 == n5 - 1 || n3 - n7 == 1) && n8 < 7) {
                n5 = calendar.get(7) - 1;
                if (n5 >= 0) {
                    return (new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"})[n5];
                }
                n5 = 0;
                return (new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"})[n5];
            }
            this.mSimpleDateFormat.applyPattern("MM-dd");
            return this.mSimpleDateFormat.format(calendar.getTime());
        }
        this.mSimpleDateFormat.applyPattern("yyyy-MM-dd");
        return this.mSimpleDateFormat.format(calendar.getTime());
    }

    protected class ViewHolder {
        public ImageView iv_msg_status;
        public NetworkImageView iv_user_avatar;
        public View other_info_layout;
        public TextView tv_msg_count;
        public TextView tv_msg_text;
        public TextView tv_msg_time;
        public TextView tv_name;
        public View v_divider;

        protected ViewHolder() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onBind(int n2, Talk talk) {
            String string2 = talk.mTalkOtherUserAvatar;
            this.iv_user_avatar.setDefaultImageResId(ConversationListAdapter.this.defaultAvatarRes(talk.mTalkOtherGender)).setErrorImageResId(ConversationListAdapter.this.defaultAvatarRes(talk.mTalkOtherGender)).setImageUrl(ImageUtil.makeUpUrl((String)string2, (int)NetworkImageView.IMG_RESIZE, (int)NetworkImageView.IMG_RESIZE));
            this.tv_name.setText((CharSequence)talk.getOtherName(ConversationListAdapter.this.defaultName()));
            int n3 = ConversationListAdapter.this.getSendStateImageSrcId(talk);
            if (n3 != -1) {
                this.iv_msg_status.setVisibility(0);
                this.iv_msg_status.setImageResource(n3);
            } else {
                this.iv_msg_status.setVisibility(8);
            }
            this.tv_msg_text.setText((CharSequence)talk.getNewestMsgContent(ConversationListAdapter.this.context));
            this.tv_msg_time.setText((CharSequence)ConversationListAdapter.this.messageTimeFormat(talk.getTalkUpdatetime()));
            if (talk.mNoReadMsgCount > 99) {
                this.tv_msg_count.setText((CharSequence)"99+");
                this.tv_msg_count.setVisibility(0);
            } else if (talk.mNoReadMsgCount <= 0) {
                this.tv_msg_count.setVisibility(8);
            } else {
                this.tv_msg_count.setText((CharSequence)String.valueOf(talk.mNoReadMsgCount));
                this.tv_msg_count.setVisibility(0);
            }
            if (n2 == ConversationListAdapter.this.talkList.size() - 1) {
                this.v_divider.setBackgroundResource(R.color.transparent);
                return;
            }
            this.v_divider.setBackgroundResource(R.color.conversation_list_divider);
        }
    }
}

