/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.support.v7.widget.RecyclerView;
import android.view.View;

public abstract class OrientationHelper {
    public static final int HORIZONTAL = 0;
    private static final int INVALID_SIZE = Integer.MIN_VALUE;
    public static final int VERTICAL = 1;
    private int mLastTotalSpace = Integer.MIN_VALUE;
    protected final RecyclerView.LayoutManager mLayoutManager;

    private OrientationHelper(RecyclerView.LayoutManager layoutManager) {
        this.mLayoutManager = layoutManager;
    }

    public static OrientationHelper createHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        return new OrientationHelper(layoutManager){

            @Override
            public int getDecoratedEnd(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                int n2 = this.mLayoutManager.getDecoratedRight(view);
                return layoutParams.rightMargin + n2;
            }

            @Override
            public int getDecoratedMeasurement(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                int n2 = this.mLayoutManager.getDecoratedMeasuredWidth(view);
                int n3 = layoutParams.leftMargin;
                return layoutParams.rightMargin + (n2 + n3);
            }

            @Override
            public int getDecoratedMeasurementInOther(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                int n2 = this.mLayoutManager.getDecoratedMeasuredHeight(view);
                int n3 = layoutParams.topMargin;
                return layoutParams.bottomMargin + (n2 + n3);
            }

            @Override
            public int getDecoratedStart(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return this.mLayoutManager.getDecoratedLeft(view) - layoutParams.leftMargin;
            }

            @Override
            public int getEnd() {
                return this.mLayoutManager.getWidth();
            }

            @Override
            public int getEndAfterPadding() {
                return this.mLayoutManager.getWidth() - this.mLayoutManager.getPaddingRight();
            }

            @Override
            public int getEndPadding() {
                return this.mLayoutManager.getPaddingRight();
            }

            @Override
            public int getMode() {
                return this.mLayoutManager.getWidthMode();
            }

            @Override
            public int getModeInOther() {
                return this.mLayoutManager.getHeightMode();
            }

            @Override
            public int getStartAfterPadding() {
                return this.mLayoutManager.getPaddingLeft();
            }

            @Override
            public int getTotalSpace() {
                return this.mLayoutManager.getWidth() - this.mLayoutManager.getPaddingLeft() - this.mLayoutManager.getPaddingRight();
            }

            @Override
            public void offsetChild(View view, int n2) {
                view.offsetLeftAndRight(n2);
            }

            @Override
            public void offsetChildren(int n2) {
                this.mLayoutManager.offsetChildrenHorizontal(n2);
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OrientationHelper createOrientationHelper(RecyclerView.LayoutManager object, int n2) {
        void var0_2;
        void var1_4;
        switch (var1_4) {
            default: {
                throw new IllegalArgumentException("invalid orientation");
            }
            case 0: {
                OrientationHelper orientationHelper = OrientationHelper.createHorizontalHelper(object);
                return var0_2;
            }
            case 1: 
        }
        OrientationHelper orientationHelper = OrientationHelper.createVerticalHelper(object);
        return var0_2;
    }

    public static OrientationHelper createVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        return new OrientationHelper(layoutManager){

            @Override
            public int getDecoratedEnd(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                int n2 = this.mLayoutManager.getDecoratedBottom(view);
                return layoutParams.bottomMargin + n2;
            }

            @Override
            public int getDecoratedMeasurement(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                int n2 = this.mLayoutManager.getDecoratedMeasuredHeight(view);
                int n3 = layoutParams.topMargin;
                return layoutParams.bottomMargin + (n2 + n3);
            }

            @Override
            public int getDecoratedMeasurementInOther(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                int n2 = this.mLayoutManager.getDecoratedMeasuredWidth(view);
                int n3 = layoutParams.leftMargin;
                return layoutParams.rightMargin + (n2 + n3);
            }

            @Override
            public int getDecoratedStart(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return this.mLayoutManager.getDecoratedTop(view) - layoutParams.topMargin;
            }

            @Override
            public int getEnd() {
                return this.mLayoutManager.getHeight();
            }

            @Override
            public int getEndAfterPadding() {
                return this.mLayoutManager.getHeight() - this.mLayoutManager.getPaddingBottom();
            }

            @Override
            public int getEndPadding() {
                return this.mLayoutManager.getPaddingBottom();
            }

            @Override
            public int getMode() {
                return this.mLayoutManager.getHeightMode();
            }

            @Override
            public int getModeInOther() {
                return this.mLayoutManager.getWidthMode();
            }

            @Override
            public int getStartAfterPadding() {
                return this.mLayoutManager.getPaddingTop();
            }

            @Override
            public int getTotalSpace() {
                return this.mLayoutManager.getHeight() - this.mLayoutManager.getPaddingTop() - this.mLayoutManager.getPaddingBottom();
            }

            @Override
            public void offsetChild(View view, int n2) {
                view.offsetTopAndBottom(n2);
            }

            @Override
            public void offsetChildren(int n2) {
                this.mLayoutManager.offsetChildrenVertical(n2);
            }
        };
    }

    public abstract int getDecoratedEnd(View var1);

    public abstract int getDecoratedMeasurement(View var1);

    public abstract int getDecoratedMeasurementInOther(View var1);

    public abstract int getDecoratedStart(View var1);

    public abstract int getEnd();

    public abstract int getEndAfterPadding();

    public abstract int getEndPadding();

    public abstract int getMode();

    public abstract int getModeInOther();

    public abstract int getStartAfterPadding();

    public abstract int getTotalSpace();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTotalSpaceChange() {
        if (Integer.MIN_VALUE != this.mLastTotalSpace) return this.getTotalSpace() - this.mLastTotalSpace;
        return 0;
    }

    public abstract void offsetChild(View var1, int var2);

    public abstract void offsetChildren(int var1);

    public void onLayoutComplete() {
        this.mLastTotalSpace = this.getTotalSpace();
    }
}

