/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.DataSetObserver;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.TintableBackgroundView;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.view.ContextThemeWrapper;
import android.support.v7.widget.AppCompatBackgroundHelper;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.ListPopupWindow;
import android.support.v7.widget.ThemedSpinnerAdapter;
import android.support.v7.widget.TintTypedArray;
import android.support.v7.widget.ViewUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;

public class AppCompatSpinner
extends Spinner
implements TintableBackgroundView {
    private static final int[] ATTRS_ANDROID_SPINNERMODE;
    private static final boolean IS_AT_LEAST_JB;
    private static final boolean IS_AT_LEAST_M;
    private static final int MAX_ITEMS_MEASURED = 15;
    private static final int MODE_DIALOG = 0;
    private static final int MODE_DROPDOWN = 1;
    private static final int MODE_THEME = -1;
    private static final String TAG = "AppCompatSpinner";
    private AppCompatBackgroundHelper mBackgroundTintHelper;
    private AppCompatDrawableManager mDrawableManager;
    private int mDropDownWidth;
    private ListPopupWindow.ForwardingListener mForwardingListener;
    private DropdownPopup mPopup;
    private Context mPopupContext;
    private boolean mPopupSet;
    private SpinnerAdapter mTempAdapter;
    private final Rect mTempRect;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = Build.VERSION.SDK_INT >= 23;
        IS_AT_LEAST_M = bl;
        bl = Build.VERSION.SDK_INT >= 16;
        IS_AT_LEAST_JB = bl;
        ATTRS_ANDROID_SPINNERMODE = new int[]{16843505};
    }

    public AppCompatSpinner(Context context) {
        this(context, null);
    }

    public AppCompatSpinner(Context context, int n2) {
        this(context, null, R.attr.spinnerStyle, n2);
    }

    public AppCompatSpinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.spinnerStyle);
    }

    public AppCompatSpinner(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet, n2, -1);
    }

    public AppCompatSpinner(Context context, AttributeSet attributeSet, int n2, int n3) {
        this(context, attributeSet, n2, n3, null);
    }

    /*
     * Unable to fully structure code
     */
    public AppCompatSpinner(Context var1_1, AttributeSet var2_5, int var3_6, int var4_7, Resources.Theme var5_8) {
        block20: {
            block23: {
                block22: {
                    super(var1_1, var2_5, var3_6);
                    this.mTempRect = new Rect();
                    var6_9 = TintTypedArray.obtainStyledAttributes((Context)var1_1, (AttributeSet)var2_5, (int[])R.styleable.Spinner, (int)var3_6, (int)0);
                    this.mDrawableManager = AppCompatDrawableManager.get();
                    this.mBackgroundTintHelper = new AppCompatBackgroundHelper((View)this, this.mDrawableManager);
                    if (var5_8 == null) break block22;
                    this.mPopupContext = new ContextThemeWrapper(var1_1, (Resources.Theme)var5_8);
lbl8:
                    // 3 sources

                    while (true) {
                        if (this.mPopupContext == null) ** GOTO lbl37
                        var7_10 = var4_7;
                        if (var4_7 == -1) {
                            block21: {
                                if (Build.VERSION.SDK_INT < 11) break block20;
                                var8_11 = var1_1.obtainStyledAttributes(var2_5, AppCompatSpinner.ATTRS_ANDROID_SPINNERMODE, var3_6, 0);
                                var9_12 = var4_7;
                                var5_8 = var8_11;
                                if (!var8_11.hasValue(0)) break block21;
                                var5_8 = var8_11;
                                var9_12 = var8_11.getInt(0, 0);
                            }
                            var7_10 = var9_12;
                            if (var8_11 != null) {
                                var8_11.recycle();
                                var7_10 = var9_12;
                            }
                        }
lbl27:
                        // 8 sources

                        while (true) {
                            if (var7_10 == 1) {
                                var8_11 = new DropdownPopup(this.mPopupContext, var2_5, var3_6);
                                var5_8 = TintTypedArray.obtainStyledAttributes((Context)this.mPopupContext, (AttributeSet)var2_5, (int[])R.styleable.Spinner, (int)var3_6, (int)0);
                                this.mDropDownWidth = var5_8.getLayoutDimension(R.styleable.Spinner_android_dropDownWidth, -2);
                                var8_11.setBackgroundDrawable(var5_8.getDrawable(R.styleable.Spinner_android_popupBackground));
                                var8_11.setPromptText(var6_9.getString(R.styleable.Spinner_android_prompt));
                                var5_8.recycle();
                                this.mPopup = var8_11;
                                this.mForwardingListener = new ListPopupWindow.ForwardingListener((View)this, (DropdownPopup)var8_11){
                                    final /* synthetic */ DropdownPopup val$popup;
                                    {
                                        this.val$popup = dropdownPopup;
                                        super(view);
                                    }

                                    @Override
                                    public ListPopupWindow getPopup() {
                                        return this.val$popup;
                                    }

                                    @Override
                                    public boolean onForwardingStarted() {
                                        if (!AppCompatSpinner.this.mPopup.isShowing()) {
                                            AppCompatSpinner.this.mPopup.show();
                                        }
                                        return true;
                                    }
                                };
                            }
lbl37:
                            // 4 sources

                            if ((var5_8 = var6_9.getTextArray(R.styleable.Spinner_android_entries)) != null) {
                                var1_1 = new ArrayAdapter(var1_1, 17367048, (Object[])var5_8);
                                var1_1.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
                                this.setAdapter((SpinnerAdapter)var1_1);
                            }
                            var6_9.recycle();
                            this.mPopupSet = true;
                            if (this.mTempAdapter != null) {
                                this.setAdapter(this.mTempAdapter);
                                this.mTempAdapter = null;
                            }
                            this.mBackgroundTintHelper.loadFromAttributes(var2_5, var3_6);
                            return;
                        }
                        break;
                    }
                }
                var7_10 = var6_9.getResourceId(R.styleable.Spinner_popupTheme, 0);
                if (var7_10 == 0) break block23;
                this.mPopupContext = new ContextThemeWrapper(var1_1, var7_10);
                ** GOTO lbl8
            }
            if (!AppCompatSpinner.IS_AT_LEAST_M) {
                var5_8 = var1_1;
lbl56:
                // 2 sources

                while (true) {
                    this.mPopupContext = var5_8;
                    ** continue;
                    break;
                }
            }
            var5_8 = null;
            ** while (true)
            catch (Exception var10_13) {
                var8_11 = null;
lbl63:
                // 2 sources

                while (true) {
                    var5_8 = var8_11;
                    Log.i((String)"AppCompatSpinner", (String)"Could not read android:spinnerMode", (Throwable)var10_14);
                    var7_10 = var4_7;
                    if (var8_11 == null) ** GOTO lbl27
                    var8_11.recycle();
                    var7_10 = var4_7;
                    break;
                }
            }
            catch (Throwable var1_2) {
                var5_8 = null;
lbl75:
                // 2 sources

                while (true) {
                    if (var5_8 != null) {
                        var5_8.recycle();
                    }
                    throw var1_3;
                }
            }
        }
        var7_10 = 1;
        ** while (true)
        {
            catch (Throwable var1_4) {
                ** continue;
            }
        }
        catch (Exception var10_15) {
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int compatMeasureContentWidth(SpinnerAdapter spinnerAdapter, Drawable drawable2) {
        int n2 = 0;
        if (spinnerAdapter == null) {
            return n2;
        }
        int n3 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0);
        int n4 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0);
        n2 = Math.max(0, this.getSelectedItemPosition());
        int n5 = Math.min(spinnerAdapter.getCount(), n2 + 15);
        int n6 = Math.max(0, n2 - (15 - (n5 - n2)));
        View view = null;
        n2 = 0;
        int n7 = 0;
        while (n6 < n5) {
            int n8 = spinnerAdapter.getItemViewType(n6);
            if (n8 != n7) {
                view = null;
                n7 = n8;
            }
            if ((view = spinnerAdapter.getView(n6, view, (ViewGroup)this)).getLayoutParams() == null) {
                view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            view.measure(n3, n4);
            n2 = Math.max(n2, view.getMeasuredWidth());
            ++n6;
        }
        if (drawable2 == null) return n2;
        drawable2.getPadding(this.mTempRect);
        return this.mTempRect.left + this.mTempRect.right + n2;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySupportBackgroundTint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDropDownHorizontalOffset() {
        if (this.mPopup != null) {
            return this.mPopup.getHorizontalOffset();
        }
        if (!IS_AT_LEAST_JB) return 0;
        return super.getDropDownHorizontalOffset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDropDownVerticalOffset() {
        if (this.mPopup != null) {
            return this.mPopup.getVerticalOffset();
        }
        if (!IS_AT_LEAST_JB) return 0;
        return super.getDropDownVerticalOffset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDropDownWidth() {
        if (this.mPopup != null) {
            return this.mDropDownWidth;
        }
        if (!IS_AT_LEAST_JB) return 0;
        return super.getDropDownWidth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getPopupBackground() {
        if (this.mPopup != null) {
            return this.mPopup.getBackground();
        }
        if (!IS_AT_LEAST_JB) return null;
        return super.getPopupBackground();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Context getPopupContext() {
        if (this.mPopup != null) {
            return this.mPopupContext;
        }
        if (!IS_AT_LEAST_M) return null;
        return super.getPopupContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getPrompt() {
        if (this.mPopup == null) return super.getPrompt();
        return this.mPopup.getHintText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ColorStateList getSupportBackgroundTintList() {
        if (this.mBackgroundTintHelper == null) return null;
        return this.mBackgroundTintHelper.getSupportBackgroundTintList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PorterDuff.Mode getSupportBackgroundTintMode() {
        if (this.mBackgroundTintHelper == null) return null;
        return this.mBackgroundTintHelper.getSupportBackgroundTintMode();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        if (this.mPopup != null && View.MeasureSpec.getMode((int)n2) == Integer.MIN_VALUE) {
            this.setMeasuredDimension(Math.min(Math.max(this.getMeasuredWidth(), this.compatMeasureContentWidth(this.getAdapter(), this.getBackground())), View.MeasureSpec.getSize((int)n2)), this.getMeasuredHeight());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mForwardingListener == null) return super.onTouchEvent(motionEvent);
        if (!this.mForwardingListener.onTouch((View)this, motionEvent)) return super.onTouchEvent(motionEvent);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performClick() {
        if (this.mPopup == null) return super.performClick();
        if (this.mPopup.isShowing()) return true;
        this.mPopup.show();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        if (!this.mPopupSet) {
            this.mTempAdapter = spinnerAdapter;
            return;
        }
        super.setAdapter(spinnerAdapter);
        if (this.mPopup == null) return;
        Context context = this.mPopupContext == null ? this.getContext() : this.mPopupContext;
        this.mPopup.setAdapter(new DropDownAdapter(spinnerAdapter, context.getTheme()));
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        super.setBackgroundDrawable(drawable2);
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.onSetBackgroundDrawable(drawable2);
        }
    }

    public void setBackgroundResource(@DrawableRes int n2) {
        super.setBackgroundResource(n2);
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.onSetBackgroundResource(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDropDownHorizontalOffset(int n2) {
        if (this.mPopup != null) {
            this.mPopup.setHorizontalOffset(n2);
            return;
        }
        if (!IS_AT_LEAST_JB) return;
        super.setDropDownHorizontalOffset(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDropDownVerticalOffset(int n2) {
        if (this.mPopup != null) {
            this.mPopup.setVerticalOffset(n2);
            return;
        }
        if (!IS_AT_LEAST_JB) return;
        super.setDropDownVerticalOffset(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDropDownWidth(int n2) {
        if (this.mPopup != null) {
            this.mDropDownWidth = n2;
            return;
        }
        if (!IS_AT_LEAST_JB) return;
        super.setDropDownWidth(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPopupBackgroundDrawable(Drawable drawable2) {
        if (this.mPopup != null) {
            this.mPopup.setBackgroundDrawable(drawable2);
            return;
        }
        if (!IS_AT_LEAST_JB) return;
        super.setPopupBackgroundDrawable(drawable2);
    }

    public void setPopupBackgroundResource(@DrawableRes int n2) {
        this.setPopupBackgroundDrawable(ContextCompat.getDrawable((Context)this.getPopupContext(), (int)n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPrompt(CharSequence charSequence) {
        if (this.mPopup != null) {
            this.mPopup.setPromptText(charSequence);
            return;
        }
        super.setPrompt(charSequence);
    }

    public void setSupportBackgroundTintList(@Nullable ColorStateList colorStateList) {
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.setSupportBackgroundTintList(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(@Nullable PorterDuff.Mode mode) {
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.setSupportBackgroundTintMode(mode);
        }
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        /*
         * Enabled aggressive block sorting
         */
        public DropDownAdapter(@Nullable SpinnerAdapter spinnerAdapter, @Nullable Resources.Theme theme) {
            this.mAdapter = spinnerAdapter;
            if (spinnerAdapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)spinnerAdapter;
            }
            if (theme == null) return;
            if (IS_AT_LEAST_M && spinnerAdapter instanceof android.widget.ThemedSpinnerAdapter) {
                if ((spinnerAdapter = (android.widget.ThemedSpinnerAdapter)spinnerAdapter).getDropDownViewTheme() == theme) return;
                spinnerAdapter.setDropDownViewTheme(theme);
                return;
            }
            if (!(spinnerAdapter instanceof ThemedSpinnerAdapter)) return;
            if ((spinnerAdapter = (ThemedSpinnerAdapter)spinnerAdapter).getDropDownViewTheme() != null) return;
            spinnerAdapter.setDropDownViewTheme(theme);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean areAllItemsEnabled() {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter == null) return true;
            return listAdapter.areAllItemsEnabled();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getCount() {
            if (this.mAdapter != null) return this.mAdapter.getCount();
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public View getDropDownView(int n2, View view, ViewGroup viewGroup) {
            if (this.mAdapter != null) return this.mAdapter.getDropDownView(n2, view, viewGroup);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getItem(int n2) {
            if (this.mAdapter != null) return this.mAdapter.getItem(n2);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long getItemId(int n2) {
            if (this.mAdapter != null) return this.mAdapter.getItemId(n2);
            return -1L;
        }

        public int getItemViewType(int n2) {
            return 0;
        }

        public View getView(int n2, View view, ViewGroup viewGroup) {
            return this.getDropDownView(n2, view, viewGroup);
        }

        public int getViewTypeCount() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasStableIds() {
            if (this.mAdapter == null) return false;
            if (!this.mAdapter.hasStableIds()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEmpty() {
            if (this.getCount() != 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEnabled(int n2) {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter == null) return true;
            return listAdapter.isEnabled(n2);
        }

        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(dataSetObserver);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(dataSetObserver);
            }
        }
    }

    private class DropdownPopup
    extends ListPopupWindow {
        private ListAdapter mAdapter;
        private CharSequence mHintText;
        private final Rect mVisibleRect;

        public DropdownPopup(Context context, AttributeSet attributeSet, int n2) {
            super(context, attributeSet, n2);
            this.mVisibleRect = new Rect();
            this.setAnchorView((View)AppCompatSpinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                    AppCompatSpinner.this.setSelection(n2);
                    if (AppCompatSpinner.this.getOnItemClickListener() != null) {
                        AppCompatSpinner.this.performItemClick(view, n2, DropdownPopup.this.mAdapter.getItemId(n2));
                    }
                    DropdownPopup.this.dismiss();
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isVisibleToUser(View view) {
            if (!ViewCompat.isAttachedToWindow((View)view)) return false;
            if (!view.getGlobalVisibleRect(this.mVisibleRect)) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void computeContentWidth() {
            int n2;
            Drawable drawable2 = this.getBackground();
            if (drawable2 != null) {
                drawable2.getPadding(AppCompatSpinner.this.mTempRect);
                n2 = ViewUtils.isLayoutRtl((View)AppCompatSpinner.this) ? ((AppCompatSpinner)AppCompatSpinner.this).mTempRect.right : -((AppCompatSpinner)AppCompatSpinner.this).mTempRect.left;
            } else {
                drawable2 = AppCompatSpinner.this.mTempRect;
                ((AppCompatSpinner)AppCompatSpinner.this).mTempRect.right = 0;
                drawable2.left = 0;
                n2 = 0;
            }
            int n3 = AppCompatSpinner.this.getPaddingLeft();
            int n4 = AppCompatSpinner.this.getPaddingRight();
            int n5 = AppCompatSpinner.this.getWidth();
            if (AppCompatSpinner.this.mDropDownWidth == -2) {
                int n6;
                int n7 = AppCompatSpinner.this.compatMeasureContentWidth((SpinnerAdapter)this.mAdapter, this.getBackground());
                if (n7 > (n6 = AppCompatSpinner.this.getContext().getResources().getDisplayMetrics().widthPixels - ((AppCompatSpinner)AppCompatSpinner.this).mTempRect.left - ((AppCompatSpinner)AppCompatSpinner.this).mTempRect.right)) {
                    n7 = n6;
                }
                this.setContentWidth(Math.max(n7, n5 - n3 - n4));
            } else if (AppCompatSpinner.this.mDropDownWidth == -1) {
                this.setContentWidth(n5 - n3 - n4);
            } else {
                this.setContentWidth(AppCompatSpinner.this.mDropDownWidth);
            }
            n2 = ViewUtils.isLayoutRtl((View)AppCompatSpinner.this) ? n5 - n4 - this.getWidth() + n2 : (n2 += n3);
            this.setHorizontalOffset(n2);
        }

        public CharSequence getHintText() {
            return this.mHintText;
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            super.setAdapter(listAdapter);
            this.mAdapter = listAdapter;
        }

        public void setPromptText(CharSequence charSequence) {
            this.mHintText = charSequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void show() {
            boolean bl = this.isShowing();
            this.computeContentWidth();
            this.setInputMethodMode(2);
            super.show();
            this.getListView().setChoiceMode(1);
            this.setSelection(AppCompatSpinner.this.getSelectedItemPosition());
            if (bl) {
                return;
            }
            ViewTreeObserver viewTreeObserver = AppCompatSpinner.this.getViewTreeObserver();
            if (viewTreeObserver == null) return;
            final ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onGlobalLayout() {
                    if (!DropdownPopup.this.isVisibleToUser((View)AppCompatSpinner.this)) {
                        DropdownPopup.this.dismiss();
                        return;
                    }
                    DropdownPopup.this.computeContentWidth();
                    DropdownPopup.super.show();
                }
            };
            viewTreeObserver.addOnGlobalLayoutListener(onGlobalLayoutListener);
            this.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    ViewTreeObserver viewTreeObserver = AppCompatSpinner.this.getViewTreeObserver();
                    if (viewTreeObserver != null) {
                        viewTreeObserver.removeGlobalOnLayoutListener(onGlobalLayoutListener);
                    }
                }
            });
        }
    }
}

