/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Shader;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.support.v4.graphics.drawable.DrawableWrapper;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.ProgressBar;

class AppCompatProgressBarHelper {
    private static final int[] TINT_ATTRS = new int[]{16843067, 16843068};
    final AppCompatDrawableManager mDrawableManager;
    private Bitmap mSampleTile;
    private final ProgressBar mView;

    AppCompatProgressBarHelper(ProgressBar progressBar, AppCompatDrawableManager appCompatDrawableManager) {
        this.mView = progressBar;
        this.mDrawableManager = appCompatDrawableManager;
    }

    private Shape getDrawableShape() {
        return new RoundRectShape(new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f}, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable tileify(Drawable shapeDrawable, boolean bl) {
        LayerDrawable layerDrawable;
        int n2;
        int n3;
        LayerDrawable layerDrawable2;
        int n4 = 0;
        if (shapeDrawable instanceof DrawableWrapper) {
            Drawable drawable2 = ((DrawableWrapper)shapeDrawable).getWrappedDrawable();
            if (drawable2 == null) return shapeDrawable;
            drawable2 = this.tileify(drawable2, bl);
            ((DrawableWrapper)shapeDrawable).setWrappedDrawable(drawable2);
            return shapeDrawable;
        }
        if (shapeDrawable instanceof LayerDrawable) {
            layerDrawable2 = (LayerDrawable)shapeDrawable;
            n3 = layerDrawable2.getNumberOfLayers();
            shapeDrawable = new Drawable[n3];
        } else {
            if (!(shapeDrawable instanceof BitmapDrawable)) return shapeDrawable;
            BitmapDrawable bitmapDrawable = (BitmapDrawable)shapeDrawable;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            if (this.mSampleTile == null) {
                this.mSampleTile = bitmap;
            }
            shapeDrawable = new ShapeDrawable(this.getDrawableShape());
            bitmap = new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            shapeDrawable.getPaint().setShader((Shader)bitmap);
            shapeDrawable.getPaint().setColorFilter(bitmapDrawable.getPaint().getColorFilter());
            if (!bl) return shapeDrawable;
            return new ClipDrawable((Drawable)shapeDrawable, 3, 1);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = layerDrawable2.getId(n2);
            layerDrawable = layerDrawable2.getDrawable(n2);
            bl = n5 == 16908301 || n5 == 16908303;
            shapeDrawable[n2] = this.tileify((Drawable)layerDrawable, bl);
        }
        layerDrawable = new LayerDrawable((Drawable[])shapeDrawable);
        n2 = n4;
        while (true) {
            shapeDrawable = layerDrawable;
            if (n2 >= n3) return shapeDrawable;
            layerDrawable.setId(n2, layerDrawable2.getId(n2));
            ++n2;
        }
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        Drawable drawable3 = drawable2;
        if (drawable2 instanceof AnimationDrawable) {
            drawable2 = (AnimationDrawable)drawable2;
            int n2 = drawable2.getNumberOfFrames();
            drawable3 = new AnimationDrawable();
            drawable3.setOneShot(drawable2.isOneShot());
            for (int i2 = 0; i2 < n2; ++i2) {
                Drawable drawable4 = this.tileify(drawable2.getFrame(i2), true);
                drawable4.setLevel(10000);
                drawable3.addFrame(drawable4, drawable2.getDuration(i2));
            }
            drawable3.setLevel(10000);
        }
        return drawable3;
    }

    Bitmap getSampleTime() {
        return this.mSampleTile;
    }

    void loadFromAttributes(AttributeSet attributeSet, int n2) {
        attributeSet = TintTypedArray.obtainStyledAttributes((Context)this.mView.getContext(), (AttributeSet)attributeSet, (int[])TINT_ATTRS, (int)n2, (int)0);
        Drawable drawable2 = attributeSet.getDrawableIfKnown(0);
        if (drawable2 != null) {
            this.mView.setIndeterminateDrawable(this.tileifyIndeterminate(drawable2));
        }
        if ((drawable2 = attributeSet.getDrawableIfKnown(1)) != null) {
            this.mView.setProgressDrawable(this.tileify(drawable2, false));
        }
        attributeSet.recycle();
    }
}

