/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.DrawableUtils;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;

public class AppCompatImageHelper {
    private final AppCompatDrawableManager mDrawableManager;
    private final ImageView mView;

    public AppCompatImageHelper(ImageView imageView, AppCompatDrawableManager appCompatDrawableManager) {
        this.mView = imageView;
        this.mDrawableManager = appCompatDrawableManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromAttributes(AttributeSet attributeSet, int n2) {
        attributeSet = TintTypedArray.obtainStyledAttributes((Context)this.mView.getContext(), (AttributeSet)attributeSet, (int[])R.styleable.AppCompatImageView, (int)n2, (int)0);
        try {
            Drawable drawable2 = attributeSet.getDrawableIfKnown(R.styleable.AppCompatImageView_android_src);
            if (drawable2 != null) {
                this.mView.setImageDrawable(drawable2);
            }
            if ((n2 = attributeSet.getResourceId(R.styleable.AppCompatImageView_srcCompat, -1)) != -1 && (drawable2 = this.mDrawableManager.getDrawable(this.mView.getContext(), n2)) != null) {
                this.mView.setImageDrawable(drawable2);
            }
            if ((drawable2 = this.mView.getDrawable()) == null) return;
            DrawableUtils.fixDrawable(drawable2);
            return;
        }
        finally {
            attributeSet.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setImageResource(int n2) {
        if (n2 == 0) {
            this.mView.setImageDrawable(null);
            return;
        }
        Drawable drawable2 = this.mDrawableManager != null ? this.mDrawableManager.getDrawable(this.mView.getContext(), n2) : ContextCompat.getDrawable((Context)this.mView.getContext(), (int)n2);
        if (drawable2 != null) {
            DrawableUtils.fixDrawable(drawable2);
        }
        this.mView.setImageDrawable(drawable2);
    }
}

