/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.DataSetObservable;
import android.os.AsyncTask;
import android.support.v4.os.AsyncTaskCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

class ActivityChooserModel
extends DataSetObservable {
    private static final String ATTRIBUTE_ACTIVITY = "activity";
    private static final String ATTRIBUTE_TIME = "time";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_ACTIVITY_INFLATION = 5;
    private static final float DEFAULT_HISTORICAL_RECORD_WEIGHT = 1.0f;
    public static final String DEFAULT_HISTORY_FILE_NAME = "activity_choser_model_history.xml";
    public static final int DEFAULT_HISTORY_MAX_LENGTH = 50;
    private static final String HISTORY_FILE_EXTENSION = ".xml";
    private static final int INVALID_INDEX = -1;
    private static final String LOG_TAG = ActivityChooserModel.class.getSimpleName();
    private static final String TAG_HISTORICAL_RECORD = "historical-record";
    private static final String TAG_HISTORICAL_RECORDS = "historical-records";
    private static final Map<String, ActivityChooserModel> sDataModelRegistry;
    private static final Object sRegistryLock;
    private final List<ActivityResolveInfo> mActivities;
    private OnChooseActivityListener mActivityChoserModelPolicy;
    private ActivitySorter mActivitySorter;
    private boolean mCanReadHistoricalData = true;
    private final Context mContext;
    private final List<HistoricalRecord> mHistoricalRecords;
    private boolean mHistoricalRecordsChanged = true;
    private final String mHistoryFileName;
    private int mHistoryMaxSize = 50;
    private final Object mInstanceLock = new Object();
    private Intent mIntent;
    private boolean mReadShareHistoryCalled = false;
    private boolean mReloadActivities = false;

    static {
        sRegistryLock = new Object();
        sDataModelRegistry = new HashMap<String, ActivityChooserModel>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ActivityChooserModel(Context context, String string2) {
        this.mActivities = new ArrayList<ActivityResolveInfo>();
        this.mHistoricalRecords = new ArrayList<HistoricalRecord>();
        this.mActivitySorter = new DefaultSorter();
        this.mContext = context.getApplicationContext();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.endsWith(HISTORY_FILE_EXTENSION)) {
            this.mHistoryFileName = string2 + HISTORY_FILE_EXTENSION;
            return;
        }
        this.mHistoryFileName = string2;
    }

    static /* synthetic */ Context access$200(ActivityChooserModel activityChooserModel) {
        return activityChooserModel.mContext;
    }

    static /* synthetic */ String access$300() {
        return LOG_TAG;
    }

    static /* synthetic */ String access$400(ActivityChooserModel activityChooserModel) {
        return activityChooserModel.mHistoryFileName;
    }

    static /* synthetic */ boolean access$502(ActivityChooserModel activityChooserModel, boolean bl) {
        activityChooserModel.mCanReadHistoricalData = bl;
        return bl;
    }

    private boolean addHisoricalRecord(HistoricalRecord historicalRecord) {
        boolean bl = this.mHistoricalRecords.add(historicalRecord);
        if (bl) {
            this.mHistoricalRecordsChanged = true;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            this.persistHistoricalDataIfNeeded();
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
        return bl;
    }

    private void ensureConsistentState() {
        boolean bl = this.loadActivitiesIfNeeded();
        boolean bl2 = this.readHistoricalDataIfNeeded();
        this.pruneExcessiveHistoricalRecordsIfNeeded();
        if (bl | bl2) {
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ActivityChooserModel get(Context context, String string2) {
        Object object = sRegistryLock;
        synchronized (object) {
            ActivityChooserModel activityChooserModel;
            ActivityChooserModel activityChooserModel2 = activityChooserModel = sDataModelRegistry.get(string2);
            if (activityChooserModel == null) {
                activityChooserModel2 = new ActivityChooserModel(context, string2);
                sDataModelRegistry.put(string2, activityChooserModel2);
            }
            return activityChooserModel2;
        }
    }

    private boolean loadActivitiesIfNeeded() {
        boolean bl;
        boolean bl2 = bl = false;
        if (this.mReloadActivities) {
            bl2 = bl;
            if (this.mIntent != null) {
                this.mReloadActivities = false;
                this.mActivities.clear();
                List list = this.mContext.getPackageManager().queryIntentActivities(this.mIntent, 0);
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ResolveInfo resolveInfo = (ResolveInfo)list.get(i2);
                    this.mActivities.add(new ActivityResolveInfo(resolveInfo));
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void persistHistoricalDataIfNeeded() {
        if (!this.mReadShareHistoryCalled) {
            throw new IllegalStateException("No preceding call to #readHistoricalData");
        }
        if (!this.mHistoricalRecordsChanged) {
            return;
        }
        this.mHistoricalRecordsChanged = false;
        if (TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) return;
        AsyncTaskCompat.executeParallel((AsyncTask)new PersistHistoryAsyncTask(), (Object[])new Object[]{new ArrayList<HistoricalRecord>(this.mHistoricalRecords), this.mHistoryFileName});
    }

    /*
     * Enabled aggressive block sorting
     */
    private void pruneExcessiveHistoricalRecordsIfNeeded() {
        int n2 = this.mHistoricalRecords.size() - this.mHistoryMaxSize;
        if (n2 > 0) {
            this.mHistoricalRecordsChanged = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                HistoricalRecord historicalRecord = this.mHistoricalRecords.remove(0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readHistoricalDataIfNeeded() {
        boolean bl = true;
        if (!this.mCanReadHistoricalData) return false;
        if (!this.mHistoricalRecordsChanged) return false;
        if (TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) return false;
        this.mCanReadHistoricalData = false;
        this.mReadShareHistoryCalled = true;
        this.readHistoricalDataImpl();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readHistoricalDataImpl() {
        block22: {
            var1_1 = this.mContext.openFileInput(this.mHistoryFileName);
            try {}
            catch (Throwable var4_12) {
                if (var1_1 == null) throw var4_12;
                try {
                    var1_1.close();
                    throw var4_12;
                }
                catch (IOException var1_5) {
                    throw var4_12;
                }
            }
            ** try [egrp 2[TRYBLOCK] [1, 2 : 12->78)] { 
lbl13:
            // 1 sources

            ** GOTO lbl57
lbl14:
            // 1 sources

            catch (XmlPullParserException var5_13) {
                var4_10 /* !! */  = ActivityChooserModel.LOG_TAG;
                var2_7 = new StringBuilder();
                Log.e((String)var4_10 /* !! */ , (String)var2_7.append("Error reading historical recrod file: ").append(this.mHistoryFileName).toString(), (Throwable)var5_13);
                if (var1_1 == null) return;
                var1_1.close();
                return;
lbl23:
                // 1 sources

                catch (IOException var4_11) {
                    var2_7 = ActivityChooserModel.LOG_TAG;
                    var5_14 = new StringBuilder();
                    Log.e((String)var2_7, (String)var5_14.append("Error reading historical recrod file: ").append(this.mHistoryFileName).toString(), (Throwable)var4_11);
                    if (var1_1 == null) return;
                    try {
                        var1_1.close();
                        return;
                    }
                    catch (IOException var1_3) {
                        return;
                    }
                }
lbl34:
                // 1 sources

                while (true) {
                    if ((var3_8 = var2_7.next()) == 1) {
                        if (var1_1 == null) return;
                        try {
                            var1_1.close();
                            return;
                        }
                        catch (IOException var1_2) {
                            return;
                        }
                    }
                    if (var3_8 == 3 || var3_8 == 4) continue;
                    {
                        if ("historical-record".equals(var2_7.getName())) ** GOTO lbl-1000
                        var4_10 /* !! */  = new XmlPullParserException("Share records file not well-formed.");
                        throw var4_10 /* !! */ ;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var4_10 /* !! */  = var2_7.getAttributeValue(null, "activity");
                        var7_16 = Long.parseLong(var2_7.getAttributeValue(null, "time"));
                        var9_17 = Float.parseFloat(var2_7.getAttributeValue(null, "weight"));
                        var5_14 = new HistoricalRecord(var4_10 /* !! */ , var7_16, var9_17);
                        var6_15.add((HistoricalRecord)var5_14);
                        continue;
                    }
                    break;
                }
                catch (IOException var1_4) {
                    return;
                }
                catch (FileNotFoundException var1_6) {
                    return;
                }
lbl57:
                // 1 sources

                var2_7 = Xml.newPullParser();
                var2_7.setInput((InputStream)var1_1, "UTF-8");
                var3_8 = 0;
                while (var3_8 != 1 && var3_8 != 2) {
                    var3_8 = var2_7.next();
                }
                if ("historical-records".equals(var2_7.getName())) break block22;
                var4_9 = new XmlPullParserException("Share records file does not start with historical-records tag.");
                throw var4_9;
            }
        }
        var6_15 = this.mHistoricalRecords;
        var6_15.clear();
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sortActivitiesIfNeeded() {
        if (this.mActivitySorter == null) return false;
        if (this.mIntent == null) return false;
        if (this.mActivities.isEmpty()) return false;
        if (this.mHistoricalRecords.isEmpty()) return false;
        this.mActivitySorter.sort(this.mIntent, this.mActivities, Collections.unmodifiableList(this.mHistoricalRecords));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Intent chooseActivity(int n2) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Object object2;
            if (this.mIntent == null) {
                return null;
            }
            this.ensureConsistentState();
            ActivityResolveInfo activityResolveInfo = this.mActivities.get(n2);
            ComponentName componentName = new ComponentName(activityResolveInfo.resolveInfo.activityInfo.packageName, activityResolveInfo.resolveInfo.activityInfo.name);
            activityResolveInfo = new Intent(this.mIntent);
            activityResolveInfo.setComponent(componentName);
            if (this.mActivityChoserModelPolicy != null && this.mActivityChoserModelPolicy.onChooseActivity(this, (Intent)(object2 = new Intent((Intent)activityResolveInfo)))) {
                return null;
            }
            object2 = new HistoricalRecord(componentName, System.currentTimeMillis(), 1.0f);
            this.addHisoricalRecord((HistoricalRecord)object2);
            return activityResolveInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResolveInfo getActivity(int n2) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.get((int)n2).resolveInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getActivityCount() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.size();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getActivityIndex(ResolveInfo resolveInfo) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            List<ActivityResolveInfo> list = this.mActivities;
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                if (list.get((int)n3).resolveInfo == resolveInfo) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResolveInfo getDefaultActivity() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            if (this.mActivities.isEmpty()) return null;
            return this.mActivities.get((int)0).resolveInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHistoryMaxSize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mHistoryMaxSize;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHistorySize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mHistoricalRecords.size();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Intent getIntent() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mIntent;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setActivitySorter(ActivitySorter activitySorter) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter == activitySorter) {
                return;
            }
            this.mActivitySorter = activitySorter;
            if (!this.sortActivitiesIfNeeded()) return;
            this.notifyChanged();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDefaultActivity(int n2) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            Object object2 = this.mActivities.get(n2);
            ActivityResolveInfo activityResolveInfo = this.mActivities.get(0);
            float f2 = activityResolveInfo != null ? activityResolveInfo.weight - ((ActivityResolveInfo)object2).weight + 5.0f : 1.0f;
            activityResolveInfo = new ComponentName(((ActivityResolveInfo)object2).resolveInfo.activityInfo.packageName, ((ActivityResolveInfo)object2).resolveInfo.activityInfo.name);
            object2 = new HistoricalRecord((ComponentName)activityResolveInfo, System.currentTimeMillis(), f2);
            this.addHisoricalRecord((HistoricalRecord)object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHistoryMaxSize(int n2) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mHistoryMaxSize == n2) {
                return;
            }
            this.mHistoryMaxSize = n2;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            if (!this.sortActivitiesIfNeeded()) return;
            this.notifyChanged();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIntent(Intent intent) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mIntent == intent) {
                return;
            }
            this.mIntent = intent;
            this.mReloadActivities = true;
            this.ensureConsistentState();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnChooseActivityListener(OnChooseActivityListener onChooseActivityListener) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mActivityChoserModelPolicy = onChooseActivityListener;
            return;
        }
    }

    public static interface ActivityChooserModelClient {
        public void setActivityChooserModel(ActivityChooserModel var1);
    }

    public final class ActivityResolveInfo
    implements Comparable<ActivityResolveInfo> {
        public final ResolveInfo resolveInfo;
        public float weight;

        public ActivityResolveInfo(ResolveInfo resolveInfo) {
            this.resolveInfo = resolveInfo;
        }

        @Override
        public int compareTo(ActivityResolveInfo activityResolveInfo) {
            return Float.floatToIntBits(activityResolveInfo.weight) - Float.floatToIntBits(this.weight);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (ActivityResolveInfo)object;
            if (Float.floatToIntBits(this.weight) == Float.floatToIntBits(((ActivityResolveInfo)object).weight)) return bl;
            return false;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.weight) + 31;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append("resolveInfo:").append(this.resolveInfo.toString());
            stringBuilder.append("; weight:").append(new BigDecimal(this.weight));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static interface ActivitySorter {
        public void sort(Intent var1, List<ActivityResolveInfo> var2, List<HistoricalRecord> var3);
    }

    private final class DefaultSorter
    implements ActivitySorter {
        private static final float WEIGHT_DECAY_COEFFICIENT = 0.95f;
        private final Map<ComponentName, ActivityResolveInfo> mPackageNameToActivityMap = new HashMap<ComponentName, ActivityResolveInfo>();

        private DefaultSorter() {
        }

        @Override
        public void sort(Intent object, List<ActivityResolveInfo> list, List<HistoricalRecord> list2) {
            Object object2;
            int n2;
            object = this.mPackageNameToActivityMap;
            object.clear();
            int n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = list.get(n2);
                ((ActivityResolveInfo)object2).weight = 0.0f;
                object.put(new ComponentName(((ActivityResolveInfo)object2).resolveInfo.activityInfo.packageName, ((ActivityResolveInfo)object2).resolveInfo.activityInfo.name), object2);
            }
            n2 = list2.size();
            float f2 = 1.0f;
            --n2;
            while (n2 >= 0) {
                object2 = list2.get(n2);
                ActivityResolveInfo activityResolveInfo = (ActivityResolveInfo)object.get(((HistoricalRecord)object2).activity);
                if (activityResolveInfo != null) {
                    float f3 = activityResolveInfo.weight;
                    activityResolveInfo.weight = ((HistoricalRecord)object2).weight * f2 + f3;
                    f2 = 0.95f * f2;
                }
                --n2;
            }
            Collections.sort(list);
        }
    }

    public static final class HistoricalRecord {
        public final ComponentName activity;
        public final long time;
        public final float weight;

        public HistoricalRecord(ComponentName componentName, long l2, float f2) {
            this.activity = componentName;
            this.time = l2;
            this.weight = f2;
        }

        public HistoricalRecord(String string2, long l2, float f2) {
            this(ComponentName.unflattenFromString((String)string2), l2, f2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (HistoricalRecord)object;
            if (this.activity == null ? ((HistoricalRecord)object).activity != null : !this.activity.equals((Object)((HistoricalRecord)object).activity)) {
                return false;
            }
            if (this.time != ((HistoricalRecord)object).time) {
                return false;
            }
            if (Float.floatToIntBits(this.weight) == Float.floatToIntBits(((HistoricalRecord)object).weight)) return bl;
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n2;
            if (this.activity == null) {
                n2 = 0;
                return ((n2 + 31) * 31 + (int)(this.time ^ this.time >>> 32)) * 31 + Float.floatToIntBits(this.weight);
            }
            n2 = this.activity.hashCode();
            return ((n2 + 31) * 31 + (int)(this.time ^ this.time >>> 32)) * 31 + Float.floatToIntBits(this.weight);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append("; activity:").append(this.activity);
            stringBuilder.append("; time:").append(this.time);
            stringBuilder.append("; weight:").append(new BigDecimal(this.weight));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static interface OnChooseActivityListener {
        public boolean onChooseActivity(ActivityChooserModel var1, Intent var2);
    }

    private final class PersistHistoryAsyncTask
    extends AsyncTask<Object, Void, Void> {
        private PersistHistoryAsyncTask() {
        }

        /*
         * Exception decompiling
         */
        public Void doInBackground(Object ... var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

