/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v7.appcompat.R;
import android.support.v7.widget.ActionMenuPresenter;
import android.support.v7.widget.ActionMenuView;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

abstract class AbsActionBarView
extends ViewGroup {
    private static final int FADE_DURATION = 200;
    protected ActionMenuPresenter mActionMenuPresenter;
    protected int mContentHeight;
    private boolean mEatingHover;
    private boolean mEatingTouch;
    protected ActionMenuView mMenuView;
    protected final Context mPopupContext;
    protected final VisibilityAnimListener mVisAnimListener = new VisibilityAnimListener();
    protected ViewPropertyAnimatorCompat mVisibilityAnim;

    AbsActionBarView(Context context) {
        this(context, null);
    }

    AbsActionBarView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    AbsActionBarView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        attributeSet = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.actionBarPopupTheme, (TypedValue)attributeSet, true) && attributeSet.resourceId != 0) {
            this.mPopupContext = new ContextThemeWrapper(context, attributeSet.resourceId);
            return;
        }
        this.mPopupContext = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int next(int n2, int n3, boolean bl) {
        if (bl) {
            n2 -= n3;
            return n2;
        }
        n2 += n3;
        return n2;
    }

    public void animateToVisibility(int n2) {
        this.setupAnimatorToVisibility(n2, 200L).start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canShowOverflowMenu() {
        if (!this.isOverflowReserved()) return false;
        if (this.getVisibility() != 0) return false;
        return true;
    }

    public void dismissPopupMenus() {
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAnimatedVisibility() {
        if (this.mVisibilityAnim == null) return this.getVisibility();
        return this.mVisAnimListener.mFinalVisibility;
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hideOverflowMenu() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.hideOverflowMenu();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowPending() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.isOverflowMenuShowPending();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowing() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.isOverflowMenuShowing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowReserved() {
        if (this.mActionMenuPresenter == null) return false;
        if (!this.mActionMenuPresenter.isOverflowReserved()) return false;
        return true;
    }

    protected int measureChildView(View view, int n2, int n3, int n4) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)Integer.MIN_VALUE), n3);
        return Math.max(0, n2 - view.getMeasuredWidth() - n4);
    }

    protected void onConfigurationChanged(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(configuration);
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(null, R.styleable.ActionBar, R.attr.actionBarStyle, 0);
        this.setContentHeight(typedArray.getLayoutDimension(R.styleable.ActionBar_height, 0));
        typedArray.recycle();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.onConfigurationChanged(configuration);
        }
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionMasked((MotionEvent)motionEvent);
        if (n2 == 9) {
            this.mEatingHover = false;
        }
        if (!this.mEatingHover) {
            boolean bl = super.onHoverEvent(motionEvent);
            if (n2 == 9 && !bl) {
                this.mEatingHover = true;
            }
        }
        if (n2 == 10 || n2 == 3) {
            this.mEatingHover = false;
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionMasked((MotionEvent)motionEvent);
        if (n2 == 0) {
            this.mEatingTouch = false;
        }
        if (!this.mEatingTouch) {
            boolean bl = super.onTouchEvent(motionEvent);
            if (n2 == 0 && !bl) {
                this.mEatingTouch = true;
            }
        }
        if (n2 == 1 || n2 == 3) {
            this.mEatingTouch = false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int positionChild(View view, int n2, int n3, int n4, boolean bl) {
        int n5 = view.getMeasuredWidth();
        int n6 = view.getMeasuredHeight();
        n3 = (n4 - n6) / 2 + n3;
        if (bl) {
            view.layout(n2 - n5, n3, n2, n6 + n3);
        } else {
            view.layout(n2, n3, n2 + n5, n6 + n3);
        }
        n2 = n5;
        if (!bl) return n2;
        return -n5;
    }

    public void postShowOverflowMenu() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AbsActionBarView.this.showOverflowMenu();
            }
        });
    }

    public void setContentHeight(int n2) {
        this.mContentHeight = n2;
        this.requestLayout();
    }

    public void setVisibility(int n2) {
        if (n2 != this.getVisibility()) {
            if (this.mVisibilityAnim != null) {
                this.mVisibilityAnim.cancel();
            }
            super.setVisibility(n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ViewPropertyAnimatorCompat setupAnimatorToVisibility(int n2, long l2) {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat;
        if (this.mVisibilityAnim != null) {
            this.mVisibilityAnim.cancel();
        }
        if (n2 == 0) {
            if (this.getVisibility() != 0) {
                ViewCompat.setAlpha((View)this, (float)0.0f);
            }
            viewPropertyAnimatorCompat = ViewCompat.animate((View)this).alpha(1.0f);
            viewPropertyAnimatorCompat.setDuration(l2);
            viewPropertyAnimatorCompat.setListener((ViewPropertyAnimatorListener)this.mVisAnimListener.withFinalVisibility(viewPropertyAnimatorCompat, n2));
            return viewPropertyAnimatorCompat;
        }
        viewPropertyAnimatorCompat = ViewCompat.animate((View)this).alpha(0.0f);
        viewPropertyAnimatorCompat.setDuration(l2);
        viewPropertyAnimatorCompat.setListener((ViewPropertyAnimatorListener)this.mVisAnimListener.withFinalVisibility(viewPropertyAnimatorCompat, n2));
        return viewPropertyAnimatorCompat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.showOverflowMenu();
    }

    protected class VisibilityAnimListener
    implements ViewPropertyAnimatorListener {
        private boolean mCanceled = false;
        int mFinalVisibility;

        protected VisibilityAnimListener() {
        }

        public void onAnimationCancel(View view) {
            this.mCanceled = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onAnimationEnd(View view) {
            if (this.mCanceled) {
                return;
            }
            AbsActionBarView.this.mVisibilityAnim = null;
            AbsActionBarView.super.setVisibility(this.mFinalVisibility);
        }

        public void onAnimationStart(View view) {
            AbsActionBarView.super.setVisibility(0);
            this.mCanceled = false;
        }

        public VisibilityAnimListener withFinalVisibility(ViewPropertyAnimatorCompat viewPropertyAnimatorCompat, int n2) {
            AbsActionBarView.this.mVisibilityAnim = viewPropertyAnimatorCompat;
            this.mFinalVisibility = n2;
            return this;
        }
    }
}

