/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuView;
import android.support.v7.widget.ActionMenuView;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.ListPopupWindow;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;

public class ActionMenuItemView
extends AppCompatTextView
implements MenuView.ItemView,
ActionMenuView.ActionMenuChildView,
View.OnClickListener,
View.OnLongClickListener {
    private static final int MAX_ICON_SIZE = 32;
    private static final String TAG = "ActionMenuItemView";
    private boolean mAllowTextWithIcon;
    private boolean mExpandedFormat;
    private ListPopupWindow.ForwardingListener mForwardingListener;
    private Drawable mIcon;
    private MenuItemImpl mItemData;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private int mMaxIconSize;
    private int mMinWidth;
    private PopupCallback mPopupCallback;
    private int mSavedPaddingLeft;
    private CharSequence mTitle;

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        Resources resources = context.getResources();
        this.mAllowTextWithIcon = resources.getBoolean(R.bool.abc_config_allowActionMenuItemTextWithIcon);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.ActionMenuItemView, n2, 0);
        this.mMinWidth = context.getDimensionPixelSize(R.styleable.ActionMenuItemView_android_minWidth, 0);
        context.recycle();
        this.mMaxIconSize = (int)(resources.getDisplayMetrics().density * 32.0f + 0.5f);
        this.setOnClickListener(this);
        this.setOnLongClickListener(this);
        this.mSavedPaddingLeft = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTextButtonVisibility() {
        boolean bl;
        boolean bl2;
        block3: {
            block2: {
                boolean bl3 = false;
                bl2 = !TextUtils.isEmpty((CharSequence)this.mTitle);
                if (this.mIcon == null) break block2;
                bl = bl3;
                if (!this.mItemData.showsTextAsAction()) break block3;
                if (this.mAllowTextWithIcon) break block2;
                bl = bl3;
                if (!this.mExpandedFormat) break block3;
            }
            bl = true;
        }
        CharSequence charSequence = bl2 & bl ? this.mTitle : null;
        this.setText(charSequence);
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasText() {
        if (TextUtils.isEmpty((CharSequence)this.getText())) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n2) {
        this.mItemData = menuItemImpl;
        this.setIcon(menuItemImpl.getIcon());
        this.setTitle(menuItemImpl.getTitleForItemView((MenuView.ItemView)this));
        this.setId(menuItemImpl.getItemId());
        n2 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n2);
        this.setEnabled(menuItemImpl.isEnabled());
        if (menuItemImpl.hasSubMenu() && this.mForwardingListener == null) {
            this.mForwardingListener = new ActionMenuItemForwardingListener();
        }
    }

    @Override
    public boolean needsDividerAfter() {
        return this.hasText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean needsDividerBefore() {
        if (!this.hasText()) return false;
        if (this.mItemData.getIcon() != null) return false;
        return true;
    }

    public void onClick(View view) {
        if (this.mItemInvoker != null) {
            this.mItemInvoker.invokeItem(this.mItemData);
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(configuration);
        }
        this.mAllowTextWithIcon = this.getContext().getResources().getBoolean(R.bool.abc_config_allowActionMenuItemTextWithIcon);
        this.updateTextButtonVisibility();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onLongClick(View view) {
        if (this.hasText()) {
            return false;
        }
        int[] nArray = new int[2];
        Rect rect = new Rect();
        this.getLocationOnScreen(nArray);
        this.getWindowVisibleDisplayFrame(rect);
        Context context = this.getContext();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = nArray[1];
        int n5 = n3 / 2;
        int n6 = nArray[0];
        n6 = n2 = n2 / 2 + n6;
        if (ViewCompat.getLayoutDirection((View)view) == 0) {
            n6 = context.getResources().getDisplayMetrics().widthPixels - n2;
        }
        view = Toast.makeText((Context)context, (CharSequence)this.mItemData.getTitle(), (int)0);
        if (n4 + n5 < rect.height()) {
            view.setGravity(8388661, n6, nArray[1] + n3 - rect.top);
        } else {
            view.setGravity(81, 0, n3);
        }
        view.show();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        boolean bl = this.hasText();
        if (bl && this.mSavedPaddingLeft >= 0) {
            super.setPadding(this.mSavedPaddingLeft, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        super.onMeasure(n2, n3);
        int n4 = View.MeasureSpec.getMode((int)n2);
        n2 = View.MeasureSpec.getSize((int)n2);
        int n5 = this.getMeasuredWidth();
        n2 = n4 == Integer.MIN_VALUE ? Math.min(n2, this.mMinWidth) : this.mMinWidth;
        if (n4 != 0x40000000 && this.mMinWidth > 0 && n5 < n2) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000), n3);
        }
        if (!bl && this.mIcon != null) {
            super.setPadding((this.getMeasuredWidth() - this.mIcon.getBounds().width()) / 2, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mItemData.hasSubMenu()) return super.onTouchEvent(motionEvent);
        if (this.mForwardingListener == null) return super.onTouchEvent(motionEvent);
        if (!this.mForwardingListener.onTouch((View)this, motionEvent)) return super.onTouchEvent(motionEvent);
        return true;
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    @Override
    public void setCheckable(boolean bl) {
    }

    @Override
    public void setChecked(boolean bl) {
    }

    public void setExpandedFormat(boolean bl) {
        if (this.mExpandedFormat != bl) {
            this.mExpandedFormat = bl;
            if (this.mItemData != null) {
                this.mItemData.actionFormatChanged();
            }
        }
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 != null) {
            float f2;
            int n2;
            int n3 = drawable2.getIntrinsicWidth();
            int n4 = n2 = drawable2.getIntrinsicHeight();
            int n5 = n3;
            if (n3 > this.mMaxIconSize) {
                f2 = (float)this.mMaxIconSize / (float)n3;
                n5 = this.mMaxIconSize;
                n4 = (int)((float)n2 * f2);
            }
            n3 = n4;
            n2 = n5;
            if (n4 > this.mMaxIconSize) {
                f2 = (float)this.mMaxIconSize / (float)n4;
                n3 = this.mMaxIconSize;
                n2 = (int)((float)n5 * f2);
            }
            drawable2.setBounds(0, 0, n2, n3);
        }
        this.setCompoundDrawables(drawable2, null, null, null);
        this.updateTextButtonVisibility();
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    public void setPadding(int n2, int n3, int n4, int n5) {
        this.mSavedPaddingLeft = n2;
        super.setPadding(n2, n3, n4, n5);
    }

    public void setPopupCallback(PopupCallback popupCallback) {
        this.mPopupCallback = popupCallback;
    }

    @Override
    public void setShortcut(boolean bl, char c2) {
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.setContentDescription(this.mTitle);
        this.updateTextButtonVisibility();
    }

    @Override
    public boolean showsIcon() {
        return true;
    }

    private class ActionMenuItemForwardingListener
    extends ListPopupWindow.ForwardingListener {
        public ActionMenuItemForwardingListener() {
            super((View)ActionMenuItemView.this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ListPopupWindow getPopup() {
            if (ActionMenuItemView.this.mPopupCallback == null) return null;
            return ActionMenuItemView.this.mPopupCallback.getPopup();
        }

        @Override
        protected boolean onForwardingStarted() {
            boolean bl;
            boolean bl2 = bl = false;
            if (ActionMenuItemView.this.mItemInvoker != null) {
                bl2 = bl;
                if (ActionMenuItemView.this.mItemInvoker.invokeItem(ActionMenuItemView.this.mItemData)) {
                    ListPopupWindow listPopupWindow = this.getPopup();
                    bl2 = bl;
                    if (listPopupWindow != null) {
                        bl2 = bl;
                        if (listPopupWindow.isShowing()) {
                            bl2 = true;
                        }
                    }
                }
            }
            return bl2;
        }
    }

    public static abstract class PopupCallback {
        public abstract ListPopupWindow getPopup();
    }
}

